/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.common.icons.DialogIcon;
import com.mathworks.help.helpui.DocLocation;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.html.Url;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.explorer.model.ExplorerPrefs;
import com.mathworks.mlwidgets.help.DocCenterDocConfig;
import com.mathworks.mlwidgets.help.DocCenterProductPrefs;
import com.mathworks.mlwidgets.help.DocCenterRoot;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.help.InstalledProductUtils;
import com.mathworks.mlwidgets.help.MLProductFilter;
import com.mathworks.mlwidgets.help.ProductFilterModel;
import com.mathworks.mlwidgets.help.WebConnectivityStatus;
import com.mathworks.mlwidgets.html.HtmlComponentFactory;
import com.mathworks.mlwidgets.html.LanguageLocale;
import com.mathworks.mlwidgets.util.productinfo.ProductInfoUtils;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.product.util.ProductIdentifier;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.services.settings.Setting;
import com.mathworks.services.settings.SettingAdapter;
import com.mathworks.services.settings.SettingChangeEvent;
import com.mathworks.services.settings.SettingException;
import com.mathworks.services.settings.SettingListener;
import com.mathworks.services.settings.SettingPath;
import com.mathworks.util.LanguageUtils;
import java.io.File;
import java.util.Collection;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Icon;

public class HelpPrefs {
    public static final String DEFAULT_DOC_RELEASE = InstutilResourceKeys.RELEASE.getString(new Object[0]);
    public static final String DOC_CENTER_LOCATION = "DocCenterLocation";
    private static final String SHOW_HELP_BROWSER = "PopupShowsBrowser";
    private static final DocCenterRoot DOC_CENTER_ROOT = new DocCenterRoot();
    private static DocInstalledState sDocInstalled = DocInstalledState.UNKNOWN;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.mlwidgets.help.resources.RES_HelpInfo");
    private static HelpPrefsDependencyProvider sDependencyProvider = new DefaultDependencyProvider();
    public static final SettingPath HelpNode = HelpPrefs.getSettingPath("matlab", "desktop", "help");
    public static final Setting<String> DocLanguage = HelpPrefs.getSetting(HelpNode, String.class, "DocLanguage");

    private HelpPrefs() {
    }

    public static boolean setDocRoot(String string) {
        DOC_CENTER_ROOT.setDocRoot(string);
        if (sDependencyProvider.isMatlabAvailable()) {
            HelpPrefs.updateDocInstalled();
        } else {
            HelpPrefs.setDocInstalled(DocInstalledState.DOC_INSTALLED);
        }
        return HelpPrefs.isDocInstalled();
    }

    public static void addProduct(String string) {
        ProductInfoUtils.addProduct(string);
    }

    public static boolean useEnglishDoc(boolean bl) {
        Locale locale = bl ? Locale.ENGLISH : LanguageUtils.getHelpLocale();
        return HelpPrefs.setDocLocale(locale);
    }

    public static boolean setDocLocale(Locale locale) {
        if (locale == null || !locale.equals(LanguageUtils.getHelpLocale()) && !HelpPrefs.isLocalizedDocInstalled(locale)) {
            return false;
        }
        boolean bl = HelpPrefs.setLanguageInHelp(locale);
        if (bl) {
            LanguageLocale languageLocale = HelpUtils.getLanguageLocale();
            Locale locale2 = languageLocale.getLocale();
            if (sDependencyProvider.isMatlabAvailable() && !locale2.equals(HelpPrefs.getDocLocale()) && DocLanguage != null) {
                try {
                    DocLanguage.set((Object)languageLocale.getLocaleString());
                }
                catch (SettingException settingException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    public static Locale getDocLocale() {
        String string = "";
        if (DocLanguage != null) {
            try {
                string = (String)DocLanguage.get();
            }
            catch (SettingException settingException) {
                // empty catch block
            }
        }
        if (!string.isEmpty()) {
            return LanguageUtils.createLocaleForLangLocaleString((String)string);
        }
        return null;
    }

    private static boolean setLanguageInHelp(Locale locale) {
        HelpUtils.setLanguageLocale(locale);
        HelpPrefs.updateDocInstalled();
        return HelpPrefs.isDocInstalled();
    }

    private static void updateDocInstalled() {
        DocInstalledState docInstalledState = !sDependencyProvider.isMatlabAvailable() ? DocInstalledState.DOC_INSTALLED : DocInstalledState.DOC_NOT_INSTALLED;
        String string = DOC_CENTER_ROOT.getDocRoot();
        File file = new File(string, "docset.xml");
        if (file.exists()) {
            docInstalledState = DocInstalledState.DOC_INSTALLED;
        }
        HelpPrefs.setDocInstalled(docInstalledState);
    }

    static synchronized boolean isDocInstalled() {
        if (sDocInstalled.equals((Object)DocInstalledState.UNKNOWN)) {
            HelpPrefs.updateDocInstalled();
        }
        return sDocInstalled.equals((Object)DocInstalledState.DOC_INSTALLED);
    }

    private static synchronized void setDocInstalled(DocInstalledState docInstalledState) {
        sDocInstalled = docInstalledState;
    }

    public static boolean isLocalizedDocInstalled(Locale locale) {
        return locale != null && LanguageLocale.isSupported(locale) && HelpPrefs.isLocalizedDocInstalled(LanguageLocale.getSupportedLanguageLocale(locale));
    }

    private static boolean isLocalizedDocInstalled(LanguageLocale languageLocale) {
        return languageLocale != null && DOC_CENTER_ROOT.getDocRoot() != null && HelpPrefs.isLocalizedDocCenterDocInstalled(languageLocale);
    }

    private static boolean isLocalizedDocCenterDocInstalled(LanguageLocale languageLocale) {
        boolean bl = new File(DOC_CENTER_ROOT.getDocRoot()).exists();
        if (!languageLocale.equals((Object)LanguageLocale.ENGLISH)) {
            String string = DOC_CENTER_ROOT.getDocRoot() + File.separator + "documentation-center_" + languageLocale.getLocaleString() + ".html";
            bl = new File(string).exists();
        }
        return bl;
    }

    public static String getDocRoot() {
        return DOC_CENTER_ROOT.getDocRoot();
    }

    public static boolean setDocCenterRoot(String string) {
        DOC_CENTER_ROOT.setContentDocRoot(string);
        if (sDependencyProvider.isMatlabAvailable()) {
            HelpPrefs.updateDocInstalled();
        } else {
            HelpPrefs.setDocInstalled(DocInstalledState.DOC_INSTALLED);
        }
        return HelpPrefs.isDocInstalled();
    }

    public static String getDocCenterRoot() {
        return DOC_CENTER_ROOT.getContentDocRoot();
    }

    public static String getDocCenterWebRoot() {
        return DOC_CENTER_ROOT.getDocWebRoot();
    }

    public static boolean setDocCenterDomain(String string) {
        return DOC_CENTER_ROOT.setDocCenterDomain(string);
    }

    public static String getDocCenterDomain() {
        return DOC_CENTER_ROOT.getDocCenterDomain();
    }

    public static void setDocCenterLocation(String string) {
        DocLocation docLocation = HelpPrefs.getDocLocation(string);
        HelpPrefs.setDocCenterLocation(docLocation);
    }

    private static void setDocCenterLocation(DocLocation docLocation) {
        if (docLocation != null) {
            HelpPrefs.setStringPref("HelpDocCenterLocation", docLocation.toString());
        }
    }

    public static DocLocation getDocCenterLocation() {
        String string = HelpPrefs.getStringPref("HelpDocCenterLocation", "");
        DocLocation docLocation = HelpPrefs.getDocLocation(string);
        if (docLocation != null && docLocation == DocLocation.WEB) {
            if (WebConnectivityStatus.isOffline(HelpPrefs.getDocCenterDomain())) {
                HelpPrefs.setDocCenterLocation(DocLocation.INSTALLED);
                docLocation = DocLocation.INSTALLED;
                MJOptionPane.showMessageDialog(null, (Object)BUNDLE.getString("prefs.web_doccenter_notreachable.text"), (String)BUNDLE.getString("prefs.web_doccenter_notreachable.title"), (int)0, (Icon)DialogIcon.INFO_32x32.getIcon());
            } else if (!HelpPrefs.isDocLocationOnWebSupported()) {
                HelpPrefs.setDocCenterLocation(DocLocation.INSTALLED);
                docLocation = DocLocation.INSTALLED;
            }
        }
        return docLocation != null ? docLocation : DocLocation.INSTALLED;
    }

    static DocLocation getDocLocation(String string) {
        if (string != null) {
            try {
                return DocLocation.valueOf((String)string.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public static boolean isDocLocationOnWebSupported() {
        HtmlComponentFactory.HtmlComponentType htmlComponentType = HtmlComponentFactory.getExpectedHtmlComponentType(HtmlComponentFactory.HtmlComponentType.FOLLOW_PREFERENCE, HtmlComponentFactory.HtmlComponentType.CHROMIUM, HtmlComponentFactory.HtmlComponentType.HTMLPANEL, HtmlComponentFactory.HtmlComponentType.HTMLRENDERER);
        return htmlComponentType == HtmlComponentFactory.HtmlComponentType.HTMLPANEL || htmlComponentType == HtmlComponentFactory.HtmlComponentType.CHROMIUM;
    }

    public static String replacePathWithDocCenterPath(String string) {
        String string2 = string;
        if (!HelpPrefs.getDocRoot().equals(HelpPrefs.getDocCenterRoot())) {
            string2 = string2.replace(File.separatorChar, '/').replace(HelpPrefs.getDocRoot(), HelpPrefs.getDocCenterRoot());
        }
        return string2;
    }

    public static String replacePathWithInstalledDocPath(String string) {
        String string2 = string;
        if (!HelpPrefs.getDocRoot().equals(HelpPrefs.getDocCenterRoot())) {
            StringBuilder stringBuilder;
            boolean bl;
            StringBuilder stringBuilder2 = new StringBuilder(HelpPrefs.getDocCenterRoot());
            boolean bl2 = stringBuilder2.toString().endsWith("/");
            if (bl2 != (bl = (stringBuilder = new StringBuilder(HelpPrefs.getDocRoot())).toString().endsWith("/"))) {
                if (!bl2) {
                    stringBuilder2.append("/");
                } else {
                    stringBuilder.append("/");
                }
            }
            string2 = string2.replace(File.separatorChar, '/').replace(stringBuilder2.toString(), stringBuilder.toString());
        }
        string2 = HelpUtils.getLocalizedFilename(string2);
        return string2;
    }

    public static String replacePathWithWebDocCenterLink(String string) {
        String string2 = string;
        String string3 = HelpPrefs.getDocCenterRoot();
        int n = string2.lastIndexOf(string3);
        if (n != -1) {
            String string4 = HelpPrefs.getDocCenterWebRoot();
            String string5 = string2.substring(n + string3.length());
            string2 = string4.endsWith("/") && string5.startsWith("/") ? string4 + string5.substring(1) : string4 + string5;
        }
        return string2;
    }

    public static boolean isInstalledProductSelected(String string) {
        Set<ProductIdentifier> set = HelpPrefs.getSelectedInstalledProducts();
        ProductIdentifier productIdentifier = ProductIdentifier.get((String)string);
        return productIdentifier != null && set.contains(productIdentifier);
    }

    @Deprecated
    public static boolean isDocCenterProductFilterEnabled() {
        return !HelpPrefs.getProductFilterModel().areAllProductsSelected(ProductFilterModel.InstalledState.INSTALLED);
    }

    public static Set<ProductIdentifier> getSelectedInstalledProducts() {
        return HelpPrefs.getProductFilterModel().getSelectedProducts(ProductFilterModel.InstalledState.INSTALLED);
    }

    private static ProductFilterModel getProductFilterModel() {
        return DocCenterProductPrefs.getProductFilterModel();
    }

    public static boolean isUninstalledProductSelected(String string) {
        ProductIdentifier productIdentifier = ProductIdentifier.get((String)string);
        Set<ProductIdentifier> set = HelpPrefs.getSelectedUninstalledProducts();
        return productIdentifier != null && set.contains(productIdentifier);
    }

    public static Set<ProductIdentifier> getSelectedUninstalledProducts() {
        return HelpPrefs.getProductFilterModel().getSelectedProducts(ProductFilterModel.InstalledState.UNINSTALLED);
    }

    public static boolean isShowUninstalledProducts() {
        ProductFilterModel productFilterModel = HelpPrefs.getProductFilterModel();
        return productFilterModel.getInstalledState() == ProductFilterModel.InstalledState.ALL;
    }

    static void setShowHelpBrowserPreference(boolean bl) {
        HelpPrefs.setBooleanPref("HelpPopupShowsBrowser", bl);
    }

    static boolean getShowHelpBrowserPreference() {
        return HelpPrefs.getBooleanPref("HelpPopupShowsBrowser", false);
    }

    public static void addPrefsListeners(PrefListener prefListener, String ... stringArray) {
        if (sDependencyProvider.isMatlabAvailable()) {
            for (String string : stringArray) {
                Prefs.addListener((PrefListener)prefListener, (String)string);
            }
        }
    }

    public static void removePrefsListeners(PrefListener prefListener, String ... stringArray) {
        if (sDependencyProvider.isMatlabAvailable()) {
            for (String string : stringArray) {
                Prefs.removeListener((PrefListener)prefListener, (String)string);
            }
        }
    }

    private static void setBooleanPref(String string, boolean bl) {
        if (sDependencyProvider.isMatlabAvailable()) {
            Prefs.setBooleanPref((String)string, (boolean)bl);
        }
    }

    private static boolean getBooleanPref(String string, boolean bl) {
        return sDependencyProvider.isMatlabAvailable() ? Prefs.getBooleanPref((String)string, (boolean)bl) : bl;
    }

    private static void setStringPref(String string, String string2) {
        if (sDependencyProvider.isMatlabAvailable()) {
            Prefs.setStringPref((String)string, (String)string2);
        }
    }

    private static String getStringPref(String string, String string2) {
        return sDependencyProvider.isMatlabAvailable() ? Prefs.getStringPref((String)string, (String)string2) : string2;
    }

    public static synchronized Collection<DocProduct> getInstalledDocProducts() {
        return InstalledProductUtils.getInstalledDocProducts();
    }

    public static synchronized Collection<ProductIdentifier> getInstalledProducts() {
        return InstalledProductUtils.getInstalledProducts();
    }

    public static synchronized Collection<ProductIdentifier> getUninstalledProducts() {
        return InstalledProductUtils.getUninstalledProducts();
    }

    public static boolean isInstalledDocProductSelected(DocProduct docProduct) {
        DocCenterDocConfig<Url> docCenterDocConfig = DocCenterDocConfig.getInstance();
        DocumentationSet documentationSet = docCenterDocConfig.getDocumentationSet();
        return HelpPrefs.isInstalledDocProductSelected(docProduct, documentationSet);
    }

    public static boolean isInstalledDocProductSelected(DocProduct docProduct, DocumentationSet documentationSet) {
        if (docProduct == null || documentationSet == null) {
            return false;
        }
        MLProductFilter mLProductFilter = new MLProductFilter(documentationSet, HelpPrefs.getProductFilterModel());
        return mLProductFilter.isProductEnabled(docProduct);
    }

    private static synchronized void setDependencyProvider(HelpPrefsDependencyProvider helpPrefsDependencyProvider) {
        sDependencyProvider = helpPrefsDependencyProvider;
    }

    private static synchronized HelpPrefsDependencyProvider getDependencyProvider() {
        return sDependencyProvider;
    }

    private static SettingPath getSettingPath(String ... stringArray) {
        if (sDependencyProvider.isMatlabAvailable()) {
            try {
                return new SettingPath(new SettingPath(), stringArray);
            }
            catch (SettingException settingException) {
                throw new IllegalArgumentException(settingException);
            }
        }
        return null;
    }

    private static <T> Setting<T> getSetting(SettingPath settingPath, Class<T> clazz, String string) {
        if (sDependencyProvider.isMatlabAvailable()) {
            try {
                return new Setting(settingPath, clazz, string);
            }
            catch (SettingException settingException) {
                throw new IllegalArgumentException(settingException);
            }
        }
        return null;
    }

    static {
        if (sDependencyProvider.isMatlabAvailable()) {
            Prefs.mapPrefsToSettings((String)(ExplorerPrefs.History.getFactoryDir() + "//matlab//settings//help.csv"));
            SettingAdapter settingAdapter = new SettingAdapter(){

                public void settingChanged(SettingChangeEvent settingChangeEvent) {
                    HelpPrefs.setLanguageInHelp(HelpPrefs.getDocLocale());
                }
            };
            try {
                DocLanguage.addListener((SettingListener)settingAdapter);
            }
            catch (SettingException settingException) {
                throw new RuntimeException(settingException);
            }
        }
    }

    private static class DefaultDependencyProvider
    implements HelpPrefsDependencyProvider {
        private DefaultDependencyProvider() {
        }

        @Override
        public boolean isMatlabAvailable() {
            return Matlab.isMatlabAvailable();
        }
    }

    public static interface HelpPrefsDependencyProvider {
        public boolean isMatlabAvailable();
    }

    private static enum DocInstalledState {
        DOC_INSTALLED,
        DOC_NOT_INSTALLED,
        UNKNOWN;

    }
}

