/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search.lucene;

import com.mathworks.mlwidgets.help.search.DocPageType;
import com.mathworks.mlwidgets.help.search.DocSearchField;
import com.mathworks.mlwidgets.help.search.DocSearchResult;
import com.mathworks.mlwidgets.help.search.RankedSearchResult;
import com.mathworks.mlwidgets.help.search.RefEntityType;
import com.mathworks.mlwidgets.help.search.ResultType;
import com.mathworks.mlwidgets.help.search.SearchUtils;
import org.apache.lucene.document.Document;

public class LuceneDocSearchResult
implements DocSearchResult {
    private Document fDocument;
    private String fProduct;
    private float fScore;
    private String fUrlPrefix;

    LuceneDocSearchResult(Document document) {
        this.fDocument = document;
    }

    @Override
    public String getTitle() {
        return this.fDocument.get(DocSearchField.TITLE.getFieldName());
    }

    @Override
    public String getSection() {
        return this.fDocument.get(DocSearchField.SECTION.getFieldName());
    }

    @Override
    public boolean isReferencePage() {
        String string = this.fDocument.get(DocSearchField.REFERENCE_PAGE.getFieldName());
        return string != null && !string.equals(DocPageType.NOT_REFERENCE_PAGE.getIndexString());
    }

    @Override
    public String getRefPageSummary() {
        return this.fDocument.get(DocSearchField.REFPAGE_SUMMARY.getFieldName());
    }

    @Override
    public String getRefPageFunction() {
        return this.fDocument.get(DocSearchField.REFPAGE_FUNCTION_NAME.getFieldName());
    }

    private String getRelativePath() {
        String string = this.fDocument.get(DocSearchField.RELATIVE_PATH.getFieldName());
        String string2 = this.fDocument.get(DocSearchField.ANCHOR.getFieldName());
        if (string2 != null) {
            return string + "#" + string2;
        }
        return string;
    }

    private String getUrlPrefix() {
        return this.fUrlPrefix;
    }

    void setUrlPrefix(String string) {
        this.fUrlPrefix = string;
    }

    @Override
    public String getFullUrl() {
        return this.getUrlPrefix() + this.getRelativePath();
    }

    @Override
    public String getFilename() {
        return this.fDocument.get(DocSearchField.FILENAME.getFieldName());
    }

    @Override
    public String getProduct() {
        return this.fProduct;
    }

    void setProduct(String string) {
        this.fProduct = string;
    }

    @Override
    public String getBody() {
        return this.fDocument.get(DocSearchField.BODY.getFieldName());
    }

    @Override
    public ResultType getResultType() {
        String string = this.fDocument.get(DocSearchField.RESULT_TYPE.getFieldName());
        if (string != null) {
            return ResultType.fromKey(string);
        }
        return null;
    }

    @Override
    public RefEntityType getReferenceEntityType() {
        String string = this.fDocument.get(DocSearchField.REFPAGE_ENTITY.getFieldName());
        if (string == null) {
            return null;
        }
        if (string.indexOf(58) > 0) {
            string = string.substring(string.lastIndexOf(58) + 1);
        }
        return RefEntityType.resolve(string);
    }

    @Override
    public String getReferenceEntity() {
        String string = this.fDocument.get(DocSearchField.REFPAGE_ENTITY.getFieldName());
        return SearchUtils.getEntityNameFromIndexString(string);
    }

    @Override
    public float getScore() {
        return this.fScore;
    }

    void setScore(float f) {
        this.fScore = f;
    }

    @Override
    public String getFileEncoding() {
        return this.fDocument.get(DocSearchField.CHARSET.getFieldName());
    }

    @Override
    public int compareTo(RankedSearchResult rankedSearchResult) {
        return new Float(rankedSearchResult.getScore()).compareTo(Float.valueOf(this.getScore()));
    }
}

