/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.SystemBrowserStrategy;
import com.mathworks.html.Url;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.MatlabMCR;

public class MatlabSystemBrowserStrategy
implements SystemBrowserStrategy {
    public void openSystemBrowser(Url url, HtmlDataListener<Boolean> htmlDataListener) {
        Object[] objectArray = MatlabSystemBrowserStrategy.buildWebCommandArgs(url);
        this.executeWebCommand(objectArray, htmlDataListener);
    }

    private static Object[] buildWebCommandArgs(Url url) {
        return new Object[]{url.toString(), "-browser"};
    }

    protected void executeWebCommand(Object[] objectArray, HtmlDataListener<Boolean> htmlDataListener) {
        new MatlabMCR().feval("web", objectArray, 1, (CompletionObserver)new WebCommandCompletionObserver(htmlDataListener));
    }

    private static class WebCommandCompletionObserver
    implements CompletionObserver {
        private final HtmlDataListener<Boolean> iSuccessListener;

        private WebCommandCompletionObserver(HtmlDataListener<Boolean> htmlDataListener) {
            this.iSuccessListener = htmlDataListener;
        }

        public void completed(int n, Object object) {
            boolean bl = WebCommandCompletionObserver.isWebCommandSuccessful(n, object);
            this.iSuccessListener.dataRetrieved((Object)bl);
        }

        private static boolean isWebCommandSuccessful(int n, Object object) {
            if (object instanceof double[]) {
                double[] dArray = (double[])object;
                return n == 0 && dArray.length > 0 && dArray[0] == 0.0;
            }
            return false;
        }
    }
}

