/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.mlwidgets.importtool.AbstractColumnMetaData;
import com.mathworks.mlwidgets.importtool.AbstractFileTableModel;
import com.mathworks.mlwidgets.importtool.DateParsingRule;
import com.mathworks.mlwidgets.importtool.ImportClient;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.NonNumericReplacementRule;
import com.mathworks.mlwidgets.importtool.ParseRule;
import com.mathworks.mlwidgets.importtool.SpreadsheetDataSection;
import com.mathworks.mlwidgets.importtool.SpreadsheetTableHeaderRenderer;
import com.mathworks.mlwidgets.importtool.TextImportUIState;
import com.mathworks.mlwidgets.importtool.TextSpreadsheetDataSection;
import com.mathworks.mlwidgets.importtool.TextscanTextParser;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.util.Log;
import com.mathworks.util.Pair;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;

public class TextFileTableModel
extends AbstractFileTableModel {
    private File fFile;
    private volatile TextscanTextParser fTextParser;
    public static final int[] NONWINDOWED_TEXTSIZE = new int[]{2000, 100};

    public synchronized void setFixedWidth(boolean bl) {
        this.fTextParser.setFixedWidth(bl);
        if (this.fColumnMetaData != null) {
            this.fColumnMetaData.setValid(false);
        }
        this.fTemporaryBlockCache = null;
        this.fBlockCache.clear();
        this.fTableStructureInitialized = false;
    }

    void cleanup() {
        if (this.fTextParser != null) {
            this.fTextParser.cleanup();
        }
        if (this.fBlockCache != null) {
            this.fBlockCache.clear();
        }
    }

    @Override
    protected synchronized void rebuild(final int n, final int n2) {
        this.fTableStructureInitialized = false;
        if (this.fColumnMetaData != null) {
            this.fColumnMetaData.setValid(false);
        }
        MatlabWorker<double[]> matlabWorker = new MatlabWorker<double[]>(){

            public double[] runOnMatlabThread() {
                return TextFileTableModel.getSheetDimensions(TextFileTableModel.this.getTextParser());
            }

            public void runOnAWTEventDispatchThread(double[] dArray) {
                if (dArray == null) {
                    return;
                }
                if (dArray.length != 4) {
                    return;
                }
                int[] nArray = new int[]{(int)(dArray[1] + dArray[0]) - 1, (int)(dArray[3] + dArray[2]) - 1};
                int[] nArray2 = new int[]{(int)dArray[0] - 1, (int)dArray[2] - 1};
                if (TextFileTableModel.this.fDimensions[0] != nArray[0] || TextFileTableModel.this.fDimensions[1] != nArray[1] || TextFileTableModel.this.fStartCell[0] != nArray2[0] || TextFileTableModel.this.fStartCell[1] != nArray2[1]) {
                    TextFileTableModel.this.fDimensions[0] = 0;
                    TextFileTableModel.this.fDimensions[1] = 0;
                    TextFileTableModel.this.fStartCell[0] = 0;
                    TextFileTableModel.this.fStartCell[1] = 0;
                    TextFileTableModel.this.fTableStructureInitialized = false;
                    TextFileTableModel.this.fTemporaryBlockCache = null;
                } else {
                    TextFileTableModel.this.fTemporaryBlockCache = TextFileTableModel.this.getClosestSpreadsheetDataSection(n, n2);
                }
                TextFileTableModel.this.fCurrentMatlabBlock = null;
                TextFileTableModel.this.fBlockCache.clear();
                Point point = TextFileTableModel.this.getPointForIndices(n < 0 ? 0 : n, n2 < 0 ? 0 : n2);
                TextFileTableModel.this.requestValueFromMatlab(point.x + 1, point.y + 1, point.x + TextFileTableModel.this.ROWBLOCKSIZE, point.y + TextFileTableModel.this.COLUMNBLOCKSIZE);
            }
        };
        matlabWorker.start();
    }

    private Object[][] getSelectedColumnTargetTypes(String[][] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        Object[][] objectArray = new Object[stringArray.length][stringArray[0].length];
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length; ++j) {
                SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType[] spreadsheetColumnTargetTypeArray;
                objectArray[i][j] = spreadsheetColumnTargetTypeArray = this.getSelectedColumnVectorTargetTypes(stringArray[i][j]);
            }
        }
        return objectArray;
    }

    private SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType[] getSelectedColumnVectorTargetTypes(String string) {
        List<int[]> list = ImportToolUtils.fromExcelRange(string);
        if (list.isEmpty()) {
            return new SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType[0];
        }
        int[] nArray = list.get(0);
        List<ParseRule> list2 = this.getColumnParseRules();
        ArrayList<SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType> arrayList = new ArrayList<SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType>();
        for (int i = nArray[1] - 1; i <= nArray[3] - 1; ++i) {
            if (list2.get(i) == null) {
                arrayList.add(SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.CELL_ARRAY);
                continue;
            }
            arrayList.add(list2.get(i).getColumnTargetType());
        }
        return arrayList.toArray(new SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType[1]);
    }

    @Override
    Object[] importData(String[] stringArray, String[] stringArray2, String string, String[][] stringArray3, int n, Component component) throws Exception {
        Object object;
        if (n > LARGECELLCOUNT && PlatformInfo.isWindows() && (object = (Object)((boolean[])Matlab.mtFeval((String)"internal.matlab.importtool.TextFileImporter.MemoryTest", (Object[])new Object[]{n}, (int)1)))[0] == false) {
            LargeFileOptionDialogRunnable largeFileOptionDialogRunnable = new LargeFileOptionDialogRunnable(component);
            if (NativeMatlab.nativeIsMatlabThread()) {
                SwingUtilities.invokeAndWait(largeFileOptionDialogRunnable);
            } else {
                largeFileOptionDialogRunnable.run();
            }
            if (!largeFileOptionDialogRunnable.isOKToImport()) {
                return null;
            }
        }
        object = this.getSelectedColumnTargetTypes(stringArray3);
        return (Object[])Matlab.mtFeval((String)"ImportData", (Object[])new Object[]{this.fTextParser.fTextFileImporterMCOS, stringArray, stringArray2, string, stringArray3, n, this.getColumnParseRules().toArray(new ParseRule[1]), this.fRules.toArray(), object}, (int)2);
    }

    protected synchronized List<ParseRule> getColumnParseRules() {
        if (this.fColumnMetaData == null) {
            return null;
        }
        List<ParseRule> list = ((TextscanTextParser.ColumnMetaData)this.fColumnMetaData).getParseRules(this.fTargetType);
        for (int i = list.size(); i < this.getColumnCount(); ++i) {
            list.add(list.get(list.size() - 1));
        }
        return list;
    }

    protected synchronized List<DateParsingRule[]> getDateParsingRules() {
        if (this.fColumnMetaData == null) {
            return null;
        }
        List<DateParsingRule[]> list = ((TextscanTextParser.ColumnMetaData)this.fColumnMetaData).getDefaultDateParseRules();
        for (int i = list.size(); i < this.getColumnCount(); ++i) {
            list.add(list.get(list.size() - 1));
        }
        return list;
    }

    synchronized void setColumnParseRules(List<ParseRule> list) {
        ((TextscanTextParser.ColumnMetaData)this.fColumnMetaData).setParseRules(list);
    }

    File getFile() {
        return this.fFile;
    }

    public boolean canRead() {
        return this.fTextParser.canRead();
    }

    public TextFileTableModel(File file, List<WorksheetRule> list, final Object object) {
        this.fFile = file;
        MatlabWorker<Object> matlabWorker = new MatlabWorker<Object>(){

            public TextscanTextParser runOnMatlabThread() {
                TextFileTableModel.this.fTextParser = new TextscanTextParser(TextFileTableModel.this.fFile, true, object);
                return null;
            }

            public void runOnAWTEventDispatchThread(Object object2) {
                TextFileTableModel.this.requestValueFromMatlab(1, 1, TextFileTableModel.this.ROWBLOCKSIZE, TextFileTableModel.this.COLUMNBLOCKSIZE);
            }
        };
        matlabWorker.start();
        if (list == null) {
            list = new ArrayList<WorksheetRule>();
        }
        this.fRules = list;
        this.fBlockCache = new LinkedHashMap<Point, SpreadsheetDataSection>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Point, SpreadsheetDataSection> entry) {
                return this.size() > 10;
            }
        };
    }

    synchronized void setDelimiters(List<String> list) {
        this.fTextParser.setDelimiters(list);
        if (this.fColumnMetaData != null) {
            this.fColumnMetaData.setValid(false);
        }
        this.fTemporaryBlockCache = null;
        this.fBlockCache.clear();
        this.fTableStructureInitialized = false;
    }

    public List<double[]> find(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, int n2, int[] nArray, int[] nArray2, boolean bl5) {
        if (this.fTextParser == null) {
            return null;
        }
        return this.fTextParser.find(string, bl, bl2, bl3, bl4, n, n2, nArray, nArray2, bl5);
    }

    List<String> getDelimiters() {
        if (this.fTextParser == null) {
            return null;
        }
        return this.fTextParser.getDelimiters();
    }

    boolean isFixedWidth() {
        if (this.fTextParser == null) {
            return false;
        }
        return this.fTextParser.isFixedWidth();
    }

    boolean hasHalfWidthChars() {
        if (this.fTextParser == null) {
            return false;
        }
        return this.fTextParser.hasHalfWidthChars();
    }

    boolean hasFullWidthChars() {
        if (this.fTextParser == null) {
            return false;
        }
        return this.fTextParser.hasFullWidthChars();
    }

    int getEmptyRowCount() {
        if (this.fTextParser == null) {
            return 0;
        }
        return this.fTextParser.getEmptyRowCount();
    }

    boolean isMultipleDelimsAsOne() {
        if (this.fTextParser == null) {
            return false;
        }
        return this.fTextParser.isMultipleDelimsAsOne();
    }

    List<Integer> getFixedWidthColumnPositions() {
        if (this.fTextParser == null) {
            return null;
        }
        return this.fTextParser.getFixedWidthColumnPositions();
    }

    void setFixedWidthColumnPositions(List<Integer> list) {
        if (this.fTextParser == null) {
            return;
        }
        this.fTextParser.setFixedWidthColumnPositions(list);
        this.rebuild(0, 0);
    }

    void setDecimalSeparator(final String string) {
        MatlabWorker<Object> matlabWorker = new MatlabWorker<Object>(){

            public Object runOnMatlabThread() {
                TextFileTableModel.this.fTextParser.setDecimalSeparator(string);
                return null;
            }

            public synchronized void runOnAWTEventDispatchThread(Object object) {
                if (TextFileTableModel.this.fColumnMetaData != null) {
                    TextFileTableModel.this.fColumnMetaData.setValid(false);
                }
                TextFileTableModel.this.rebuild(0, 0);
            }
        };
        matlabWorker.start();
    }

    void setMultipleDelimsAsOne(final boolean bl) {
        MatlabWorker<Object> matlabWorker = new MatlabWorker<Object>(){

            public Object runOnMatlabThread() {
                TextFileTableModel.this.fTextParser.setMultipleDelimsAsOne(bl);
                return null;
            }

            public void runOnAWTEventDispatchThread(Object object) {
                if (TextFileTableModel.this.fColumnMetaData != null) {
                    TextFileTableModel.this.fColumnMetaData.setValid(false);
                }
                TextFileTableModel.this.rebuild(0, 0);
            }
        };
        matlabWorker.start();
    }

    protected TextFileTableModel() {
    }

    protected TextFileTableModel(SpreadsheetDataSection spreadsheetDataSection) {
        this.setDataSection(spreadsheetDataSection);
    }

    protected void setDataSection(SpreadsheetDataSection spreadsheetDataSection) {
        this.fBlockCache = new LinkedHashMap<Point, SpreadsheetDataSection>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Point, SpreadsheetDataSection> entry) {
                return this.size() > 10;
            }
        };
        this.fBlockCache.put(new Point(0, 0), spreadsheetDataSection);
    }

    protected void setTextParser(TextscanTextParser textscanTextParser) {
        this.fTextParser = textscanTextParser;
    }

    @Override
    synchronized boolean isUntreatedAt(int n, int n2) {
        boolean bl;
        if (this.fTargetType.isColumnVectors() || this.fTargetType.isCellArray() || this.fTargetType.isDataSet() || this.fTargetType.isTable()) {
            if (this.fColumnMetaData != null && (n2 >= ((TextscanTextParser.ColumnMetaData)this.fColumnMetaData).getParseRules(this.fTargetType).size() || ((TextscanTextParser.ColumnMetaData)this.fColumnMetaData).getParseRules(this.fTargetType).get(n2) == null)) {
                return false;
            }
        } else if (this.fTargetType.isMatrix() && n2 < ((TextscanTextParser.ColumnMetaData)this.fColumnMetaData).getParseRules(this.fTargetType).size() && ((TextscanTextParser.ColumnMetaData)this.fColumnMetaData).getParseRules(this.fTargetType).get(n2) instanceof DateParsingRule) {
            return true;
        }
        List<ParseRule> list = this.getColumnParseRules();
        boolean bl2 = bl = !this.fTargetType.isMatrix();
        if (n2 < list.size() && list.get(n2) != null) {
            bl = list.get(n2) instanceof DateParsingRule;
        }
        return super.isUntreatedAt(n, n2, bl);
    }

    public TextscanTextParser getTextParser() {
        return this.fTextParser;
    }

    public void addColumnSplitter(int n) {
        assert (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread());
        this.fTextParser.addFixedWidthColumnPosition(n);
        this.rebuild(0, 0);
    }

    public void deleteColumnSplitter(int n) {
        assert (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread());
        this.fTextParser.removeFixedWidthColumnPosition(n);
        this.rebuild(0, 0);
    }

    public void moveColumnSplitter(int n, int n2) {
        this.fTextParser.removeFixedWidthColumnPosition(n);
        this.fTextParser.addFixedWidthColumnPosition(n2);
    }

    public boolean columnSplitterExists(int n) {
        return false;
    }

    public synchronized int[] getCharacterCounts() {
        if (this.fColumnMetaData == null) {
            return null;
        }
        return ((TextscanTextParser.ColumnMetaData)this.fColumnMetaData).getColumnCharacterPositions();
    }

    @Override
    protected Object getParser() {
        return this.fTextParser;
    }

    public boolean useFastPath(String[][] stringArray) {
        return this.fTextParser.useFastPath(stringArray, this.getColumnParseRules(), this.getWorksheetRules());
    }

    public String getTextscanFormat(int[] nArray) {
        return this.fTextParser.getTextscanFormat(nArray, this.getColumnParseRules());
    }

    public String getSlowPathTextscanFormat(int[] nArray) {
        return this.fTextParser.getSlowPathTextscanFormat(nArray);
    }

    public String getDecimalSeparator() {
        return this.fTextParser.getDecimalSeparator();
    }

    private static double[] getSheetDimensions(TextscanTextParser textscanTextParser) {
        return new double[]{1.0, textscanTextParser.getRowCount(), 1.0, textscanTextParser.getColumnCount()};
    }

    private boolean isDatetimeColumn(int n) {
        boolean bl = !this.fTargetType.isMatrix();
        List<ParseRule> list = this.getColumnParseRules();
        if (list.get(n) != null) {
            bl = list.get(n) instanceof DateParsingRule;
        }
        return bl;
    }

    @Override
    Object getParsedValueAt(int n, int n2) {
        SpreadsheetDataSection spreadsheetDataSection = this.getValueDataSection(n, n2);
        if (spreadsheetDataSection instanceof TextSpreadsheetDataSection) {
            boolean bl = this.isDatetimeColumn(n2);
            return spreadsheetDataSection.getParsedValueAt(n, n2, bl);
        }
        return null;
    }

    @Override
    Object getReplacedValueAt(int n, int n2) {
        SpreadsheetDataSection spreadsheetDataSection = this.getValueDataSection(n, n2);
        if (spreadsheetDataSection != null) {
            Object object = spreadsheetDataSection.getReplacedValueAt(n, n2);
            if (object != null && this.isDatetimeColumn(n2)) {
                return "NaT";
            }
            return object;
        }
        return null;
    }

    @Override
    protected List<WorksheetRule> getDefaultWorksheetRuleList() {
        ArrayList<WorksheetRule> arrayList = new ArrayList<WorksheetRule>();
        arrayList.add(new NonNumericReplacementRule());
        return arrayList;
    }

    @Override
    protected void makeCallToMatlab(final AbstractFileTableModel.MatlabUpdateRequest matlabUpdateRequest) {
        this.fMatlabBusy = true;
        this.setQueuedItem(null);
        if (Matlab.isMatlabAvailable()) {
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object;
                    double[] dArray = TextFileTableModel.getSheetDimensions(TextFileTableModel.this.getTextParser());
                    Pair pair = null;
                    if (dArray == null || dArray.length < 4 || (int)dArray[1] == 0 || (int)dArray[3] == 0) {
                        TextFileTableModel.this.setInitialSelection(0, 0, 0, 0);
                        TextFileTableModel.this.setSheetDimensions(0, 0, 0, 0);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                TextFileTableModel.this.matlabCallback(null);
                            }
                        });
                        return;
                    }
                    if ((int)dArray[1] != TextFileTableModel.this.fDimensions[0]) {
                        object = TextFileTableModel.this.fTextParser.getDefaultSelectionStartCell();
                        TextFileTableModel.this.setInitialSelection(object[0], object[1], (int)dArray[1] - 1, (int)dArray[3] - 1);
                        TextFileTableModel.this.setSheetDimensions((int)dArray[1], (int)dArray[3], 0, 0);
                        TextFileTableModel.this.fTableStructureInitialized = false;
                    } else if ((int)dArray[3] != TextFileTableModel.this.fDimensions[1]) {
                        if (dArray[3] > 0.0) {
                            pair = new Pair((Object)(TextFileTableModel.this.fDimensions[1] + 1), (Object)((int)dArray[3]));
                        }
                        object = TextFileTableModel.this.fTextParser.getDefaultSelectionStartCell();
                        TextFileTableModel.this.setInitialSelection(object[0], object[1], TextFileTableModel.this.fDimensions[0], (int)dArray[3]);
                        TextFileTableModel.this.setSheetDimensions(TextFileTableModel.this.fDimensions[0], (int)dArray[3], 0, 0);
                    }
                    try {
                        if (TextFileTableModel.this.fDimensions[0] < NONWINDOWED_TEXTSIZE[0] && TextFileTableModel.this.fDimensions[1] < NONWINDOWED_TEXTSIZE[1]) {
                            TextFileTableModel.this.getTextParser().setRowBlockSize(TextFileTableModel.this.fDimensions[0]);
                            dArray = TextFileTableModel.getSheetDimensions(TextFileTableModel.this.getTextParser());
                            object = TextFileTableModel.this.fTextParser.getDefaultSelectionStartCell();
                            TextFileTableModel.this.setInitialSelection(object[0], object[1], (int)dArray[1] - 1, (int)dArray[3] - 1);
                            TextFileTableModel.this.setSheetDimensions((int)dArray[1], (int)dArray[3], 0, 0);
                            matlabUpdateRequest.iStartRow = 1;
                            matlabUpdateRequest.iStartCol = 1;
                            matlabUpdateRequest.iEndCol = TextFileTableModel.this.fDimensions[1];
                            matlabUpdateRequest.iEndRow = TextFileTableModel.this.fDimensions[0];
                            TextFileTableModel.this.ROWBLOCKSIZE = TextFileTableModel.this.fDimensions[0];
                            TextFileTableModel.this.COLUMNBLOCKSIZE = TextFileTableModel.this.fDimensions[1];
                        }
                        ((MatlabTextFileUpdateRequest)matlabUpdateRequest).setTargetType(TextFileTableModel.this.fTargetType);
                        object = matlabUpdateRequest.mtFeval();
                        TextFileTableModel textFileTableModel = TextFileTableModel.this;
                        synchronized (textFileTableModel) {
                            if (TextFileTableModel.this.fColumnMetaData == null || !TextFileTableModel.this.fColumnMetaData.isValid()) {
                                TextFileTableModel.this.setColumnMetaData(matlabUpdateRequest.getColumnMetaData());
                            }
                        }
                        textFileTableModel = pair;
                        SwingUtilities.invokeLater(new Runnable((SpreadsheetDataSection)object, (Pair)textFileTableModel){
                            final /* synthetic */ SpreadsheetDataSection val$spreadsheetDataSection;
                            final /* synthetic */ Pair val$finalAddedColumnInterval;
                            {
                                this.val$spreadsheetDataSection = spreadsheetDataSection;
                                this.val$finalAddedColumnInterval = pair;
                            }

                            @Override
                            public void run() {
                                TextFileTableModel.this.matlabCallback(this.val$spreadsheetDataSection, (Pair<Integer, Integer>)this.val$finalAddedColumnInterval);
                            }
                        });
                    }
                    catch (Exception exception) {
                        Log.log((String)exception.toString());
                    }
                }
            });
        }
    }

    void populateTextImportUIState(TextImportUIState textImportUIState) {
        List<ParseRule> list = this.getColumnParseRules();
        ArrayList<ParseRule> arrayList = new ArrayList<ParseRule>();
        for (int n : textImportUIState.getSelectedColumns()) {
            arrayList.add(list.get(n));
        }
        textImportUIState.setSelectedColumnParseRules(arrayList);
        textImportUIState.setFile(this.fFile);
        textImportUIState.setDimensions(this.fDimensions);
        textImportUIState.setRules(this.fRules);
    }

    @Override
    protected void requestValueFromMatlab(int n, int n2, int n3, int n4) {
        SpreadsheetDataSection spreadsheetDataSection;
        Point point = this.getPointForIndices(n, n2);
        if (!point.equals(this.fCurrentMatlabBlock) && ((spreadsheetDataSection = (SpreadsheetDataSection)this.fBlockCache.get(point)) == null || spreadsheetDataSection.isRulesDirty())) {
            this.fCurrentMatlabBlock = point;
            MatlabTextFileUpdateRequest matlabTextFileUpdateRequest = new MatlabTextFileUpdateRequest(this.getTextParser(), this.fColumnMetaData, this.fRules, n, n3, n2, n4);
            if (!this.fMatlabBusy) {
                this.makeCallToMatlab(matlabTextFileUpdateRequest);
            } else {
                this.setQueuedItem(matlabTextFileUpdateRequest);
            }
        }
    }

    void matlabCallback(SpreadsheetDataSection spreadsheetDataSection, Pair<Integer, Integer> pair) {
        assert (SwingUtilities.isEventDispatchThread());
        if (spreadsheetDataSection != null) {
            this.updateBlockCache(spreadsheetDataSection);
        }
        if (!this.fTableStructureInitialized) {
            this.fireTableStructureChanged();
            if (this.fQueuedUpdateRequest == null) {
                this.fTableStructureInitialized = true;
            }
        }
        if (pair != null) {
            this.fireTableChanged(new TableModelEvent(this, 0, this.getRowCount() - 1, (Integer)pair.getSecond()));
        }
        this.fCachedSelectedRowIntervals.clear();
        this.fCachedSelectedColumnIntervals.clear();
        this.fireWorksheetCachedDataListeners(new EventObject(this));
        final AbstractFileTableModel.MatlabUpdateRequest matlabUpdateRequest = this.getQueuedUpdateRequest();
        if (matlabUpdateRequest != null) {
            this.setQueuedItem(null);
            Matlab.whenMatlabReady((Runnable)new Runnable(){

                @Override
                public void run() {
                    TextFileTableModel.this.makeCallToMatlab(matlabUpdateRequest);
                }
            });
        } else {
            this.fMatlabBusy = false;
        }
    }

    @Override
    protected synchronized void setQueuedItem(AbstractFileTableModel.MatlabUpdateRequest matlabUpdateRequest) {
        this.fQueuedUpdateRequest = matlabUpdateRequest;
    }

    private synchronized AbstractFileTableModel.MatlabUpdateRequest getQueuedUpdateRequest() {
        return this.fQueuedUpdateRequest;
    }

    void reset(final int n, final ParseRule parseRule, Rectangle rectangle) {
        Object object2;
        final ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (Object object2 : this.fBlockCache.values()) {
            Cloneable cloneable = new Rectangle(((SpreadsheetDataSection)object2).getStartColumn(), ((SpreadsheetDataSection)object2).getStartRow(), ((SpreadsheetDataSection)object2).getEndColumn() - ((SpreadsheetDataSection)object2).getStartColumn() + 1, ((SpreadsheetDataSection)object2).getEndRow() - ((SpreadsheetDataSection)object2).getStartRow() + 1);
            if (((SpreadsheetDataSection)object2).getEndColumn() < n || ((SpreadsheetDataSection)object2).getStartColumn() > n) continue;
            if (rectangle.intersects((Rectangle)cloneable)) {
                arrayList.add(object2);
                continue;
            }
            arrayList2.add(object2);
        }
        HashMap hashMap = (HashMap)this.fBlockCache.clone();
        for (Cloneable cloneable : hashMap.keySet()) {
            if (!arrayList2.contains(hashMap.get(cloneable))) continue;
            this.fBlockCache.remove(cloneable);
        }
        object2 = new MatlabWorker<List<TextSpreadsheetDataSection>>(){

            public List<TextSpreadsheetDataSection> runOnMatlabThread() {
                ArrayList<TextSpreadsheetDataSection> arrayList2 = new ArrayList<TextSpreadsheetDataSection>();
                for (SpreadsheetDataSection spreadsheetDataSection : arrayList) {
                    TextSpreadsheetDataSection textSpreadsheetDataSection = (TextSpreadsheetDataSection)spreadsheetDataSection;
                    MatlabTextFileUpdateRequest matlabTextFileUpdateRequest = new MatlabTextFileUpdateRequest(TextFileTableModel.this.getTextParser(), TextFileTableModel.this.fColumnMetaData, TextFileTableModel.this.fRules, textSpreadsheetDataSection.getStartRow() + 1, textSpreadsheetDataSection.getEndRow() + 1, textSpreadsheetDataSection.getStartColumn() + 1, textSpreadsheetDataSection.getEndColumn() + 1);
                    matlabTextFileUpdateRequest.setTargetType(TextFileTableModel.this.fTargetType);
                    arrayList2.add(matlabTextFileUpdateRequest.reparse(textSpreadsheetDataSection, n, parseRule));
                }
                return arrayList2;
            }

            public void runOnAWTEventDispatchThread(List<TextSpreadsheetDataSection> list) {
                List<ParseRule> list2 = TextFileTableModel.this.getColumnParseRules();
                list2.set(n, parseRule);
                TextFileTableModel.this.setColumnParseRules(list2);
                for (TextSpreadsheetDataSection textSpreadsheetDataSection : list) {
                    TextFileTableModel.this.updateBlockCache(textSpreadsheetDataSection);
                }
                TextFileTableModel.this.fCachedSelectedRowIntervals.clear();
                TextFileTableModel.this.fCachedSelectedColumnIntervals.clear();
                TextFileTableModel.this.fireWorksheetCachedDataListeners(new EventObject(TextFileTableModel.this));
            }
        };
        object2.start();
    }

    private static class LargeFileOptionDialogRunnable
    implements Runnable {
        private int iResult;
        private Component iAncestor;

        LargeFileOptionDialogRunnable(Component component) {
            this.iAncestor = component;
        }

        private boolean isOKToImport() {
            return this.iResult == 0;
        }

        @Override
        public void run() {
            this.iResult = MJOptionPane.showConfirmDialog((Component)SwingUtilities.getWindowAncestor(this.iAncestor), (Object)ImportToolUtils.getResourceString("textimport.memory"), (String)ImportToolUtils.getResourceString("error.title"), (int)0);
        }
    }

    public static class MatlabTextFileUpdateRequest
    extends AbstractFileTableModel.MatlabUpdateRequest {
        TextscanTextParser iTextParser;
        ImportClient.TargetType iTargetType;

        public MatlabTextFileUpdateRequest(TextscanTextParser textscanTextParser, AbstractColumnMetaData abstractColumnMetaData, List<WorksheetRule> list, int n, int n2, int n3, int n4) {
            this.iStartRow = n;
            this.iEndRow = n2;
            this.iStartCol = n3;
            this.iEndCol = n4;
            this.iRules = list;
            this.iColumnMetaData = abstractColumnMetaData;
            this.iTextParser = textscanTextParser;
        }

        void setTargetType(ImportClient.TargetType targetType) {
            this.iTargetType = targetType;
        }

        public static void parseColumn(Object[] objectArray, double[] dArray, String[] stringArray, int n, int n2, WorksheetRule worksheetRule) {
            Object[] objectArray2;
            Object[] objectArray3 = Arrays.copyOfRange(objectArray, n * n2, n * (n2 + 1));
            try {
                objectArray2 = (Object[])Matlab.mtFeval((String)"feval", (Object[])new Object[]{worksheetRule.getStringApplyFcn(), worksheetRule, null, objectArray3}, (int)2);
            }
            catch (Exception exception) {
                return;
            }
            double[] dArray2 = null;
            String[] stringArray2 = null;
            if (objectArray2[0] instanceof double[]) {
                dArray2 = (double[])objectArray2[0];
            } else if (objectArray2[0] instanceof String[]) {
                stringArray2 = (String[])objectArray2[0];
            } else {
                return;
            }
            if (!(objectArray2[1] instanceof boolean[])) {
                return;
            }
            boolean[] blArray = (boolean[])objectArray2[1];
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray[i]) continue;
                if (dArray2 != null) {
                    objectArray[n * n2 + i] = dArray2[i];
                    dArray[n * n2 + i] = dArray2[i];
                    continue;
                }
                if (stringArray2 == null) continue;
                objectArray[n * n2 + i] = stringArray2[i];
                stringArray[n * n2 + i] = stringArray2[i];
            }
        }

        protected TextSpreadsheetDataSection reparse(TextSpreadsheetDataSection textSpreadsheetDataSection, int n, ParseRule parseRule) {
            Object object;
            List<Object> list;
            int n2 = this.iStartRow - 1;
            int n3 = this.iEndRow - 1;
            int n4 = this.iStartCol - 1;
            int n5 = this.iEndCol - 1;
            int n6 = n3 - n2 + 1;
            List<List<Object>> list2 = this.iTextParser.read(n2, n3, n, n);
            int n7 = n3 > list2.size() + n2 - 1 ? list2.size() + n2 - 1 : n3;
            Object[] objectArray = new Object[n7 - n2 + 1];
            double[] dArray = new double[n7 - n2 + 1];
            Arrays.fill(dArray, Double.NaN);
            Object[] objectArray2 = new String[n7 - n2 + 1];
            Arrays.fill(objectArray2, "");
            for (int i = n2; i <= n7; ++i) {
                list = list2.get(i - n2);
                if (list.isEmpty()) continue;
                objectArray[i - n2] = list.get(0);
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            list = new ArrayList<Object>();
            for (int i = n4; i <= n5; ++i) {
                object = null;
                if (i == n) {
                    object = parseRule;
                } else if (i < ((TextscanTextParser.ColumnMetaData)this.iColumnMetaData).getParseRules(this.iTargetType).size()) {
                    object = ((TextscanTextParser.ColumnMetaData)this.iColumnMetaData).getParseRules(this.iTargetType).get(i);
                }
                if (object == null && (this.iTargetType == ImportClient.TargetType.COLUMNVECTORS || this.iTargetType == ImportClient.TargetType.CELLARRAY || this.iTargetType == ImportClient.TargetType.DATASET || this.iTargetType == ImportClient.TargetType.TABLE)) {
                    arrayList.add(i - n4);
                    continue;
                }
                if (object == null || !(object instanceof DateParsingRule)) continue;
                list.add(i);
            }
            if (parseRule != null) {
                parseRule.setDecimalSeparator(this.iTextParser.getDecimalSeparator());
                MatlabTextFileUpdateRequest.parseColumn(objectArray, dArray, (String[])objectArray2, n6, 0, parseRule);
            }
            Object[] objectArray3 = Arrays.copyOf(textSpreadsheetDataSection.getUnPostProcessedRawData(), textSpreadsheetDataSection.getUnPostProcessedRawData().length);
            object = Arrays.copyOf(textSpreadsheetDataSection.getNumericData(), textSpreadsheetDataSection.getNumericData().length);
            String[] stringArray = Arrays.copyOf(textSpreadsheetDataSection.getDatetimeData(), textSpreadsheetDataSection.getDatetimeData().length);
            String[] stringArray2 = Arrays.copyOf(textSpreadsheetDataSection.getDisplayedData(), textSpreadsheetDataSection.getDisplayedData().length);
            for (int i = n2; i <= n7; ++i) {
                objectArray3[i - textSpreadsheetDataSection.getStartRow() + n6 * (n - textSpreadsheetDataSection.getStartColumn())] = objectArray[i - n2];
                object[i - textSpreadsheetDataSection.getStartRow() + n6 * (n - textSpreadsheetDataSection.getStartColumn())] = dArray[i - n2];
                stringArray[i - textSpreadsheetDataSection.getStartRow() + n6 * (n - textSpreadsheetDataSection.getStartColumn())] = objectArray2[i - n2];
            }
            Pair<Class[], Object[]> pair = AbstractFileTableModel.getRuleResults(objectArray3, (double[])object, stringArray, this.iRules, this.iEndRow - this.iStartRow + 1, arrayList, list);
            Class[] classArray = (Class[])pair.getFirst();
            Object[] objectArray4 = (Object[])pair.getSecond();
            return new TextSpreadsheetDataSection(this.iStartRow - 1, this.iStartCol - 1, this.iEndRow - 1, this.iEndCol - 1, stringArray2, objectArray3, (double[])object, stringArray, classArray, objectArray4);
        }

        @Override
        protected SpreadsheetDataSection mtFeval() {
            Object object;
            int n;
            List<Object> list;
            int n2;
            int n3 = this.iStartCol - 1;
            int n4 = this.iEndCol - 1;
            int n5 = this.iStartRow - 1;
            int n6 = this.iEndRow - 1;
            int n7 = n6 - n5 + 1;
            Object[] objectArray = new Object[(n6 - n5 + 1) * (n4 - n3 + 1)];
            double[] dArray = new double[(n6 - n5 + 1) * (n4 - n3 + 1)];
            Arrays.fill(dArray, Double.NaN);
            Object[] objectArray2 = new String[(n6 - n5 + 1) * (n4 - n3 + 1)];
            Arrays.fill(objectArray2, "");
            String[] stringArray = new String[(n6 - n5 + 1) * (n4 - n3 + 1)];
            List<List<Object>> list2 = this.iTextParser.read(n5, n6, n3, n4);
            for (n2 = n5; n2 <= (n6 > list2.size() + n5 - 1 ? list2.size() + n5 - 1 : n6); ++n2) {
                list = list2.get(n2 - n5);
                int n8 = n4 <= n3 + list.size() - 1 ? n4 : n3 + list.size() - 1;
                for (n = n3; n <= n8; ++n) {
                    objectArray[n7 * (n - n3) + n2 - n5] = list.get(n - n3);
                    stringArray[n7 * (n - n3) + n2 - n5] = (String)list.get(n - n3);
                }
            }
            if (this.iColumnMetaData == null) {
                this.iColumnMetaData = new TextscanTextParser.ColumnMetaData(this.iTextParser, this.iTargetType);
            } else if (!this.iColumnMetaData.isValid()) {
                n2 = this.iColumnMetaData.getHeaderRow();
                this.iColumnMetaData = new TextscanTextParser.ColumnMetaData(this.iTextParser, n2, this.iTargetType);
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            list = new ArrayList<Object>();
            List<ParseRule> list3 = ((TextscanTextParser.ColumnMetaData)this.iColumnMetaData).getParseRules(this.iTargetType);
            for (n = n3; n <= n4; ++n) {
                object = n < list3.size() ? (Class[])list3.get(n) : (WorksheetRule)list3.get(list3.size() - 1);
                if (object != null) {
                    if (object instanceof ParseRule) {
                        ((ParseRule)object).setDecimalSeparator(this.iTextParser.getDecimalSeparator());
                    }
                    if (object instanceof DateParsingRule) {
                        list.add(n);
                    }
                    MatlabTextFileUpdateRequest.parseColumn(objectArray, dArray, (String[])objectArray2, n7, n - n3, (WorksheetRule)object);
                    continue;
                }
                if (this.iTargetType != ImportClient.TargetType.COLUMNVECTORS && this.iTargetType != ImportClient.TargetType.CELLARRAY && this.iTargetType != ImportClient.TargetType.DATASET && this.iTargetType != ImportClient.TargetType.TABLE) continue;
                arrayList.add(n - n3);
            }
            Pair<Class[], Object[]> pair = AbstractFileTableModel.getRuleResults(objectArray, dArray, (String[])objectArray2, this.iRules, this.iEndRow - this.iStartRow + 1, arrayList, list);
            object = (Class[])pair.getFirst();
            Object[] objectArray3 = (Object[])pair.getSecond();
            return new TextSpreadsheetDataSection(this.iStartRow - 1, this.iStartCol - 1, this.iEndRow - 1, this.iEndCol - 1, stringArray, objectArray, dArray, (String[])objectArray2, (Class[])object, objectArray3);
        }
    }

    static interface WorksheetCachedDataListener {
        public void worksheetCachedDataChanged(EventObject var1);
    }
}

