/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.client.Client;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.importtool.AbstractFileTableModel;
import com.mathworks.mlwidgets.importtool.HeaderRowListenerInterface;
import com.mathworks.mlwidgets.importtool.ImportClient;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.MoreOptionsDropDownButton;
import com.mathworks.mlwidgets.importtool.NonNumericReplacementRule;
import com.mathworks.mlwidgets.importtool.SpreadsheetImportToolGroup;
import com.mathworks.mlwidgets.importtool.TextFilePane;
import com.mathworks.mlwidgets.importtool.TextFileTableModel;
import com.mathworks.mlwidgets.importtool.TextTable;
import com.mathworks.mlwidgets.importtool.TextToolstripTab;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import com.mathworks.mlwidgets.importtool.WorksheetRuleList;
import com.mathworks.mlwidgets.importtool.WorksheetRulePanel;
import com.mathworks.mlwidgets.importtool.WorksheetSelectionListener;
import com.mathworks.mlwidgets.importtool.popuplist.EditablePopupButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJProgressBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolstrip.DefaultToolstrip;
import com.mathworks.toolstrip.Toolstrip;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.plaf.TSLookAndFeel;
import com.mathworks.util.Log;
import com.mathworks.widgets.desk.Desktop;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TextImportClient
extends ImportClient {
    protected boolean fTemporaryFile = false;
    protected ImportToolKeyFocusListener fImportToolKeyFocusListener = new ImportToolKeyFocusListener();

    protected TextImportClient(File file, boolean bl, String string) {
        super(file, string);
        this.setName("TextImportClient");
        this.fTemporaryFile = bl;
        long l = 8L;
        Toolkit.getDefaultToolkit().addAWTEventListener(this.fImportToolKeyFocusListener, l);
    }

    protected TextImportClient(File file) {
        this(file, false, SpreadsheetImportToolGroup.DEFAULT_GROUP_NAME);
    }

    public static void open() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                        if (!clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                            JOptionPane.showMessageDialog(null, ImportToolUtils.getResourceString("error.pastenotsupported"), ImportToolUtils.getResourceString("error.title"), 0);
                            return;
                        }
                        File file = File.createTempFile("MatlabImportTool_paste_", "tmp.txt");
                        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, false));
                        bufferedWriter.write((String)clipboard.getData(DataFlavor.stringFlavor));
                        bufferedWriter.close();
                        file.deleteOnExit();
                        TextImportClient.utOpen(file.getAbsolutePath(), null, true, ImportClient.DEFAULT_DESTINATION_WORKSPACE, ImportClient.getDefaultTargetTypes(), true, SpreadsheetImportToolGroup.DEFAULT_GROUP_NAME);
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        JOptionPane.showMessageDialog(null, ImportToolUtils.getResourceString("error.pastenotsupported"), ImportToolUtils.getResourceString("error.title"), 0);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        JOptionPane.showMessageDialog(null, ImportToolUtils.getResourceString("error.pastetoobig"), ImportToolUtils.getResourceString("error.title"), 0);
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception, ImportToolUtils.getResourceString("error.title"), 0);
                }
            }
        });
    }

    public static void open(final String string) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                TextImportClient.utOpen(string, null, false, ImportClient.DEFAULT_DESTINATION_WORKSPACE, ImportClient.getDefaultTargetTypes(), true, SpreadsheetImportToolGroup.DEFAULT_GROUP_NAME);
            }
        });
    }

    public static void open(final String string, final MJFrame mJFrame) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                TextImportClient.utOpen(string, mJFrame, false, ImportClient.DEFAULT_DESTINATION_WORKSPACE, ImportClient.getDefaultTargetTypes(), true, SpreadsheetImportToolGroup.DEFAULT_GROUP_NAME);
            }
        });
    }

    public static void open(final String string, final MJFrame mJFrame, final Object object, final ImportClient.TargetType[] targetTypeArray, final boolean bl, final String string2) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                TextImportClient.utOpen(string, mJFrame, false, object, targetTypeArray, bl, string2);
            }
        });
    }

    @Override
    protected void reOpen(String string, String string2) {
        TextImportClient.utOpen(string, null, false, this.getDestinationWorkspace(), this.getTargetTypes(), this.getShowCodeGeneration(), string2);
    }

    public static void utOpen(final String string, final MJFrame mJFrame, boolean bl, Object object, ImportClient.TargetType[] targetTypeArray, boolean bl2, String string2) {
        TextImportClient textImportClient;
        final Desktop desktop = MatlabDesktopServices.getDesktop();
        File file = new File(string);
        if (!file.canRead()) {
            JOptionPane.showMessageDialog(null, ImportToolUtils.getResourceString("error.cantread"), ImportToolUtils.getResourceString("error.title"), 0);
            if (Matlab.isMatlabAvailable()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        desktop.closeClient(string);
                    }
                });
            } else {
                desktop.closeClient(string);
            }
            return;
        }
        boolean bl3 = desktop.hasGroup(string2);
        if (!bl3) {
            desktop.setGroupDocked(string2, false);
        }
        if (desktop.hasClient(string, string2)) {
            textImportClient = (TextImportClient)((Object)desktop.getClient(string, string2));
            if (!textImportClient.getFile().isFile() || !textImportClient.getFile().exists()) {
                MJOptionPane.showMessageDialog((Component)((Object)textImportClient), (Object)ImportToolUtils.getResourceString("messages.deletedworkbook"), (String)file.getName(), (int)1);
                desktop.closeClient(string);
                return;
            }
            if (!textImportClient.isLastLoadedFileContentDifferentThanOnDiskFileContent()) {
                try {
                    TextImportClient.hideWaitProgressWindow(mJFrame);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                desktop.showClient(string);
                return;
            }
            desktop.closeClient((Component)((Object)textImportClient));
        }
        textImportClient = new TextImportClient(file, bl, string2);
        textImportClient.setTargetTypes(targetTypeArray);
        textImportClient.setShowCodeGeneration(bl2);
        textImportClient.setDestinationWorkspace(object);
        textImportClient.build(new Object(), string, desktop);
        textImportClient.setShortTitle(file.getName());
        textImportClient.addClient(desktop, string, string2);
        ((TextFilePane)textImportClient.getImportComponent()).getWorksheetTableModel().addWorksheetCachedDataListener(new AbstractFileTableModel.WorksheetCachedDataListener(){

            @Override
            public void worksheetCachedDataChanged(EventObject eventObject) {
                try {
                    TextImportClient.hideWaitProgressWindow(mJFrame);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public static MJFrame showWaitProgressWindow() throws InvocationTargetException, InterruptedException {
        final MJFrame mJFrame = new MJFrame();
        mJFrame.setUndecorated(true);
        mJFrame.setAlwaysOnTop(true);
        Desktop desktop = MatlabDesktopServices.getDesktop();
        Rectangle rectangle = desktop.getMainFrame().getBounds();
        mJFrame.setBounds(new Rectangle(rectangle.x + rectangle.width / 2 - 100, rectangle.y + rectangle.height / 2 - 25, 200, 50));
        MJProgressBar mJProgressBar = new MJProgressBar(0, 100);
        if (MJUtilities.isHighContrast()) {
            mJProgressBar.setBorder(BorderFactory.createLineBorder(Color.white, 3));
        } else {
            mJProgressBar.setBorder(BorderFactory.createLineBorder(Color.black, 3));
        }
        mJProgressBar.setStringPainted(true);
        mJProgressBar.setString(ImportToolUtils.getResourceString("textimport.wait"));
        mJProgressBar.setIndeterminate(true);
        mJFrame.getContentPane().add((Component)mJProgressBar);
        if (SwingUtilities.isEventDispatchThread()) {
            mJFrame.show();
        } else {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    mJFrame.show();
                }
            });
        }
        return mJFrame;
    }

    public static void hideWaitProgressWindow(final MJFrame mJFrame) throws InvocationTargetException, InterruptedException {
        if (mJFrame == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            mJFrame.hide();
            mJFrame.dispose();
        } else {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    mJFrame.hide();
                    mJFrame.dispose();
                }
            });
        }
    }

    @Override
    public void cleanup(boolean bl) {
        if (this.fImportComponent != null) {
            ((TextFilePane)this.fImportComponent).cleanup();
            this.fImportComponent = null;
        }
        this.cleanupToolstrip();
        if (this.fTemporaryFile) {
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        File file = TextImportClient.this.getFile();
                        file.delete();
                    }
                    catch (Exception exception) {
                        Log.logException((Exception)exception);
                    }
                }
            });
        }
        this.setParentDesktop(null);
    }

    private void build(Object object, String string, Desktop desktop) {
        Object object2;
        ImportClient.Target[] targetArray;
        ImportClient.TargetType[] targetTypeArray;
        TSLookAndFeel.install();
        this.fImportToolstripTab = new TextToolstripTab(string, this.getShowCodeGeneration());
        ((TextToolstripTab)this.fImportToolstripTab).addTextFileTypeListener(new TextToolstripTab.TextFileTypeListener(){

            @Override
            public void textFileTypeChanged(TextToolstripTab.TextFileType textFileType) {
                ((TextFilePane)TextImportClient.this.fImportComponent).setFixedWidth(textFileType == TextToolstripTab.TextFileType.FIXEDWIDTH);
                if (textFileType == TextToolstripTab.TextFileType.FIXEDWIDTH) {
                    ((TextToolstripTab)TextImportClient.this.fImportToolstripTab).setTextFileTypeEnabled(TextToolstripTab.TextFileType.DELIMITED, false);
                } else {
                    ((TextToolstripTab)TextImportClient.this.fImportToolstripTab).setTextFileTypeEnabled(TextToolstripTab.TextFileType.FIXEDWIDTH, false);
                }
                TextImportClient.this.fImportToolstripTab.getComponent().setCursor(new Cursor(3));
                ((TextFilePane)TextImportClient.this.fImportComponent).getWorksheetTableModel().addWorksheetCachedDataListener(new AbstractFileTableModel.WorksheetCachedDataListener(){

                    @Override
                    public void worksheetCachedDataChanged(EventObject eventObject) {
                        if (TextImportClient.this.fImportComponent == null || TextImportClient.this.fImportToolstripTab == null) {
                            return;
                        }
                        ((TextFilePane)TextImportClient.this.fImportComponent).getWorksheetTableModel().removeWorksheetCachedDataListener(this);
                        ((TextToolstripTab)TextImportClient.this.fImportToolstripTab).setTextFileTypeEnabled(TextToolstripTab.TextFileType.DELIMITED, true);
                        ((TextToolstripTab)TextImportClient.this.fImportToolstripTab).setTextFileTypeEnabled(TextToolstripTab.TextFileType.FIXEDWIDTH, true);
                        TextImportClient.this.fImportToolstripTab.getComponent().setCursor(null);
                    }
                });
                TextImportClient.this.fImportComponent.repaint();
            }
        });
        if (desktop != null && desktop.useToolstrip()) {
            this.setToolstripTabs(new ToolstripTab[]{this.fImportToolstripTab});
        } else {
            targetTypeArray = new MJPanel((LayoutManager)new BorderLayout());
            targetTypeArray.setFocusCycleRoot(false);
            targetArray = new DefaultToolstrip();
            object2 = targetArray.getModel();
            object2.add((Client)this.fImportToolstripTab);
            targetTypeArray.add((Component)targetArray.getComponent(), (Object)"North");
            targetArray.setCurrentTab("importData");
            targetArray.setAttribute((Attribute)Toolstrip.COLLAPSABLE, (Object)false);
            targetArray.setAttribute((Attribute)Toolstrip.NO_TABS, (Object)true);
            this.add((Component)targetTypeArray, "North");
        }
        targetTypeArray = this.getTargetTypes();
        targetArray = new ImportClient.Target[targetTypeArray.length];
        object2 = this.fImportToolstripTab.getTargetList();
        ((JList)object2).setCellRenderer(new ImportClient.TargetRenderer());
        for (int i = 0; i < targetTypeArray.length; ++i) {
            targetArray[i] = new ImportClient.Target(targetTypeArray[i]);
            ((DefaultListModel)((JList)object2).getModel()).add(i, targetArray[i]);
        }
        final WorksheetRuleList worksheetRuleList = this.fImportToolstripTab.getWorksheetRuleList();
        for (WorksheetRule worksheetRule : targetArray[0].getWorksheetRules()) {
            worksheetRuleList.addWorksheetRulePanel(new WorksheetRulePanel(worksheetRuleList, worksheetRule, ImportClient.getRulePrototypes()));
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(new NonNumericReplacementRule());
        for (int i = 0; i < targetArray.length; ++i) {
            targetArray[i].setWorksheetRules(arrayList);
        }
        worksheetRuleList.setWorksheetRuleList(targetArray[0].getWorksheetRules(), ImportClient.getRulePrototypes());
        worksheetRuleList.fireWorksheetRuleChanged();
        final TextFilePane textFilePane = new TextFilePane(this.fFileLocation, worksheetRuleList.getRules(), targetTypeArray[0], this.getDestinationWorkspace());
        this.fImportToolstripTab.setImporter(textFilePane);
        textFilePane.addWorksheetSelectionListener(this.fImportToolstripTab.getRangeEditBox());
        this.fImportToolstripTab.getRangeEditBox().addWorksheetSelectionListener(textFilePane);
        this.addDelimiterListeners();
        this.fImportToolstripTab.getTargetList().addListSelectionListener(new ListSelectionListener((JList)object2, textFilePane){
            private int iLastSelection = -1;
            final /* synthetic */ JList val$targetList;
            final /* synthetic */ TextFilePane val$tabbedPane;
            {
                this.val$targetList = jList;
                this.val$tabbedPane = textFilePane;
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ImportClient.Target target;
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (this.iLastSelection >= 0) {
                    target = (ImportClient.Target)((DefaultListModel)TextImportClient.this.fImportToolstripTab.getTargetList().getModel()).get(this.iLastSelection);
                    target.setWorksheetRules(worksheetRuleList.getRules());
                }
                this.iLastSelection = this.val$targetList.getSelectedIndex();
                target = (ImportClient.Target)((DefaultListModel)TextImportClient.this.fImportToolstripTab.getTargetList().getModel()).get(this.iLastSelection);
                worksheetRuleList.setWorksheetRuleList(target.getWorksheetRules(), ImportClient.getRulePrototypes());
                this.val$tabbedPane.setTargetType(target.getTargetType());
                TextImportClient.this.fImportToolstripTab.getHeaderSpinner().setEnabled(target.getTargetType().usesColumnNames());
                worksheetRuleList.fireWorksheetRuleChanged();
            }
        });
        this.fImportToolstripTab.getTargetList().setSelectedIndex(0);
        final MoreOptionsDropDownButton moreOptionsDropDownButton = ((TextToolstripTab)this.fImportToolstripTab).getMoreOptionsComboBox();
        moreOptionsDropDownButton.addSelectionListener(new EditablePopupButton.EditablePopupListSelectionListener(){

            @Override
            public void selectionChanged(EditablePopupButton.EditablePopupEvent editablePopupEvent) {
                if (editablePopupEvent.getItem().equals((Object)moreOptionsDropDownButton.getDecimalSeparatorPeriodItem()) && editablePopupEvent.getItem().isSelected()) {
                    ((TextFilePane)TextImportClient.this.fImportComponent).setDecimalSeparator(".");
                    TextImportClient.this.updateSuggestedDelimiters();
                } else if (editablePopupEvent.getItem().equals((Object)moreOptionsDropDownButton.getDecimalSeparatorCommaItem()) && editablePopupEvent.getItem().isSelected()) {
                    if (((TextToolstripTab)TextImportClient.this.fImportToolstripTab).getDelimiterComboBox().isCommaDelimiterSelected()) {
                        int n = MJOptionPane.showConfirmDialog((Component)((Object)TextImportClient.this), (Object)ImportToolUtils.getResourceString("messages.commaseparatorconflict"), (String)TextImportClient.this.getFile().getName(), (int)2, (int)2);
                        if (n == 2) {
                            moreOptionsDropDownButton.getDecimalSeparatorPeriodItem().setSelected(true);
                            return;
                        }
                        ((TextToolstripTab)TextImportClient.this.fImportToolstripTab).getDelimiterComboBox().clearCommaDelimiter();
                    }
                    ((TextFilePane)TextImportClient.this.fImportComponent).setDecimalSeparator(",");
                    TextImportClient.this.updateSuggestedDelimiters();
                } else if (editablePopupEvent.getItem().equals((Object)moreOptionsDropDownButton.getCoalesceDelimitersItem())) {
                    ((TextFilePane)TextImportClient.this.fImportComponent).setCoalesceDelimiters(editablePopupEvent.getItem().isSelected());
                }
            }

            @Override
            public void temporarySelectionChanged(EditablePopupButton.EditablePopupEvent editablePopupEvent) {
            }
        });
        this.fImportComponent = textFilePane;
        this.add(this.fImportComponent, "Center");
        this.addWorksheetSelectionListener();
        this.addHeaderRowListener((JSpinner)this.fImportToolstripTab.getHeaderSpinner(), (HeaderRowListenerInterface)((Object)this.fImportComponent));
        this.fImportToolstripTab.getWorksheetRuleList().addWorksheetRuleListener(textFilePane);
        ((TextFilePane)this.fImportComponent).getWorksheetTableModel().addWorksheetCachedDataListener(new AbstractFileTableModel.WorksheetCachedDataListener(){

            @Override
            public void worksheetCachedDataChanged(EventObject eventObject) {
                if (!((TextFileTableModel)textFilePane.getTextTable().getWorksheetTableModel()).canRead()) {
                    TextImportClient.this.cantRead();
                    return;
                }
                if (TextImportClient.this.fImportComponent == null) {
                    return;
                }
                ((TextFilePane)TextImportClient.this.fImportComponent).getWorksheetTableModel().removeWorksheetCachedDataListener(this);
                TextImportClient.this.setupDefaultView();
            }
        });
        this.setContextActions(new Action[]{((TextFilePane)this.fImportComponent).getTextTable().getUndoAction(), ((TextFilePane)this.fImportComponent).getTextTable().getRedoAction()});
    }

    private void addWorksheetSelectionListener() {
        ((TextFilePane)this.fImportComponent).addWorksheetSelectionListener(new WorksheetSelectionListener(){

            @Override
            public void selectedDataChanged(String string) {
                if (TextImportClient.this.fImportComponent == null || TextImportClient.this.fImportToolstripTab == null) {
                    return;
                }
                TextImportClient.this.fImportToolstripTab.setImportButtonEnabled(((TextFilePane)TextImportClient.this.fImportComponent).isImportableData());
                TextImportClient.this.fImportToolstripTab.getTargetList().setEnabled(true);
                TextTable textTable = ((TextFilePane)TextImportClient.this.fImportComponent).getTextTable();
                textTable.setImportContextMenuEnabled(((TextFilePane)TextImportClient.this.fImportComponent).isImportableData());
                TextImportClient.this.fImportToolstripTab.getWorksheetRuleList().setColumnExcludeRulesTransparent(!textTable.allowColumnExcludeRuleEvaluation());
            }

            @Override
            public void selectedDataChanged(String string, boolean bl) {
                this.selectedDataChanged(string);
            }

            @Override
            public void temporarySelectionDataChanged(String string) {
            }
        });
    }

    private void setupDefaultView() {
        try {
            int n;
            String string = ((TextFilePane)this.fImportComponent).getWorksheetTableModel().getTextParser().getDefaultDelimiter();
            String string2 = ((TextFilePane)this.fImportComponent).getWorksheetTableModel().getTextParser().getDefaultDecimalSeparator();
            boolean bl = ((TextFilePane)this.fImportComponent).getWorksheetTableModel().getTextParser().isDefaultFixedWidth();
            ((TextFilePane)this.fImportComponent).setFixedWidthView(bl);
            ((TextToolstripTab)this.fImportToolstripTab).setFixedWidth(bl);
            MoreOptionsDropDownButton moreOptionsDropDownButton = ((TextToolstripTab)this.fImportToolstripTab).getMoreOptionsComboBox();
            moreOptionsDropDownButton.setDecimalSeparator(".".equals(string2) ? MoreOptionsDropDownButton.DECIMAL_SEPARATOR.PERIOD : MoreOptionsDropDownButton.DECIMAL_SEPARATOR.COMMA);
            ((TextToolstripTab)this.fImportToolstripTab).getDelimiterComboBox().setSelectedDelimiter(string);
            if (!bl) {
                this.updateSuggestedDelimiters();
                if (" ".equals(string)) {
                    moreOptionsDropDownButton.setCoalesceDelimiters(true);
                }
            } else {
                ((TextToolstripTab)this.fImportToolstripTab).getDelimiterComboBox().setEnabled(false);
                moreOptionsDropDownButton.getCoalesceDelimitersItem().setEnabled(false);
            }
            if ((n = ((TextFilePane)this.fImportComponent).getWorksheetTableModel().getTextParser().getDefaultHeaderRow()) >= 0) {
                ((TextFilePane)this.fImportComponent).setHeaderRow(n);
                this.setHeaderRowSpinnerDefaultValue((JSpinner)this.fImportToolstripTab.getHeaderSpinner(), n, ((TextFilePane)this.fImportComponent).getWorksheetTableModel().getRowCount());
            }
            ((TextFilePane)this.fImportComponent).getTextTable().setInitialSelection();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog((Component)((Object)this), exception, ImportToolUtils.getResourceString("error.title"), 0);
            Desktop desktop = MatlabDesktopServices.getDesktop();
            desktop.closeClient((Component)((Object)this));
        }
    }

    private void cantRead() {
        JOptionPane.showMessageDialog(null, ImportToolUtils.getResourceString("error.cantread"), ImportToolUtils.getResourceString("error.title"), 0);
        Desktop desktop = MatlabDesktopServices.getDesktop();
        desktop.closeClient((Component)((Object)this));
    }

    @Override
    protected void unregisterFind() {
        ((TextFilePane)this.fImportComponent).getTextTable().unregisterFind();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.fImportToolKeyFocusListener);
    }

    @Override
    protected void registerFind() {
        ((TextFilePane)this.fImportComponent).getTextTable().registerFind();
    }

    private void updateSuggestedDelimiters() {
        MoreOptionsDropDownButton moreOptionsDropDownButton = ((TextToolstripTab)this.fImportToolstripTab).getMoreOptionsComboBox();
        String string = moreOptionsDropDownButton.getDecimalSeparatorPeriodItem().isSelected() ? "." : ",";
        HashMap<String, Integer> hashMap = ((TextFilePane)this.fImportComponent).getWorksheetTableModel().getTextParser().getDefaultDelimitersMap();
        HashMap hashMap2 = (HashMap)hashMap.clone();
        if (hashMap2 != null) {
            hashMap2.remove(string);
            ((TextToolstripTab)this.fImportToolstripTab).getDelimiterComboBox().setSuggestedDelimiters(hashMap2);
        }
    }

    private void addDelimiterListeners() {
        ((TextToolstripTab)this.fImportToolstripTab).getDelimiterComboBox().addItemListener(new EditablePopupButton.EditablePopupListItemListener(){

            @Override
            public void itemAdded(EditablePopupButton.EditablePopupEvent editablePopupEvent) {
            }

            @Override
            public void itemRemoved(EditablePopupButton.EditablePopupEvent editablePopupEvent) {
            }

            @Override
            public void itemNameModified(EditablePopupButton.EditablePopupEvent editablePopupEvent) {
                if (!((TextToolstripTab)TextImportClient.this.fImportToolstripTab).getDelimiterComboBox().getSelectionAdjusting()) {
                    ((TextFilePane)TextImportClient.this.fImportComponent).setDelimiters(((TextToolstripTab)TextImportClient.this.fImportToolstripTab).getDelimiterComboBox().getSelectedFormat(), TextImportClient.this);
                }
            }

            @Override
            public void itemDescriptionModified(EditablePopupButton.EditablePopupEvent editablePopupEvent) {
            }
        });
        ((TextToolstripTab)this.fImportToolstripTab).getDelimiterComboBox().addSelectionListener(new EditablePopupButton.EditablePopupListSelectionListener(){

            @Override
            public void selectionChanged(EditablePopupButton.EditablePopupEvent editablePopupEvent) {
                if (TextImportClient.this.fImportComponent == null || TextImportClient.this.fImportToolstripTab == null) {
                    return;
                }
                if (!((TextToolstripTab)TextImportClient.this.fImportToolstripTab).getDelimiterComboBox().getSelectionAdjusting()) {
                    MoreOptionsDropDownButton moreOptionsDropDownButton = ((TextToolstripTab)TextImportClient.this.fImportToolstripTab).getMoreOptionsComboBox();
                    if (moreOptionsDropDownButton.getDecimalSeparatorCommaItem().isSelected() && ((TextToolstripTab)TextImportClient.this.fImportToolstripTab).getDelimiterComboBox().isCommaDelimiterSelected()) {
                        int n = MJOptionPane.showConfirmDialog((Component)((Object)TextImportClient.this), (Object)ImportToolUtils.getResourceString("messages.separatorcommaconflict"), (String)TextImportClient.this.getFile().getName(), (int)2, (int)2);
                        if (n == 2) {
                            ((TextToolstripTab)TextImportClient.this.fImportToolstripTab).getDelimiterComboBox().clearCommaDelimiter();
                            return;
                        }
                        moreOptionsDropDownButton.getDecimalSeparatorPeriodItem().setSelected(true);
                    }
                    ((TextFilePane)TextImportClient.this.fImportComponent).setDelimiters(((TextToolstripTab)TextImportClient.this.fImportToolstripTab).getDelimiterComboBox().getSelectedFormat(), TextImportClient.this);
                }
            }

            @Override
            public void temporarySelectionChanged(EditablePopupButton.EditablePopupEvent editablePopupEvent) {
            }
        });
    }

    class ImportToolKeyFocusListener
    implements AWTEventListener {
        ImportToolKeyFocusListener() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            try {
                KeyEvent keyEvent = (KeyEvent)aWTEvent;
                JComponent jComponent = (JComponent)keyEvent.getSource();
                if (TextTable.isFindKeyEvent(keyEvent) && SwingUtilities.isDescendingFrom(jComponent, TextImportClient.this.fImportToolstripTab.getComponent())) {
                    ((TextFilePane)TextImportClient.this.fImportComponent).getTextTable().invokeFindFromPanelKeyStroke();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

