/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.desktop.overlay.OverlayManager;
import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.mlwidgets.importtool.DragWindow;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.NonNumericReplacementRule;
import com.mathworks.mlwidgets.importtool.StringReplacementRule;
import com.mathworks.mlwidgets.importtool.WorksheetReplacementRule;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import com.mathworks.mlwidgets.importtool.WorksheetRuleList;
import com.mathworks.mlwidgets.importtool.WorksheetRuleListener;
import com.mathworks.mlwidgets.importtool.WorksheetRulePanelComboBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolstrip.components.TSButton;
import com.mathworks.toolstrip.plaf.TSLookAndFeel;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicComboBoxUI;

class WorksheetRulePanel
extends MJPanel
implements WorksheetRuleListener {
    private JComboBox fRuleTargetCombo;
    private JComboBox fRuleTypeCombo;
    private Component fRuleEditor;
    private WorksheetRule fWorksheetRule;
    private MJPanel fInnerPanel;
    private WorksheetRuleList fWorksheetRuleList;
    private RuleTypeIcon fRuleTypeIcon;
    private List<WorksheetRule> fWorksheetRulePrototypes;
    private ItemListener fItemListener;
    private HighlightedEdge fHighlightedEdge = HighlightedEdge.NONE;
    private DragAndDropListener fDragAndDropListener;
    private boolean fColumnExcludeRulesTransparent = false;

    WorksheetRulePanel(WorksheetRuleList worksheetRuleList, WorksheetRule worksheetRule, List<WorksheetRule> list) {
        super((LayoutManager)new BorderLayout());
        WorksheetRule worksheetRule22;
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.lightGray));
        this.fInnerPanel = new MJPanel((LayoutManager)new FlowLayout(0, 0, 0));
        this.fWorksheetRuleList = worksheetRuleList;
        this.fWorksheetRulePrototypes = list;
        TSLookAndFeel.install();
        this.fRuleTypeCombo = new MJComboBox();
        this.fRuleTypeCombo.setName("WorksheetRulePanel:fRuleTypeCombo");
        this.fRuleTypeCombo.setUI((ComboBoxUI)PlainComboBoxUI.createUI(this.fRuleTypeCombo));
        this.fRuleTypeCombo.setBorder(null);
        this.fRuleTypeCombo.setToolTipText(ImportToolUtils.getResourceString("ruletooltip.ruletreatment"));
        this.fRuleTypeCombo.addItem(WorksheetRule.RuleType.REPLACE);
        for (WorksheetRule worksheetRule22 : this.fWorksheetRulePrototypes) {
            if (WorksheetRule.RuleType.CONVERT != worksheetRule22.getType()) continue;
            this.fRuleTypeCombo.addItem(worksheetRule22.getType());
            break;
        }
        this.fRuleTypeCombo.addItem(WorksheetRule.RuleType.ROWEXCLUDE);
        this.fRuleTypeCombo.addItem(WorksheetRule.RuleType.COLUMNEXCLUDE);
        this.fRuleTypeCombo.setSelectedItem((Object)worksheetRule.getType());
        this.fRuleTypeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                WorksheetRulePanel.this.fWorksheetRule = null;
                WorksheetRulePanel.this.popupateRuleTargetCombo((WorksheetRule.RuleType)((Object)itemEvent.getItem()));
                WorksheetRulePanel.this.fRuleTypeIcon.setTransparent(WorksheetRulePanel.this.fWorksheetRule.getType() == WorksheetRule.RuleType.COLUMNEXCLUDE && WorksheetRulePanel.this.fColumnExcludeRulesTransparent);
                WorksheetRulePanel.this.fRuleTypeIcon.setFillColor(WorksheetRulePanel.this.fWorksheetRule.getType().getColor());
                WorksheetRulePanel.this.revalidate();
                WorksheetRulePanel.this.repaint();
                WorksheetRulePanel.this.fDragAndDropListener.clearDragImage();
                if (WorksheetRulePanel.this.fWorksheetRuleList != null) {
                    WorksheetRulePanel.this.fWorksheetRuleList.fireWorksheetRuleChanged();
                }
            }
        });
        this.fItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 2) {
                    return;
                }
                if (itemEvent.getItem() instanceof WorksheetRulePanelComboBox.Prompt) {
                    return;
                }
                if (itemEvent.getItem() instanceof WorksheetRule) {
                    if (WorksheetRulePanel.this.fWorksheetRule instanceof WorksheetReplacementRule && itemEvent.getItem() instanceof WorksheetReplacementRule) {
                        double d = ((WorksheetReplacementRule)WorksheetRulePanel.this.fWorksheetRule).getReplacementNumber();
                        WorksheetRulePanel.this.fWorksheetRule = (WorksheetRule)itemEvent.getItem();
                        ((WorksheetReplacementRule)WorksheetRulePanel.this.fWorksheetRule).setReplacementNumber(d);
                    } else {
                        WorksheetRulePanel.this.fWorksheetRule = (WorksheetRule)itemEvent.getItem();
                    }
                } else if (itemEvent.getItem() instanceof WorksheetRulePanelComboBox.EditableTarget) {
                    StringReplacementRule stringReplacementRule = new StringReplacementRule();
                    stringReplacementRule.setTargetString(itemEvent.getItem().toString());
                    if (WorksheetRulePanel.this.fWorksheetRule instanceof WorksheetReplacementRule) {
                        double d = ((WorksheetReplacementRule)WorksheetRulePanel.this.fWorksheetRule).getReplacementNumber();
                        stringReplacementRule.setReplacementNumber(d);
                    }
                    WorksheetRulePanel.this.fWorksheetRule = stringReplacementRule;
                }
                WorksheetRulePanel.this.updateWorksheetRuleEditor(WorksheetRulePanel.this.fWorksheetRule);
                WorksheetRulePanel.this.revalidate();
                WorksheetRulePanel.this.repaint();
                WorksheetRulePanel.this.fDragAndDropListener.clearDragImage();
                if (WorksheetRulePanel.this.fWorksheetRuleList != null) {
                    WorksheetRulePanel.this.fWorksheetRuleList.fireWorksheetRuleChanged();
                }
            }
        };
        this.fRuleTargetCombo = WorksheetRulePanel.createRuleTargetCombo(this.fItemListener, this.fWorksheetRulePrototypes, worksheetRule.getType());
        this.fRuleTargetCombo.setName("WorksheetRulePanel:fRuleTargetCombo");
        this.fInnerPanel.setBorder(null);
        this.fRuleTypeIcon = new RuleTypeIcon();
        MJLabel mJLabel = new MJLabel((Icon)this.fRuleTypeIcon);
        mJLabel.setCursor(new Cursor(8));
        mJLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        mJLabel.setToolTipText(ImportToolUtils.getResourceString("ruletooltip.unimportabledata"));
        this.fDragAndDropListener = new DragAndDropListener();
        mJLabel.addMouseMotionListener((MouseMotionListener)this.fDragAndDropListener);
        this.fInnerPanel.add((Component)mJLabel);
        this.fInnerPanel.add((Component)this.fRuleTypeCombo);
        this.fInnerPanel.add((Component)this.fRuleTargetCombo);
        this.add((Component)this.fInnerPanel, "West");
        worksheetRule22 = new MJPanel((LayoutManager)new GridLayout(1, 2, 0, 0));
        worksheetRule22.setBorder(null);
        ImageIcon imageIcon = MJUtilities.isHighContrast() ? new ImageIcon(WorksheetRulePanel.class.getResource("/com/mathworks/mlwidgets/importtool/resources/plus_hc.png")) : new ImageIcon(WorksheetRulePanel.class.getResource("/com/mathworks/mlwidgets/importtool/resources/plus.png"));
        final TSButton tSButton = new TSButton((Icon)imageIcon);
        tSButton.setToolTipText(ImportToolUtils.getResourceString("ruletooltip.addrule"));
        tSButton.setName("WorksheetRulePanel:plus");
        tSButton.setBorderPainted(false);
        tSButton.setPreferredSize(new Dimension(this.fRuleTargetCombo.getPreferredSize().height, this.fRuleTargetCombo.getPreferredSize().height));
        tSButton.setContentAreaFilled(true);
        tSButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WorksheetRulePanel.setupMultiselectForButton(tSButton);
                WorksheetRulePanel worksheetRulePanel = new WorksheetRulePanel(WorksheetRulePanel.this.fWorksheetRuleList, new NonNumericReplacementRule(), WorksheetRulePanel.this.fWorksheetRulePrototypes);
                worksheetRulePanel.getRuleTypeCombo().setSelectedIndex(0);
                WorksheetRulePanel.this.fWorksheetRuleList.addWorksheetRulePanel(worksheetRulePanel);
                WorksheetRulePanel.this.fWorksheetRuleList.revalidate();
                WorksheetRulePanel.this.fWorksheetRuleList.repaint();
                WorksheetRulePanel.this.fWorksheetRuleList.fireWorksheetRuleChanged();
            }
        });
        ImageIcon imageIcon2 = MJUtilities.isHighContrast() ? new ImageIcon(WorksheetRulePanel.class.getResource("/com/mathworks/mlwidgets/importtool/resources/minus_hc.png")) : new ImageIcon(WorksheetRulePanel.class.getResource("/com/mathworks/mlwidgets/importtool/resources/minus.png"));
        TSButton tSButton2 = new TSButton((Icon)imageIcon2);
        tSButton2.setName("WorksheetRulePanel:minus");
        tSButton2.setBorderPainted(false);
        tSButton2.setContentAreaFilled(false);
        tSButton2.setToolTipText(ImportToolUtils.getResourceString("ruletooltip.removerule"));
        tSButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WorksheetRulePanel.this.fWorksheetRuleList.removeWorksheetRulePanelWithPrompt(WorksheetRulePanel.this);
                WorksheetRulePanel.this.fWorksheetRuleList.fireWorksheetRuleChanged();
            }
        });
        tSButton2.setPreferredSize(new Dimension(this.fRuleTargetCombo.getPreferredSize().height, this.fRuleTargetCombo.getPreferredSize().height));
        worksheetRule22.add((Component)tSButton2);
        worksheetRule22.add((Component)tSButton);
        this.add((Component)((Object)worksheetRule22), "East");
        this.fWorksheetRule = worksheetRule;
        this.popupateRuleTargetCombo(worksheetRule.getType());
        for (int i = 0; i < this.fRuleTargetCombo.getItemCount(); ++i) {
            if (!this.fRuleTargetCombo.getItemAt(i).toString().equals(worksheetRule.toString())) continue;
            this.fRuleTargetCombo.setSelectedIndex(i);
            break;
        }
        this.fRuleTypeIcon.setFillColor(this.fWorksheetRule.getType().getColor());
        this.setMinimumSize(new Dimension(this.getPreferredSize().width, this.fRuleTargetCombo.getPreferredSize().height + 2));
    }

    private static void setupMultiselectForButton(TSButton tSButton) {
        OverlayManager overlayManager = OverlayManagers.get((Component)tSButton);
        if (overlayManager != null) {
            overlayManager.setAllowMultiSelect((Component)tSButton, true);
        }
    }

    void setColumnExcludeRulesTransparent(boolean bl) {
        this.fColumnExcludeRulesTransparent = bl;
        if (this.fWorksheetRule.getType() != WorksheetRule.RuleType.COLUMNEXCLUDE || this.fRuleTypeIcon.isTransparent() == bl) {
            return;
        }
        this.fRuleTypeIcon.setTransparent(bl);
        this.repaint();
    }

    List<WorksheetRule> getRulePrototypes() {
        return this.fWorksheetRulePrototypes;
    }

    JComboBox getRuleTargetCombo() {
        return this.fRuleTargetCombo;
    }

    JComboBox getRuleTypeCombo() {
        return this.fRuleTypeCombo;
    }

    void setHighlightedEdge(HighlightedEdge highlightedEdge) {
        if (this.fHighlightedEdge != highlightedEdge) {
            switch (highlightedEdge) {
                case NONE: {
                    this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.lightGray));
                    break;
                }
                case UPPER: {
                    this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.black));
                    break;
                }
                case LOWER: {
                    this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.black));
                }
            }
            this.fHighlightedEdge = highlightedEdge;
            this.fWorksheetRuleList.revalidate();
            this.fWorksheetRuleList.repaint();
        }
    }

    public WorksheetRule getWorksheetRule() {
        return this.fWorksheetRule;
    }

    private void popupateRuleTargetCombo(WorksheetRule.RuleType ruleType) {
        this.fInnerPanel.remove((Component)this.fRuleTargetCombo);
        if (this.fRuleTargetCombo != null) {
            this.fRuleTargetCombo.removeItemListener(this.fItemListener);
        }
        this.fRuleTargetCombo = WorksheetRulePanel.createRuleTargetCombo(null, this.fWorksheetRulePrototypes, ruleType);
        this.fWorksheetRule = (WorksheetRule)this.fRuleTargetCombo.getItemAt(0);
        this.fInnerPanel.add((Component)this.fRuleTargetCombo);
        if (this.fWorksheetRule instanceof StringReplacementRule) {
            ((WorksheetRulePanelComboBox)((Object)this.fRuleTargetCombo)).addAndSelectEditableItem(((StringReplacementRule)this.fWorksheetRule).getTargetString());
        }
        this.fRuleTargetCombo.addItemListener(this.fItemListener);
        this.updateWorksheetRuleEditor(this.fWorksheetRule);
        if (this.fWorksheetRuleList != null) {
            this.fWorksheetRuleList.synchronizePreferredSizes();
        }
    }

    private BufferedImage createPanelImage() {
        Rectangle rectangle = this.getBounds();
        BufferedImage bufferedImage = (BufferedImage)this.createImage(rectangle.width, rectangle.height);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.print(graphics2D);
        return bufferedImage;
    }

    private void updateWorksheetRuleEditor(WorksheetRule worksheetRule) {
        if (this.fRuleEditor != null) {
            this.fInnerPanel.remove(this.fRuleEditor);
        }
        if (worksheetRule != null && worksheetRule.getEditor() != null) {
            this.fRuleEditor = worksheetRule.getEditor();
            this.fRuleEditor.setVisible(true);
            this.fInnerPanel.add(this.fRuleEditor);
            worksheetRule.removeWorksheetRuleListener(this);
            worksheetRule.addWorksheetRuleListener(this);
        }
    }

    void commit() {
        if (this.fRuleTargetCombo instanceof WorksheetRulePanelComboBox) {
            ((WorksheetRulePanelComboBox)((Object)this.fRuleTargetCombo)).editingStopped();
        }
        if (this.fRuleEditor != null) {
            for (FocusListener focusListener : this.fRuleEditor.getFocusListeners()) {
                focusListener.focusLost(new FocusEvent(this.fRuleEditor, 1005));
            }
        }
    }

    private static List<WorksheetRule> createWorksheetRules(List<WorksheetRule> list, WorksheetRule.RuleType ruleType) {
        ArrayList<WorksheetRule> arrayList = new ArrayList<WorksheetRule>();
        for (WorksheetRule worksheetRule : list) {
            if (ruleType != worksheetRule.getType()) continue;
            arrayList.add((WorksheetRule)worksheetRule.clone());
        }
        return arrayList;
    }

    @Override
    public void ruleChanged(List<WorksheetRule> list) {
        this.fDragAndDropListener.clearDragImage();
        if (this.fWorksheetRuleList != null) {
            this.fWorksheetRuleList.fireWorksheetRuleChanged();
        }
    }

    private static JComboBox createRuleTargetCombo(ItemListener itemListener, List<WorksheetRule> list, WorksheetRule.RuleType ruleType) {
        List<WorksheetRule> list2 = WorksheetRulePanel.createWorksheetRules(list, ruleType);
        JComboBox jComboBox = ruleType.createRuleTargetCombo(list2);
        if (itemListener != null) {
            jComboBox.addItemListener(itemListener);
        }
        return jComboBox;
    }

    private class DragAndDropListener
    extends MouseAdapter
    implements AWTEventListener {
        private DragWindow iDragWindow;

        private DragAndDropListener() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.iDragWindow == null) {
                this.iDragWindow = new DragWindow((Component)((Object)WorksheetRulePanel.this), WorksheetRulePanel.this.createPanelImage());
            }
            if (!this.iDragWindow.isVisible()) {
                this.iDragWindow.show();
                Toolkit.getDefaultToolkit().addAWTEventListener(this, 16L);
            }
            Point point = mouseEvent.getPoint();
            point = SwingUtilities.convertPoint((Component)((Object)WorksheetRulePanel.this), point, (Component)((Object)WorksheetRulePanel.this.fWorksheetRuleList));
            int n = WorksheetRulePanel.this.fWorksheetRuleList.getHoverWorksheetRulePanelEdge(point);
            WorksheetRulePanel.this.fWorksheetRuleList.scrollEdgeToVisible(n);
            WorksheetRulePanel.this.fWorksheetRuleList.setHighlightedEdge(n);
            point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
            this.iDragWindow.setLocation(point.x + 10, point.y + 10);
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            if (aWTEvent.getID() == 502) {
                if (this.iDragWindow != null && this.iDragWindow.isVisible()) {
                    WorksheetRulePanel.this.fWorksheetRuleList.setHighlightedEdge(-1);
                    this.iDragWindow.hide();
                    Point point = ((MouseEvent)aWTEvent).getPoint();
                    point = SwingUtilities.convertPoint((Component)((Object)WorksheetRulePanel.this), point, (Component)((Object)WorksheetRulePanel.this.fWorksheetRuleList));
                    int n = WorksheetRulePanel.this.fWorksheetRuleList.getHoverWorksheetRulePanelEdge(point);
                    WorksheetRulePanel.this.fWorksheetRuleList.moveWorksheetRulePanel(WorksheetRulePanel.this, n);
                }
                Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            }
        }

        void clearDragImage() {
            this.iDragWindow = null;
        }
    }

    static class PlainComboBoxUI
    extends BasicComboBoxUI {
        PlainComboBoxUI() {
        }

        public static ComponentUI createUI(JComponent jComponent) {
            return new PlainComboBoxUI();
        }

        @Override
        protected JButton createArrowButton() {
            JButton jButton = new JButton(new ImageIcon(WorksheetRulePanel.class.getResource("/com/mathworks/mlwidgets/importtool/resources/downarrow.gif")));
            jButton.setUI(new BasicButtonUI());
            jButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(-1, 0, -1, 0), BorderFactory.createMatteBorder(0, 0, 0, 1, Color.lightGray)));
            jButton.setBorderPainted(true);
            jButton.setOpaque(false);
            return jButton;
        }
    }

    private static class RuleTypeIcon
    implements Icon {
        private Color iColor = Color.red;
        private boolean iIsTransparent = false;

        private RuleTypeIcon() {
        }

        void setFillColor(Color color) {
            this.iColor = color;
        }

        @Override
        public int getIconHeight() {
            return 11;
        }

        @Override
        public int getIconWidth() {
            return 11;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setColor(this.iColor);
            if (!this.iIsTransparent) {
                graphics2D.fillRect(n, n2, 11, 11);
            }
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(n, n2, 11, 11);
            graphics2D.dispose();
        }

        private void setTransparent(boolean bl) {
            this.iIsTransparent = bl;
        }

        private boolean isTransparent() {
            return this.iIsTransparent;
        }
    }

    static class PromptPanel
    extends MJPanel {
        private WorksheetRuleList iWorksheetRuleList;
        private TSButton fPlusButton;
        private MJLabel iPromptLabel;
        private List<WorksheetRule> iWorksheetRulePrototypes;

        TSButton getPlusButton() {
            return this.fPlusButton;
        }

        PromptPanel(WorksheetRuleList worksheetRuleList, List<WorksheetRule> list) {
            super((LayoutManager)new BorderLayout());
            this.iWorksheetRulePrototypes = list;
            this.setName("PromptPanel");
            this.iWorksheetRuleList = worksheetRuleList;
            this.iPromptLabel = new MJLabel(ImportToolUtils.getResourceString("rulepanel.promptlabel"));
            this.iPromptLabel.setName("WorksheetRulePanel.PromptLabel");
            this.iPromptLabel.setForeground(Color.gray);
            this.add((Component)this.iPromptLabel, "West");
            this.fPlusButton = new TSButton((Icon)new ImageIcon(WorksheetRulePanel.class.getResource("/com/mathworks/mlwidgets/importtool/resources/plus.png")));
            this.fPlusButton.setToolTipText(ImportToolUtils.getResourceString("ruletooltip.addruleempty"));
            this.fPlusButton.setBorderPainted(true);
            this.fPlusButton.setPreferredSize(new Dimension(this.iPromptLabel.getPreferredSize().height, this.iPromptLabel.getPreferredSize().height));
            this.fPlusButton.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 1, 0, Color.lightGray), BorderFactory.createEmptyBorder(0, 0, -1, 0)));
            this.fPlusButton.setContentAreaFilled(false);
            this.fPlusButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WorksheetRulePanel.setupMultiselectForButton(PromptPanel.this.fPlusButton);
                    PromptPanel.this.iWorksheetRuleList.remove((Component)((Object)PromptPanel.this));
                    PromptPanel.this.iWorksheetRuleList.addWorksheetRulePanel(new WorksheetRulePanel(PromptPanel.this.iWorksheetRuleList, new NonNumericReplacementRule(), PromptPanel.this.iWorksheetRulePrototypes));
                    PromptPanel.this.iWorksheetRuleList.revalidate();
                    PromptPanel.this.iWorksheetRuleList.repaint();
                    PromptPanel.this.iWorksheetRuleList.fireWorksheetRuleChanged();
                }
            });
            this.add((Component)this.fPlusButton, "East");
        }

        void setPromptLabelText(String string) {
            this.iPromptLabel.setText(string);
        }
    }

    static enum HighlightedEdge {
        UPPER,
        LOWER,
        NONE;

    }
}

