/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool.popuplist;

import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.popuplist.EditablePopupList;
import com.mathworks.mlwidgets.importtool.popuplist.EditablePopupListItem;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.toolstrip.components.TSLabel;
import com.mathworks.toolstrip.components.TSPanel;
import com.mathworks.toolstrip.components.TSTextField;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;

public class EditablePopupButton
extends TSPanel
implements EditablePopupList.EditablePopupListSelectionListener,
EditablePopupList.EditablePopupListComponent {
    static final ImageIcon downArrow = new ImageIcon(ImportToolUtils.class.getResource("/com/mathworks/mlwidgets/importtool/resources/popupListButtonArrow.png"));
    static final ImageIcon upArrow = new ImageIcon(ImportToolUtils.class.getResource("/com/mathworks/mlwidgets/importtool/resources/popupListButtonArrow.png"));
    private PopupButtonMouseFocusLostListener fPopupButtonMouseFocusLostListener = new PopupButtonMouseFocusLostListener();
    protected TSLabel fLabel;
    private TSLabel fIconLabel;
    private TSLabel fOptionalIconLabel;
    protected TSTextField fTextField;
    private boolean fCoalesceSelection = false;
    private String fInitialText = "";
    protected EditablePopupList fList;
    private ArrayList<EditablePopupListSelectionListener> fSelectionListeners = new ArrayList();
    private ArrayList<EditablePopupListItemListener> fItemListeners = new ArrayList();
    protected boolean fIsAdjusting = false;
    protected boolean fCloseOnSelection = false;
    protected boolean fAllowEmptySelection = true;
    protected boolean fEditable = false;
    protected boolean fSingleSelectionEnabled = false;
    protected boolean fStopEditingOnFocusLost = true;

    public EditablePopupButton(String string) {
        this(string, true);
        this.setFocusable(true);
    }

    public EditablePopupButton(String string, boolean bl) {
        this(string, bl, null);
    }

    public EditablePopupButton(String string, boolean bl, Icon icon) {
        this.fInitialText = string;
        this.fCoalesceSelection = bl;
        BevelBorder bevelBorder = new BevelBorder(1);
        this.setBorder(bevelBorder);
        this.fLabel = new TSLabel(string, null, 10);
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.fIconLabel = new TSLabel((Icon)downArrow);
        this.fTextField = new TSTextField(string);
        this.fLabel.setHorizontalAlignment(10);
        this.fLabel.setHorizontalTextPosition(10);
        this.setComponentNames("EditablePopupButton:" + string);
        BorderLayout borderLayout = new BorderLayout(2, 1);
        this.setLayout(borderLayout);
        this.add((Component)this.fLabel, "Center");
        this.add((Component)this.fIconLabel, "East");
        if (icon != null) {
            this.fOptionalIconLabel = new TSLabel(icon);
            this.add((Component)this.fOptionalIconLabel, "West");
        }
        Insets insets = bevelBorder.getBorderInsets((Component)((Object)this));
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.fTextField.getPreferredSize().height + insets.top + insets.bottom));
        this.fList = new EditablePopupList(this);
        this.fList.addSelectionListener(this);
        this.fList.addItemListener(new EditablePopupList.EditablePopupListItemListener(){

            @Override
            public void itemAdded(EditablePopupList editablePopupList, EditablePopupListItem editablePopupListItem) {
                EditablePopupButton.this.updateDisplayText();
                EditablePopupButton.this.fireItemAddedEvent(editablePopupList, editablePopupListItem);
            }

            @Override
            public void itemRemoved(EditablePopupList editablePopupList, EditablePopupListItem editablePopupListItem) {
                EditablePopupButton.this.updateDisplayText();
                EditablePopupButton.this.fireItemRemovedEvent(editablePopupList, editablePopupListItem);
            }

            @Override
            public void itemNameModified(EditablePopupList editablePopupList, EditablePopupListItem editablePopupListItem, String string) {
                EditablePopupButton.this.updateDisplayText();
                EditablePopupButton.this.fireItemNameModifiedEvent(editablePopupList, editablePopupListItem, string);
            }

            @Override
            public void itemDescriptionModified(EditablePopupList editablePopupList, EditablePopupListItem editablePopupListItem, String string) {
                EditablePopupButton.this.fireItemDescriptionModifiedEvent(editablePopupList, editablePopupListItem, string);
            }
        });
        this.fLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (EditablePopupButton.this.isEnabled()) {
                    if (EditablePopupButton.this.fEditable && !EditablePopupButton.this.fIsAdjusting) {
                        EditablePopupButton.this.fIsAdjusting = true;
                        EditablePopupButton.this.enableEditor();
                        EditablePopupButton.this.fIsAdjusting = false;
                    } else if (EditablePopupButton.this.fList.isVisible()) {
                        EditablePopupButton.this.fList.setVisible(false);
                    } else {
                        EditablePopupButton.this.fList.setVisible(true);
                    }
                }
            }
        });
        this.fIconLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (EditablePopupButton.this.isEnabled()) {
                    if (EditablePopupButton.this.fList.isVisible()) {
                        EditablePopupButton.this.fList.setVisible(false);
                    } else {
                        EditablePopupButton.this.fList.setVisible(true);
                    }
                }
            }
        });
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (EditablePopupButton.this.fEditable && EditablePopupButton.this.fLabel.contains(mouseEvent.getPoint())) {
                    EditablePopupButton.this.setCursor(EditablePopupListItem.EDIT_CURSOR);
                } else {
                    EditablePopupButton.this.setCursor(EditablePopupListItem.DEFAULT_CURSOR);
                }
            }
        });
        this.fTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditablePopupButton.this.saveAndDisableEditor();
            }
        });
        this.fTextField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    EditablePopupButton.this.cancelAndDisableEditor();
                } else if (keyEvent.getKeyCode() == 10) {
                    EditablePopupButton.this.saveAndDisableEditor();
                }
            }
        });
        this.fTextField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    EditablePopupButton.this.saveAndDisableEditor();
                }
            }
        });
    }

    public void cleanup() {
        int n;
        FocusListener[] focusListenerArray = this.fTextField.getFocusListeners();
        EventListener[] eventListenerArray = focusListenerArray;
        int n2 = eventListenerArray.length;
        for (n = 0; n < n2; ++n) {
            FocusListener focusListener = eventListenerArray[n];
            this.fTextField.removeFocusListener(focusListener);
        }
        EventListener[] eventListenerArray2 = eventListenerArray = this.fTextField.getKeyListeners();
        n = eventListenerArray2.length;
        for (int i = 0; i < n; ++i) {
            EventListener eventListener = eventListenerArray2[i];
            this.fTextField.removeKeyListener((KeyListener)eventListener);
        }
        for (EventListener eventListener : eventListenerArray2 = this.fTextField.getActionListeners()) {
            this.fTextField.removeActionListener((ActionListener)eventListener);
        }
        this.fTextField.getCaret().setVisible(false);
        this.fTextField = null;
        if (this.fList != null) {
            this.fList.setVisible(false);
        }
        this.removeFocusListener();
        if (this.getParent() != null) {
            this.getParent().remove((Component)((Object)this));
        }
    }

    public void setComponentNames(String string) {
        this.fLabel.setName(string + ":label");
        this.fTextField.setName(string + ":textfield");
        this.fIconLabel.setName(string + ":iconlabel");
        this.setName(string + ":panel");
    }

    public Icon getIcon() {
        if (this.fOptionalIconLabel == null) {
            return null;
        }
        return this.fOptionalIconLabel.getIcon();
    }

    public void setIcon(Icon icon) {
        if (this.fOptionalIconLabel != null) {
            this.remove((Component)this.fOptionalIconLabel);
        }
        this.fOptionalIconLabel = null;
        if (icon != null) {
            this.fOptionalIconLabel = new TSLabel(icon);
            this.add((Component)this.fOptionalIconLabel, "West");
            this.repaint();
        }
    }

    public boolean isEditing() {
        return this.equals(this.fTextField.getParent());
    }

    protected TSLabel getLabel() {
        return this.fLabel;
    }

    protected TSLabel getIconLabel() {
        return this.fIconLabel;
    }

    public boolean isCoalescingSelection() {
        return this.fCoalesceSelection;
    }

    public void setCoalesceSelection(boolean bl) {
        this.fCoalesceSelection = bl;
    }

    public void setEnabled(boolean bl) {
        if (!bl && this.fList.isVisible()) {
            this.fList.setVisible(false);
        }
        this.fLabel.setEnabled(bl);
        this.fIconLabel.setEnabled(bl);
        if (this.fOptionalIconLabel != null) {
            this.fOptionalIconLabel.setEnabled(bl);
        }
        super.setEnabled(bl);
    }

    public int getItemCount() {
        return this.fList.getItemCount();
    }

    public TSTextField getEditor() {
        return this.fTextField;
    }

    public EditablePopupList getItemList() {
        return this.fList;
    }

    public EditablePopupListItem getItemAt(int n) {
        return this.fList.getItems().get(n);
    }

    public void addItem(EditablePopupListItem editablePopupListItem) {
        this.fList.addItem(editablePopupListItem);
    }

    public EditablePopupListItem addItem(String string) {
        EditablePopupListItem editablePopupListItem = new EditablePopupListItem(string, string, EditablePopupListItem.ITEM_TYPE.PLAIN, false);
        this.fList.addItem(editablePopupListItem);
        return editablePopupListItem;
    }

    public void addItemAt(EditablePopupListItem editablePopupListItem, int n) {
        this.fList.addItemAt(editablePopupListItem, n);
    }

    public void addItemAt(String string, int n) {
        EditablePopupListItem editablePopupListItem = new EditablePopupListItem(string, string, EditablePopupListItem.ITEM_TYPE.PLAIN, false);
        this.fList.addItemAt(editablePopupListItem, n);
    }

    public void removeItem(EditablePopupListItem editablePopupListItem) {
        this.fList.removeItem(editablePopupListItem);
    }

    public void removeItem(String string) {
        List<EditablePopupListItem> list = this.fList.getItems();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getValue().equals(string)) continue;
            this.fList.removeItem(list.get(i));
            break;
        }
    }

    public void removeItemAt(int n) {
        this.fList.removeItemAt(n);
    }

    public void removeAllItems() {
        this.fList.removeAllItems();
    }

    public void setText(String string) {
        this.fInitialText = string;
        this.fLabel.setText(string);
        this.fTextField.setText(string);
        this.repaint();
    }

    public void setEditText(String string) {
        this.fTextField.setText(string);
        this.repaint();
    }

    public String getText() {
        return this.fTextField.getText();
    }

    public String toString() {
        return this.getCoalescedString();
    }

    private void enableEditor() {
        this.fInitialText = this.fTextField.getText();
        this.remove((Component)this.fLabel);
        this.add((Component)this.fTextField, "Center");
        this.fTextField.setText(this.fInitialText);
        this.validate();
        this.repaint();
        this.fTextField.selectAll();
        this.fTextField.requestFocusInWindow();
        this.fTextField.requestFocus();
        this.fTextField.getCaret().setVisible(true);
        long l = 16L;
        this.removeFocusListener();
        Toolkit.getDefaultToolkit().addAWTEventListener(this.fPopupButtonMouseFocusLostListener, l);
    }

    public boolean getStopEditingOnFocusLost() {
        return this.fStopEditingOnFocusLost;
    }

    public void setStopEditingOnFocusLost(boolean bl) {
        this.fStopEditingOnFocusLost = bl;
    }

    private void cancelAndDisableEditor() {
        this.fTextField.setText(this.fInitialText);
        this.fLabel.setText(this.fInitialText);
        if (this.fStopEditingOnFocusLost) {
            this.remove((Component)this.fTextField);
            this.add((Component)this.fLabel, "Center");
        }
        this.removeFocusListener();
        this.validate();
        this.repaint();
    }

    protected void removeFocusListener() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.fPopupButtonMouseFocusLostListener);
    }

    protected void saveAndDisableEditor() {
        if (!this.fIsAdjusting) {
            this.fIsAdjusting = true;
            if (this.fTextField.getText().length() == 0) {
                this.cancelAndDisableEditor();
                this.fIsAdjusting = false;
                return;
            }
            String string = this.fInitialText;
            this.fInitialText = this.fTextField.getText();
            this.fLabel.setText(this.fInitialText);
            if (!this.containsItem(this.fInitialText)) {
                EditablePopupListItem editablePopupListItem = this.addItem(this.fInitialText);
                editablePopupListItem.setSelected(true);
            } else {
                this.getItem(this.fInitialText).setSelected(true);
            }
            if (this.fStopEditingOnFocusLost) {
                this.remove((Component)this.fTextField);
                this.add((Component)this.fLabel, "Center");
            }
            this.validate();
            this.repaint();
            this.fIsAdjusting = false;
            this.removeFocusListener();
            return;
        }
    }

    public void edit() {
        this.enableEditor();
    }

    @Override
    public void selectionChanged(EditablePopupList editablePopupList, EditablePopupListItem editablePopupListItem) {
        if (!this.fIsAdjusting) {
            this.fIsAdjusting = true;
            if (!(this.fAllowEmptySelection || this.getSelectedItems() != null && this.getSelectedItems().length != 0)) {
                editablePopupListItem.setSelected(true);
            } else {
                this.fireSelectionChangedEvent(editablePopupList, editablePopupListItem);
            }
            if (this.getSelectedItems().length > 1 && this.fSingleSelectionEnabled && editablePopupListItem.isSelected()) {
                List<EditablePopupListItem> list = this.fList.getItems();
                for (int i = 0; i < list.size(); ++i) {
                    if (list.get(i).equals((Object)editablePopupListItem) || !list.get(i).isSelected()) continue;
                    list.get(i).setSelected(false);
                    this.fireSelectionChangedEvent(editablePopupList, list.get(i));
                }
            }
            this.updateDisplayText();
            this.fIsAdjusting = false;
            if (this.fCloseOnSelection && this.fList.isVisible()) {
                this.fList.setVisible(false);
            }
        }
        this.fireSelectionChangedEvent(editablePopupList, editablePopupListItem);
    }

    @Override
    public void temporarySelectionChanged(EditablePopupList editablePopupList, EditablePopupListItem editablePopupListItem) {
        this.fireTemporarySelectionChangedEvent(editablePopupList, editablePopupListItem);
    }

    protected void updateDisplayText() {
        String string = this.getCoalescedString();
        this.fLabel.setText(string);
        this.fTextField.setText(string);
        this.setToolTipText(string);
        this.validate();
        this.repaint();
    }

    public boolean isListVisible() {
        return this.fList.isVisible();
    }

    public EditablePopupListItem[] getSelectedItems() {
        return this.fList.getSelectedItems();
    }

    public String getCoalescedString() {
        EditablePopupListItem[] editablePopupListItemArray;
        if (this.fCoalesceSelection && !this.fEditable && (editablePopupListItemArray = this.fList.getSelectedItems()) != null && editablePopupListItemArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < editablePopupListItemArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(editablePopupListItemArray[i].getDisplayName());
            }
            return stringBuilder.toString();
        }
        return this.fInitialText;
    }

    public boolean getCloseOnFocusLost() {
        return this.fList.getCloseOnFocusLost();
    }

    public void setCloseOnFocusLost(boolean bl) {
        this.fList.setCloseOnFocusLost(bl);
    }

    public boolean getCloseOnSelection() {
        return this.fCloseOnSelection;
    }

    public void setCloseOnSelection(boolean bl) {
        this.fCloseOnSelection = bl;
    }

    public boolean getSelectionAdjusting() {
        return this.fIsAdjusting;
    }

    public boolean getAllowEmptySelection() {
        return this.fAllowEmptySelection;
    }

    public void setAllowEmptySelection(boolean bl) {
        this.fAllowEmptySelection = bl;
    }

    public boolean isEditable() {
        return this.fEditable;
    }

    public void setEditable(boolean bl) {
        this.fEditable = bl;
    }

    public boolean isSingleSelectionEnabled() {
        return this.fSingleSelectionEnabled;
    }

    public void setSingleSelectionEnabled(boolean bl) {
        this.fSingleSelectionEnabled = bl;
    }

    public void setSelectedItem(EditablePopupListItem editablePopupListItem) {
        this.fList.removeSelectionListener(this);
        for (EditablePopupListItem editablePopupListItem2 : this.getItemList().getItems()) {
            if (editablePopupListItem2.equals((Object)editablePopupListItem)) {
                editablePopupListItem2.setSelected(true);
                this.fireSelectionChangedEvent(this.fList, editablePopupListItem2);
                continue;
            }
            if (!editablePopupListItem2.isSelected()) continue;
            editablePopupListItem2.setSelected(false);
            this.fireSelectionChangedEvent(this.fList, editablePopupListItem2);
        }
        this.fList.addSelectionListener(this);
        this.updateDisplayText();
    }

    public void setSelectedItem(String string) {
        this.fList.removeSelectionListener(this);
        EditablePopupListItem editablePopupListItem = this.getItem(string);
        for (EditablePopupListItem editablePopupListItem2 : this.getItemList().getItems()) {
            if (editablePopupListItem2.equals((Object)editablePopupListItem)) {
                editablePopupListItem2.setSelected(true);
                continue;
            }
            if (!editablePopupListItem2.isSelected()) continue;
            editablePopupListItem2.setSelected(false);
        }
        this.fList.addSelectionListener(this);
        this.updateDisplayText();
    }

    public boolean containsItem(EditablePopupListItem editablePopupListItem) {
        boolean bl = false;
        for (EditablePopupListItem editablePopupListItem2 : this.getItemList().getItems()) {
            if (!editablePopupListItem2.equals((Object)editablePopupListItem)) continue;
            return true;
        }
        return bl;
    }

    public boolean containsItem(String string) {
        boolean bl = false;
        for (EditablePopupListItem editablePopupListItem : this.getItemList().getItems()) {
            if (!editablePopupListItem.equals(string)) continue;
            return true;
        }
        return bl;
    }

    public EditablePopupListItem getItem(String string) {
        for (EditablePopupListItem editablePopupListItem : this.getItemList().getItems()) {
            if (!editablePopupListItem.equals(string)) continue;
            return editablePopupListItem;
        }
        return null;
    }

    public void setWaitCursorEnabled(boolean bl) {
        this.fList.setWaitCursorEnabled(bl);
    }

    public void addSelectionListener(EditablePopupListSelectionListener editablePopupListSelectionListener) {
        this.fSelectionListeners.add(editablePopupListSelectionListener);
    }

    public void removeSelectionListener(EditablePopupListSelectionListener editablePopupListSelectionListener) {
        this.fSelectionListeners.remove(editablePopupListSelectionListener);
    }

    public List<EditablePopupListSelectionListener> getSelectionListeners() {
        return this.fSelectionListeners;
    }

    public void addItemListener(EditablePopupListItemListener editablePopupListItemListener) {
        this.fItemListeners.add(editablePopupListItemListener);
    }

    public void removeItemListener(EditablePopupListItemListener editablePopupListItemListener) {
        this.fItemListeners.remove(editablePopupListItemListener);
    }

    @Override
    public JFrame getRootFrame() {
        return (JFrame)SwingUtilities.getRoot((Component)((Object)this));
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public Rectangle getComponentScreenBounds() {
        Rectangle rectangle = this.getBounds();
        Point point = new Point(-1, -1);
        if (SwingUtilities.getRoot((Component)((Object)this)) != null && this.isVisible()) {
            point = this.getLocationOnScreen();
        } else if (this.isVisible()) {
            point = this.getLocation();
            SwingUtilities.convertPointToScreen(point, (Component)((Object)this));
        }
        rectangle.x = point.x;
        rectangle.y = point.y;
        return rectangle;
    }

    @Override
    public void listVisibilityChanged(boolean bl) {
        if (bl) {
            this.fIconLabel.setIcon((Icon)upArrow);
        } else {
            this.fIconLabel.setIcon((Icon)downArrow);
        }
        this.fIconLabel.repaint();
    }

    private void fireSelectionChangedEvent(EditablePopupList editablePopupList, EditablePopupListItem editablePopupListItem) {
        for (int i = 0; i < this.fSelectionListeners.size(); ++i) {
            this.fSelectionListeners.get(i).selectionChanged(new EditablePopupEvent(this, editablePopupList, editablePopupListItem, editablePopupListItem.getDisplayName()));
        }
    }

    private void fireTemporarySelectionChangedEvent(EditablePopupList editablePopupList, EditablePopupListItem editablePopupListItem) {
        for (int i = 0; i < this.fSelectionListeners.size(); ++i) {
            this.fSelectionListeners.get(i).temporarySelectionChanged(new EditablePopupEvent(this, editablePopupList, editablePopupListItem, editablePopupListItem.getDisplayName()));
        }
    }

    private void fireItemAddedEvent(EditablePopupList editablePopupList, EditablePopupListItem editablePopupListItem) {
        for (int i = 0; i < this.fItemListeners.size(); ++i) {
            this.fItemListeners.get(i).itemAdded(new EditablePopupEvent(this, editablePopupList, editablePopupListItem, editablePopupListItem.getDisplayName()));
        }
    }

    private void fireItemRemovedEvent(EditablePopupList editablePopupList, EditablePopupListItem editablePopupListItem) {
        for (int i = 0; i < this.fItemListeners.size(); ++i) {
            this.fItemListeners.get(i).itemRemoved(new EditablePopupEvent(this, editablePopupList, editablePopupListItem, editablePopupListItem.getDisplayName()));
        }
    }

    private void fireItemNameModifiedEvent(EditablePopupList editablePopupList, EditablePopupListItem editablePopupListItem, String string) {
        for (int i = 0; i < this.fItemListeners.size(); ++i) {
            this.fItemListeners.get(i).itemNameModified(new EditablePopupEvent(this, editablePopupList, editablePopupListItem, string));
        }
    }

    private void fireItemDescriptionModifiedEvent(EditablePopupList editablePopupList, EditablePopupListItem editablePopupListItem, String string) {
        for (int i = 0; i < this.fItemListeners.size(); ++i) {
            this.fItemListeners.get(i).itemDescriptionModified(new EditablePopupEvent(this, editablePopupList, editablePopupListItem, string));
        }
    }

    public class PopupButtonMouseFocusLostListener
    implements AWTEventListener {
        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            try {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                if (EditablePopupButton.this.isVisible() && mouseEvent.getClickCount() > 0 && mouseEvent.getID() == 501 && !(mouseEvent.getSource() instanceof MJMenuItem)) {
                    Point point = mouseEvent.getLocationOnScreen();
                    Rectangle rectangle = EditablePopupButton.this.getBounds();
                    Point point2 = EditablePopupButton.this.getLocationOnScreen();
                    rectangle.x = point2.x;
                    rectangle.y = point2.y;
                    if (!rectangle.contains(point)) {
                        EditablePopupButton.this.saveAndDisableEditor();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class EditablePopupEvent {
        private EditablePopupButton fButton;
        private EditablePopupList fList;
        private EditablePopupListItem fItem;
        private String fOldValue;

        public EditablePopupEvent(EditablePopupButton editablePopupButton2, EditablePopupList editablePopupList, EditablePopupListItem editablePopupListItem, String string) {
            this.fButton = editablePopupButton2;
            this.fList = editablePopupList;
            this.fItem = editablePopupListItem;
            this.fOldValue = string;
        }

        public EditablePopupButton getButton() {
            return this.fButton;
        }

        public EditablePopupList getList() {
            return this.fList;
        }

        public EditablePopupListItem getItem() {
            return this.fItem;
        }

        public String getOldValue() {
            return this.fOldValue;
        }
    }

    public static interface EditablePopupListItemListener {
        public void itemAdded(EditablePopupEvent var1);

        public void itemRemoved(EditablePopupEvent var1);

        public void itemNameModified(EditablePopupEvent var1);

        public void itemDescriptionModified(EditablePopupEvent var1);
    }

    public static interface EditablePopupListSelectionListener {
        public void selectionChanged(EditablePopupEvent var1);

        public void temporarySelectionChanged(EditablePopupEvent var1);
    }
}

