/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool.popuplist;

import com.mathworks.desktop.overlay.Overlay;
import com.mathworks.desktop.overlay.OverlayManager;
import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.desktop.overlay.OverlayType;
import com.mathworks.mlwidgets.actionbrowser.ActionToolTip;
import com.mathworks.mlwidgets.importtool.CustomActionTooltipListener;
import com.mathworks.mlwidgets.importtool.popuplist.EditablePopupListItem;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.toolstrip.components.TSPanel;
import com.mathworks.toolstrip.components.TSScrollPane;
import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.util.Log;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class EditablePopupList
implements FocusListener,
WindowFocusListener {
    private EditablePopupListComponent fComponent;
    private ArrayList<EditablePopupListItem> fItems = new ArrayList();
    private TSScrollPane fScrollPane;
    private HashMap<String, ArrayList<EditablePopupListItem>> fRadioButtonGroups = new HashMap();
    private JComponent fWindowPanel = new TSPanel((LayoutManager)new BorderLayout());
    private String fWindowName = "EditablePopupListWindow";
    private MJPanel fPanel = new MJPanel();
    private ListMouseFocusLostListener fListMouseFocusLostListener = new ListMouseFocusLostListener();
    private ListKeyboardListener fListKeyboardListener = new ListKeyboardListener();
    private boolean fCloseOnFocusLost = true;
    private boolean fAdjustingSelection = false;
    private boolean fFirstToggle = true;
    private int fMaxWindowHeight = 300;
    private ArrayList<EditablePopupListSelectionListener> fSelectionListeners = new ArrayList();
    private ArrayList<EditablePopupListItemListener> fItemListeners = new ArrayList();
    private ComponentListener fComponentListener;
    private ActionToolTip fActionTip;
    private CustomActionTooltipListener fActionTTListener;
    private Overlay fOverlay;
    private Component fPreviousFocusOwner;

    public EditablePopupList(EditablePopupListComponent editablePopupListComponent) {
        this.fComponent = editablePopupListComponent;
        this.fPanel.setLayout((LayoutManager)new GridBagLayout());
        this.fScrollPane = new TSScrollPane((Component)this.fPanel, 20, 31);
        this.fComponentListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                if (EditablePopupList.this.isVisible()) {
                    EditablePopupList.this.hideMenu();
                }
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                if (EditablePopupList.this.isVisible()) {
                    EditablePopupList.this.hideMenu();
                }
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (EditablePopupList.this.isVisible()) {
                    EditablePopupList.this.hideMenu();
                }
            }
        };
        this.fWindowPanel.setVisible(false);
    }

    public void hideMenu() {
        if (this.fActionTip != null) {
            this.fActionTTListener.hideActionToolTip();
        }
        this.resetTemporarySelections(null);
        this.setVisible(false);
    }

    public void setVisible(boolean bl) {
        final Component component = this.fComponent.getComponent();
        if (bl) {
            this.resetTemporarySelections(null);
            this.fScrollPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.fMaxWindowHeight));
            this.fScrollPane.validate();
            this.fScrollPane.setWheelScrollingEnabled(true);
            this.fScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            Rectangle rectangle = this.fComponent.getComponentScreenBounds();
            JFrame jFrame = this.fComponent.getRootFrame();
            if (jFrame != null) {
                jFrame.addComponentListener(this.fComponentListener);
            }
            Dimension dimension = this.calculateWindowHeight();
            dimension = new Dimension(Math.max(1, dimension.width), Math.max(1, dimension.height));
            dimension = new Dimension(Math.max(dimension.width, rectangle.width), dimension.height);
            Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
            OverlayManager overlayManager = OverlayManagers.get((Component)component);
            this.fPreviousFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            this.fWindowPanel = new TSPanel((LayoutManager)new BorderLayout());
            this.fWindowPanel.setName(this.fWindowName);
            this.fWindowPanel.add((Component)this.fScrollPane, "Center");
            this.fWindowPanel.setBackground(SystemColor.window);
            this.fWindowPanel.setOpaque(true);
            if (overlayManager != null) {
                if (this.fOverlay != null) {
                    overlayManager.removeOverlay(this.fOverlay);
                    this.fOverlay = null;
                }
                this.fOverlay = new Overlay(){

                    public Component getComponent() {
                        return EditablePopupList.this.fWindowPanel;
                    }

                    public Rectangle layout(Window window) {
                        Rectangle rectangle;
                        Rectangle rectangle2 = EditablePopupList.this.fComponent.getComponentScreenBounds();
                        Dimension dimension = EditablePopupList.this.calculateWindowHeight();
                        Point point = new Point(rectangle2.x, rectangle2.y + rectangle2.height);
                        Rectangle rectangle3 = rectangle = new Rectangle(point, dimension);
                        Window window2 = WindowUtils.getTopmostWindow((Component)component);
                        if (component != null && component.isVisible() && window2 != null) {
                            rectangle3 = LAFUtil.convertRectangleFromScreen((Rectangle)rectangle, (Component)window2);
                        }
                        return rectangle3;
                    }

                    public OverlayType getType() {
                        return new OverlayType(0, Overlay.Mode.AUTO, false);
                    }

                    public void dispose() {
                        EditablePopupList.this.setVisible(false);
                    }
                };
                overlayManager.addOverlay(this.fOverlay, null);
                overlayManager.repaint(this.fOverlay);
                AbstractAction abstractAction = new AbstractAction("escape"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        EditablePopupList.this.setVisible(false);
                        if (EditablePopupList.this.fPreviousFocusOwner != null) {
                            EditablePopupList.this.fPreviousFocusOwner.requestFocusInWindow();
                        }
                    }
                };
                this.fWindowPanel.getInputMap(1).put(KeyStroke.getKeyStroke("ESCAPE"), "escape");
                this.fWindowPanel.getActionMap().put("escape", abstractAction);
                this.fWindowPanel.putClientProperty("temporary-focus-owner", true);
                this.fWindowPanel.requestFocusInWindow();
            }
            long l = 16L;
            Toolkit.getDefaultToolkit().addAWTEventListener(this.fListMouseFocusLostListener, l);
            long l2 = 8L;
            Toolkit.getDefaultToolkit().addAWTEventListener(this.fListKeyboardListener, l2);
            if (this.fFirstToggle) {
                this.fPanel.addFocusListener((FocusListener)this);
                this.fScrollPane.addFocusListener((FocusListener)this);
                this.fFirstToggle = false;
            }
            if (this.fItems.size() > 0) {
                Rectangle rectangle2 = this.fItems.get(0).getBounds();
                this.fPanel.scrollRectToVisible(rectangle2);
            }
            this.fWindowPanel.setVisible(true);
            this.fWindowPanel.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                    for (MouseWheelListener mouseWheelListener : EditablePopupList.this.fScrollPane.getMouseWheelListeners()) {
                        mouseWheelListener.mouseWheelMoved(mouseWheelEvent);
                    }
                }
            });
        } else {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.fListMouseFocusLostListener);
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.fListKeyboardListener);
            JFrame jFrame = this.fComponent.getRootFrame();
            if (jFrame != null) {
                jFrame.removeComponentListener(this.fComponentListener);
            }
            this.resetTemporarySelections(null);
            if (component != null) {
                OverlayManager overlayManager = OverlayManagers.get((Component)component);
                if (this.fOverlay != null && overlayManager != null) {
                    overlayManager.removeOverlay(this.fOverlay);
                }
                if (this.fPreviousFocusOwner != null) {
                    this.fPreviousFocusOwner.requestFocusInWindow();
                }
                this.fPreviousFocusOwner = null;
                this.fOverlay = null;
            }
            this.fWindowPanel.setVisible(false);
        }
        this.fComponent.listVisibilityChanged(bl);
    }

    public void setName(String string) {
        this.fWindowName = string;
        this.fWindowPanel.setName(string);
    }

    public String getName() {
        return this.fWindowName;
    }

    public void addItem(EditablePopupListItem editablePopupListItem) {
        this.addItemAt(editablePopupListItem, this.fItems.size());
    }

    public void addItemAt(EditablePopupListItem editablePopupListItem, int n) {
        if (n < 0 || n >= this.fItems.size()) {
            this.fItems.add(editablePopupListItem);
        } else {
            this.fItems.add(n, editablePopupListItem);
        }
        this.updatePanel();
        editablePopupListItem.addSelectionListener(new EditablePopupListItem.EditablePopupListItemSelectionListener(){

            @Override
            public void selectionChanged(EditablePopupListItem editablePopupListItem) {
                if (!EditablePopupList.this.fAdjustingSelection) {
                    EditablePopupList.this.fAdjustingSelection = true;
                    if (editablePopupListItem.getType() == EditablePopupListItem.ITEM_TYPE.RADIOBUTTON && editablePopupListItem.isSelected()) {
                        String string = EditablePopupList.this.getRadioButtonGroup(editablePopupListItem);
                        if (string != null) {
                            ArrayList arrayList = (ArrayList)EditablePopupList.this.fRadioButtonGroups.get(string);
                            for (int i = 0; i < arrayList.size(); ++i) {
                                if (((EditablePopupListItem)((Object)arrayList.get(i))).equals((Object)editablePopupListItem) || !((EditablePopupListItem)((Object)arrayList.get(i))).isSelected()) continue;
                                ((EditablePopupListItem)((Object)arrayList.get(i))).setSelected(false);
                                EditablePopupList.this.fireSelectionChangedEvent((EditablePopupListItem)((Object)arrayList.get(i)));
                            }
                        }
                        editablePopupListItem.setSelected(true);
                    }
                    EditablePopupList.this.fAdjustingSelection = false;
                    if (EditablePopupList.this.fActionTTListener != null) {
                        EditablePopupList.this.fActionTTListener.hideActionToolTip();
                    }
                    EditablePopupList.this.fireSelectionChangedEvent(editablePopupListItem);
                }
            }

            @Override
            public void temporarySelectionChanged(EditablePopupListItem editablePopupListItem) {
                if (!EditablePopupList.this.fAdjustingSelection) {
                    EditablePopupList.this.fAdjustingSelection = true;
                    if (editablePopupListItem.isTemporarilySelected()) {
                        EditablePopupList.this.resetTemporarySelections(editablePopupListItem);
                    }
                    EditablePopupList.this.fireTemporarySelectionChangedEvent(editablePopupListItem);
                    EditablePopupList.this.fAdjustingSelection = false;
                }
            }
        });
        editablePopupListItem.addNameListener(new EditablePopupListItem.EditablePopupListItemNameListener(){

            @Override
            public void nameChanged(EditablePopupListItem editablePopupListItem, String string, String string2) {
                if (!string.equals(string2)) {
                    EditablePopupList.this.fireItemNameModifiedEvent(editablePopupListItem, string);
                }
            }
        });
        editablePopupListItem.addDescriptionListener(new EditablePopupListItem.EditablePopupListItemDescriptionListener(){

            @Override
            public void descriptionChanged(EditablePopupListItem editablePopupListItem, String string, String string2) {
                if (!string.equals(string2)) {
                    EditablePopupList.this.fireItemDescriptionModifiedEvent(editablePopupListItem, string);
                }
            }
        });
        if (editablePopupListItem.getType() == EditablePopupListItem.ITEM_TYPE.RADIOBUTTON) {
            this.setRadioButtonGroup(editablePopupListItem, "--DEFAULT--");
        }
        editablePopupListItem.addFocusListener(this);
        this.fireItemAddedEvent(editablePopupListItem);
    }

    public void removeItem(EditablePopupListItem editablePopupListItem) {
        this.fItems.remove((Object)editablePopupListItem);
        editablePopupListItem.removeFocusListener(this);
        EditablePopupListItem[] editablePopupListItemArray = this.getSelectedItems();
        if (editablePopupListItemArray != null) {
            for (int i = 0; i < editablePopupListItemArray.length; ++i) {
                if (!editablePopupListItemArray[i].equals((Object)editablePopupListItem)) continue;
                editablePopupListItem.setSelected(false);
            }
        }
        this.updatePanel();
        this.removeButtonFromOtherGroups(editablePopupListItem);
        this.fireItemRemovedEvent(editablePopupListItem);
    }

    public void removeItemAt(int n) {
        EditablePopupListItem editablePopupListItem = this.fItems.get(n);
        this.removeItem(editablePopupListItem);
    }

    public int getItemCount() {
        return this.fItems.size();
    }

    public void removeAllItems() {
        List<EditablePopupListItem> list = this.getItems();
        for (int i = 0; i < list.size(); ++i) {
            this.removeItem(list.get(i));
        }
    }

    public List<EditablePopupListItem> getItems() {
        return this.fItems;
    }

    public EditablePopupListItem getItemAt(int n) {
        return this.fItems.get(n);
    }

    private void updatePanel() {
        this.fPanel.removeAll();
        int n = 0;
        for (EditablePopupListItem editablePopupListItem : this.fItems) {
            if (!editablePopupListItem.isVisible()) continue;
            this.fPanel.add((Component)((Object)editablePopupListItem), (Object)new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
            ++n;
        }
        this.calculateWindowHeight();
        this.fPanel.validate();
        this.fScrollPane.validate();
        this.fWindowPanel.validate();
        if (this.fOverlay != null) {
            EditablePopupListItem editablePopupListItem;
            Component component = this.fComponent.getComponent();
            editablePopupListItem = OverlayManagers.get((Component)component);
            editablePopupListItem.packOverlay(this.fOverlay);
        }
    }

    public void revalidate() {
        this.updatePanel();
    }

    private Dimension calculateWindowHeight() {
        int n = 4;
        int n2 = -1;
        int n3 = 0;
        for (int i = 0; i < this.fItems.size(); ++i) {
            EditablePopupListItem editablePopupListItem = this.fItems.get(i);
            if (!editablePopupListItem.isVisible()) continue;
            Dimension dimension = editablePopupListItem.getPreferredSize();
            dimension.width = (int)((double)dimension.width + 2.0 * this.fScrollPane.getVerticalScrollBar().getPreferredSize().getWidth());
            if (dimension.width > n2) {
                n2 = dimension.width;
            }
            if (n3 < this.fMaxWindowHeight) {
                n3 += dimension.height;
                continue;
            }
            n3 = this.fMaxWindowHeight;
        }
        Dimension dimension = new Dimension(n2, n3 + n);
        this.fWindowPanel.setSize(dimension);
        this.fWindowPanel.setPreferredSize(dimension);
        return dimension;
    }

    public void setRadioButtonGroup(EditablePopupListItem editablePopupListItem, String string) {
        if (editablePopupListItem.getType() != EditablePopupListItem.ITEM_TYPE.RADIOBUTTON) {
            return;
        }
        this.removeButtonFromOtherGroups(editablePopupListItem);
        if (string != null) {
            ArrayList<EditablePopupListItem> arrayList = new ArrayList<EditablePopupListItem>();
            if (this.fRadioButtonGroups.containsKey(string)) {
                arrayList = this.fRadioButtonGroups.get(string);
                this.fRadioButtonGroups.remove(string);
            }
            arrayList.add(editablePopupListItem);
            this.fRadioButtonGroups.put(string, arrayList);
        }
    }

    private void removeButtonFromOtherGroups(EditablePopupListItem editablePopupListItem) {
        int n;
        if (this.fRadioButtonGroups.keySet() == null || this.fRadioButtonGroups.keySet().size() <= 0) {
            return;
        }
        String[] stringArray = new String[this.fRadioButtonGroups.keySet().size()];
        for (n = 0; n < this.fRadioButtonGroups.keySet().size(); ++n) {
            stringArray[n] = this.fRadioButtonGroups.keySet().iterator().next();
        }
        for (n = 0; n < stringArray.length; ++n) {
            ArrayList<EditablePopupListItem> arrayList = this.fRadioButtonGroups.get(stringArray[n]);
            if (arrayList == null || !arrayList.contains((Object)editablePopupListItem)) continue;
            arrayList.remove((Object)editablePopupListItem);
            this.fRadioButtonGroups.remove(stringArray[n]);
            if (arrayList.size() <= 0) continue;
            this.fRadioButtonGroups.put(stringArray[n], arrayList);
        }
    }

    public String getRadioButtonGroup(EditablePopupListItem editablePopupListItem) {
        if (this.fRadioButtonGroups.keySet() == null || this.fRadioButtonGroups.keySet().size() <= 0) {
            return null;
        }
        for (String string : this.fRadioButtonGroups.keySet()) {
            ArrayList<EditablePopupListItem> arrayList = this.fRadioButtonGroups.get(string);
            if (!arrayList.contains((Object)editablePopupListItem)) continue;
            return string;
        }
        return "--DEFAULT--";
    }

    public EditablePopupListItem[] getSelectedItems() {
        ArrayList<EditablePopupListItem> arrayList = new ArrayList<EditablePopupListItem>();
        for (int i = 0; i < this.fItems.size(); ++i) {
            if (!this.fItems.get(i).isSelected()) continue;
            arrayList.add(this.fItems.get(i));
        }
        EditablePopupListItem[] editablePopupListItemArray = new EditablePopupListItem[arrayList.size()];
        for (int i = 0; i < editablePopupListItemArray.length; ++i) {
            editablePopupListItemArray[i] = (EditablePopupListItem)((Object)arrayList.get(i));
        }
        return editablePopupListItemArray;
    }

    public boolean getCloseOnFocusLost() {
        return this.fCloseOnFocusLost;
    }

    public void setCloseOnFocusLost(boolean bl) {
        this.fCloseOnFocusLost = bl;
    }

    public boolean isVisible() {
        Component component = this.fComponent.getComponent();
        return this.fWindowPanel.isVisible();
    }

    public void requestFocus() {
        if (this.fWindowPanel != null) {
            this.fWindowPanel.requestFocus();
        }
    }

    public void requestFocusInWindow() {
        if (this.fWindowPanel != null) {
            this.fWindowPanel.requestFocusInWindow();
        }
    }

    private void resetTemporarySelections(EditablePopupListItem editablePopupListItem) {
        for (int i = 0; i < this.fItems.size(); ++i) {
            if (editablePopupListItem == this.fItems.get(i) || !this.fItems.get(i).isTemporarilySelected()) continue;
            this.fItems.get(i).setTemporarilySelected(false);
            this.fireTemporarySelectionChangedEvent(this.fItems.get(i));
        }
    }

    public boolean containsScreenPoint(Point point) {
        Component component = this.fComponent.getComponent();
        Rectangle rectangle = this.fWindowPanel.getBounds();
        if (!this.fWindowPanel.isVisible()) {
            return false;
        }
        rectangle.x = this.fWindowPanel.getLocationOnScreen().x;
        rectangle.y = this.fWindowPanel.getLocationOnScreen().y;
        return rectangle.contains(point);
    }

    private void checkForFocus(FocusEvent focusEvent) {
        if (this.fCloseOnFocusLost) {
            if (focusEvent.getComponent() == null || SwingUtilities.getRoot(focusEvent.getComponent()) == this.fWindowPanel) {
                return;
            }
            if (this.isVisible() && this.fCloseOnFocusLost) {
                this.hideMenu();
            }
        }
    }

    void setWaitCursorEnabled(boolean bl) {
        for (int i = 0; i < this.fItems.size(); ++i) {
            this.fItems.get(i).setWaitCursorEnabled(bl);
        }
    }

    private void fireSelectionChangedEvent(EditablePopupListItem editablePopupListItem) {
        for (int i = 0; i < this.fSelectionListeners.size(); ++i) {
            this.fSelectionListeners.get(i).selectionChanged(this, editablePopupListItem);
        }
    }

    private void fireTemporarySelectionChangedEvent(EditablePopupListItem editablePopupListItem) {
        for (int i = 0; i < this.fSelectionListeners.size(); ++i) {
            this.fSelectionListeners.get(i).temporarySelectionChanged(this, editablePopupListItem);
        }
    }

    private void fireItemAddedEvent(EditablePopupListItem editablePopupListItem) {
        for (int i = 0; i < this.fItemListeners.size(); ++i) {
            this.fItemListeners.get(i).itemAdded(this, editablePopupListItem);
        }
    }

    private void fireItemRemovedEvent(EditablePopupListItem editablePopupListItem) {
        for (int i = 0; i < this.fItemListeners.size(); ++i) {
            this.fItemListeners.get(i).itemRemoved(this, editablePopupListItem);
        }
    }

    private void fireItemNameModifiedEvent(EditablePopupListItem editablePopupListItem, String string) {
        for (int i = 0; i < this.fItemListeners.size(); ++i) {
            this.fItemListeners.get(i).itemNameModified(this, editablePopupListItem, string);
        }
    }

    private void fireItemDescriptionModifiedEvent(EditablePopupListItem editablePopupListItem, String string) {
        for (int i = 0; i < this.fItemListeners.size(); ++i) {
            this.fItemListeners.get(i).itemDescriptionModified(this, editablePopupListItem, string);
        }
    }

    public void addSelectionListener(EditablePopupListSelectionListener editablePopupListSelectionListener) {
        this.fSelectionListeners.add(editablePopupListSelectionListener);
    }

    public void removeSelectionListener(EditablePopupListSelectionListener editablePopupListSelectionListener) {
        this.fSelectionListeners.remove(editablePopupListSelectionListener);
    }

    public void addItemListener(EditablePopupListItemListener editablePopupListItemListener) {
        this.fItemListeners.add(editablePopupListItemListener);
    }

    public void removeItemListener(EditablePopupListItemListener editablePopupListItemListener) {
        this.fItemListeners.remove(editablePopupListItemListener);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.checkForFocus(focusEvent);
    }

    @Override
    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    @Override
    public void windowLostFocus(WindowEvent windowEvent) {
        if (this.fCloseOnFocusLost) {
            if (windowEvent.getOppositeWindow() == null || SwingUtilities.isDescendingFrom(windowEvent.getComponent(), this.fWindowPanel)) {
                return;
            }
            if (this.isVisible() && this.fCloseOnFocusLost) {
                this.hideMenu();
            }
        }
    }

    public ListMouseFocusLostListener getListMouseFocusLostListener() {
        return this.fListMouseFocusLostListener;
    }

    public ListKeyboardListener getListKeyboardListener() {
        return this.fListKeyboardListener;
    }

    public void setTooltipComponents(ActionToolTip actionToolTip, CustomActionTooltipListener customActionTooltipListener) {
        this.fActionTip = actionToolTip;
        this.fActionTTListener = customActionTooltipListener;
    }

    public static interface EditablePopupListComponent {
        public JFrame getRootFrame();

        public Component getComponent();

        public Rectangle getComponentScreenBounds();

        public void listVisibilityChanged(boolean var1);
    }

    public class ListKeyboardListener
    implements AWTEventListener {
        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            try {
                KeyEvent keyEvent = (KeyEvent)aWTEvent;
                if (EditablePopupList.this.isVisible() && keyEvent.getID() == 401) {
                    int n = -1;
                    int n2 = -1;
                    for (int i = 0; i < EditablePopupList.this.fItems.size(); ++i) {
                        if (!((EditablePopupListItem)((Object)EditablePopupList.this.fItems.get(i))).isTemporarilySelected()) continue;
                        ((EditablePopupListItem)((Object)EditablePopupList.this.fItems.get(i))).setTemporarilySelected(false);
                        n = i;
                    }
                    n2 = n;
                    if (keyEvent.getKeyCode() == 38) {
                        while (--n2 >= 0 && (((EditablePopupListItem)((Object)EditablePopupList.this.fItems.get(n2))).getType() == EditablePopupListItem.ITEM_TYPE.HEADER || ((EditablePopupListItem)((Object)EditablePopupList.this.fItems.get(n2))).getType() == EditablePopupListItem.ITEM_TYPE.LINE_HEADER)) {
                        }
                        if (n2 == -1) {
                            n2 = n;
                        }
                    } else if (keyEvent.getKeyCode() == 40) {
                        while (++n2 < EditablePopupList.this.fItems.size() && (((EditablePopupListItem)((Object)EditablePopupList.this.fItems.get(n2))).getType() == EditablePopupListItem.ITEM_TYPE.HEADER || ((EditablePopupListItem)((Object)EditablePopupList.this.fItems.get(n2))).getType() == EditablePopupListItem.ITEM_TYPE.LINE_HEADER)) {
                        }
                        if (n2 == EditablePopupList.this.fItems.size()) {
                            n2 = n;
                        }
                    } else if (keyEvent.getKeyCode() == 10 && EditablePopupList.this.fWindowPanel != null && EditablePopupList.this.fWindowPanel.hasFocus()) {
                        ((EditablePopupListItem)((Object)EditablePopupList.this.fItems.get(n))).setSelected(true);
                        ((EditablePopupListItem)((Object)EditablePopupList.this.fItems.get(n))).setTemporarilySelected(false);
                    } else if (keyEvent.getKeyCode() == 27 && EditablePopupList.this.fWindowPanel != null && EditablePopupList.this.fWindowPanel.hasFocus()) {
                        EditablePopupList.this.hideMenu();
                    }
                    if ((keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) && n2 >= 0 && n2 < EditablePopupList.this.fItems.size()) {
                        ((EditablePopupListItem)((Object)EditablePopupList.this.fItems.get(n2))).setTemporarilySelected(true);
                        Rectangle rectangle = ((EditablePopupListItem)((Object)EditablePopupList.this.fItems.get(n2))).getBounds();
                        EditablePopupList.this.fPanel.scrollRectToVisible(rectangle);
                        if (EditablePopupList.this.fWindowPanel != null) {
                            EditablePopupList.this.fWindowPanel.repaint();
                        }
                    }
                }
            }
            catch (Exception exception) {
                Log.logException((Exception)exception);
            }
        }
    }

    public class ListMouseFocusLostListener
    implements AWTEventListener {
        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            try {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                if (EditablePopupList.this.isVisible() && mouseEvent.getClickCount() > 0 && mouseEvent.getID() == 501) {
                    Component component = EditablePopupList.this.fComponent.getComponent();
                    Point point = mouseEvent.getLocationOnScreen();
                    Rectangle rectangle = EditablePopupList.this.fWindowPanel.getBounds();
                    Point point2 = EditablePopupList.this.fWindowPanel.getLocationOnScreen();
                    rectangle.x = point2.x;
                    rectangle.y = point2.y;
                    Rectangle rectangle2 = EditablePopupList.this.fComponent.getComponentScreenBounds();
                    if (!rectangle.contains(point) && !rectangle2.contains(point)) {
                        if (this.isMouseWithinActionTT(point)) {
                            return;
                        }
                        if (EditablePopupList.this.isVisible() && EditablePopupList.this.fCloseOnFocusLost) {
                            EditablePopupList.this.hideMenu();
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private boolean isMouseWithinActionTT(Point point) {
            boolean bl = false;
            if (EditablePopupList.this.fActionTip != null) {
                Rectangle rectangle = null;
                Point point2 = null;
                if (EditablePopupList.this.fActionTip.getBalloon() != null) {
                    rectangle = EditablePopupList.this.fActionTip.getBalloon().getBounds();
                    point2 = EditablePopupList.this.fActionTip.getBalloon().getLocationOnScreen();
                } else if (EditablePopupList.this.fActionTip.getDialog() != null && EditablePopupList.this.fActionTip.getDialog().isVisible()) {
                    rectangle = EditablePopupList.this.fActionTip.getDialog().getBounds();
                    point2 = EditablePopupList.this.fActionTip.getDialog().getLocationOnScreen();
                }
                if (rectangle != null) {
                    rectangle.width = CustomActionTooltipListener.ACTION_TOOLTIP_WIDTH;
                    rectangle.x = point2.x;
                    rectangle.y = point2.y;
                    if (rectangle.contains(point)) {
                        bl = true;
                    }
                }
            }
            return bl;
        }
    }

    public static interface EditablePopupListItemListener {
        public void itemAdded(EditablePopupList var1, EditablePopupListItem var2);

        public void itemRemoved(EditablePopupList var1, EditablePopupListItem var2);

        public void itemNameModified(EditablePopupList var1, EditablePopupListItem var2, String var3);

        public void itemDescriptionModified(EditablePopupList var1, EditablePopupListItem var2, String var3);
    }

    public static interface EditablePopupListSelectionListener {
        public void selectionChanged(EditablePopupList var1, EditablePopupListItem var2);

        public void temporarySelectionChanged(EditablePopupList var1, EditablePopupListItem var2);
    }
}

