/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector.guiutils;

import com.mathworks.mlwidgets.inspector.guiutils.IFader;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Action;
import javax.swing.Timer;

abstract class AbstractFader
implements IFader {
    private static volatile Method setWindowOpacity;
    private final Action onStopAction;
    private final Window win;
    private volatile Timer fadeTimer;
    private volatile float opacity;
    private final float opacityIncrement;
    private volatile boolean ranOnce;
    private final ActionListener timerListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractFader.this.opacity += AbstractFader.this.opacityIncrement;
            if (AbstractFader.this.opacity < 0.0f || AbstractFader.this.opacity > 1.0f) {
                if (AbstractFader.this.opacity < 0.0f) {
                    AbstractFader.this.opacity = 0.0f;
                } else if (AbstractFader.this.opacity > 1.0f) {
                    AbstractFader.this.opacity = 1.0f;
                }
                AbstractFader.this.fadeTimer.stop();
                AbstractFader.this.fadeTimer = null;
                if (AbstractFader.this.onStopAction != null) {
                    AbstractFader.this.onStopAction.actionPerformed(null);
                }
                AbstractFader.this.win.removeWindowListener(AbstractFader.this.winAdapter);
                AbstractFader.this.ranOnce = true;
            }
            AbstractFader.setWindowOpacityImpl(AbstractFader.this.win, AbstractFader.this.opacity);
        }
    };
    private final WindowAdapter winAdapter = new WindowAdapter(){

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            AbstractFader.this.start();
        }
    };

    public static boolean isTranslucencySupported() {
        return TranslucencyFieldHolder.isTranslucencySupported;
    }

    AbstractFader(Window window, Action action) {
        if (window == null) {
            throw new IllegalArgumentException("Argument win must not be null");
        }
        this.win = window;
        this.onStopAction = action;
        this.opacity = 1.0f;
        this.opacityIncrement = -0.03f;
    }

    AbstractFader(Window window) {
        if (window == null) {
            throw new IllegalArgumentException("Argument win must not be null");
        }
        this.win = window;
        this.onStopAction = null;
        this.opacity = 0.0f;
        this.opacityIncrement = 0.03f;
        window.addWindowListener(this.winAdapter);
        AbstractFader.setWindowOpacityImpl(window, 0.0f);
    }

    @Override
    public void start() {
        if (this.ranOnce) {
            throw new IllegalStateException("Fader can only be run once for a given instance");
        }
        this.fadeTimer = new Timer(25, this.timerListener);
        this.fadeTimer.setInitialDelay(0);
        this.fadeTimer.start();
    }

    private static void setWindowOpacityImpl(Window window, float f) {
        assert (setWindowOpacity != null);
        try {
            setWindowOpacity.invoke(null, window, Float.valueOf(f));
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private static boolean isTranslucencySupportedImpl() {
        try {
            Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
            setWindowOpacity = clazz.getMethod("setWindowOpacity", Window.class, Float.TYPE);
            Class<?> clazz2 = Class.forName("com.sun.awt.AWTUtilities$Translucency");
            Field field = clazz2.getField("TRANSLUCENT");
            Method method = clazz.getMethod("isTranslucencySupported", clazz2);
            Object object = method.invoke(null, field.get(null));
            assert (object != null);
            return (Boolean)object;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        catch (SecurityException securityException) {
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
    }

    static /* synthetic */ boolean access$800() {
        return AbstractFader.isTranslucencySupportedImpl();
    }

    private static class TranslucencyFieldHolder {
        static final boolean isTranslucencySupported = AbstractFader.access$800();

        private TranslucencyFieldHolder() {
        }
    }

    static final class OutFader
    extends AbstractFader {
        OutFader(Window window, Action action) {
            super(window, action);
        }
    }

    static final class InFader
    extends AbstractFader {
        InFader(Window window) {
            super(window);
        }
    }
}

