/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.mlservices.scc;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.fl.i18n.XMLMessageSystem;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.services.Prefs;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ResourceBundle;

public class SccPrefsPanel
extends MJPanel {
    private static final ResourceBundle sResources = ResourceBundle.getBundle("com.mathworks.mlwidgets.mlservices.scc.resources.RES_MWSCC");
    private static MJPanel sPrefsPanel;
    private static MJComboBox sSourceControlChoice;
    private static String CLEARCASE;
    private static String CHANGEMAN;
    private static String RCS;
    private static String CVS;
    private static final ResourceBundle myBundle;
    private static String sDefaultSystem;
    private static String[] sInternalUnixChoices;

    public static MJPanel createPrefsPanel() {
        Object object;
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        }
        sSourceControlChoice = new MJComboBox();
        sSourceControlChoice.setName("SourceControlCombo");
        sPrefsPanel = new SccPrefsPanel();
        sPrefsPanel.setLayout((LayoutManager)new FormLayout("p,3dlu,p:grow", "p"));
        if (PlatformInfo.isWindows()) {
            new MatlabWorker(){

                public Object runOnMatlabThread() throws Exception {
                    try {
                        return Matlab.mtFeval((String)"verctrl", (Object[])new Object[]{"all_systems"}, (int)1);
                    }
                    catch (Exception exception) {
                        Log.log((String)exception.getMessage());
                        return null;
                    }
                }

                public void runOnAWTEventDispatchThread(Object object) {
                    if (object == null) {
                        sSourceControlChoice.addItem((Object)sDefaultSystem);
                        sSourceControlChoice.setSelectedItem((Object)sDefaultSystem);
                    } else {
                        Object[] objectArray = (Object[])object;
                        for (int i = 0; i < objectArray.length; ++i) {
                            sSourceControlChoice.addItem(objectArray[i]);
                        }
                        sSourceControlChoice.addItem((Object)sDefaultSystem);
                        SccPrefsPanel.setSelectionForWindows();
                    }
                }
            }.start();
        } else {
            sSourceControlChoice.addItem((Object)sDefaultSystem);
            sSourceControlChoice.addItem((Object)CLEARCASE);
            sSourceControlChoice.addItem((Object)CVS);
            sSourceControlChoice.addItem((Object)CHANGEMAN);
            sSourceControlChoice.addItem((Object)RCS);
            sSourceControlChoice.addItem((Object)sResources.getString("prefs.customsystem"));
            object = Prefs.getStringPref((String)"SourceControlSystem", (String)sDefaultSystem);
            sSourceControlChoice.setSelectedItem((Object)SccPrefsPanel.translateInternalToDisplayString((String)object));
        }
        object = new CellConstraints();
        MJLabel mJLabel = new MJLabel(sResources.getString("prefs.system.label"));
        mJLabel.setName("SourceControlLabel");
        sPrefsPanel.add((Component)mJLabel, (Object)object.xy(1, 1));
        sPrefsPanel.add((Component)sSourceControlChoice, (Object)object.xy(3, 1));
        return sPrefsPanel;
    }

    private static void setSelectionForWindows() {
        String string = Prefs.getStringPref((String)"SourceControlSystem", (String)sDefaultSystem);
        if (string.equals(sDefaultSystem)) {
            sSourceControlChoice.setSelectedItem((Object)sDefaultSystem);
        } else {
            sSourceControlChoice.setSelectedItem((Object)string);
            if (!sSourceControlChoice.getSelectedItem().equals(string)) {
                sSourceControlChoice.setSelectedItem((Object)sDefaultSystem);
            }
        }
    }

    public static String translateDisplayToInternalString(int n) {
        switch (n) {
            case 0: {
                return sInternalUnixChoices[0];
            }
            case 1: {
                return sInternalUnixChoices[1];
            }
            case 2: {
                return sInternalUnixChoices[2];
            }
            case 3: {
                return sInternalUnixChoices[3];
            }
            case 4: {
                return sInternalUnixChoices[4];
            }
            case 5: {
                return sInternalUnixChoices[5];
            }
        }
        return sInternalUnixChoices[0];
    }

    public static String[] returnUnixDisplayStrings() {
        return sInternalUnixChoices;
    }

    public static String returnDefaultSystem() {
        return sDefaultSystem;
    }

    public static String translateInternalToDisplayString(String string) {
        if (string.compareTo("none") == 0) {
            return sDefaultSystem;
        }
        if (string.compareTo("clearcase") == 0) {
            return CLEARCASE;
        }
        if (string.compareTo("pvcs") == 0) {
            return CHANGEMAN;
        }
        if (string.compareTo("rcs") == 0) {
            return RCS;
        }
        if (string.compareTo("customverctrl") == 0) {
            return sResources.getString("prefs.customsystem");
        }
        if (string.compareTo("cvs") == 0) {
            return CVS;
        }
        return sDefaultSystem;
    }

    public static void setSCCSystem() {
        String string = (String)sSourceControlChoice.getSelectedItem();
        if (string.equals(sDefaultSystem)) {
            SccPrefsPanel.setSCCDefault();
        } else if (PlatformInfo.isUnix()) {
            Prefs.setStringPref((String)"SourceControlSystem", (String)SccPrefsPanel.translateDisplayToInternalString(sSourceControlChoice.getSelectedIndex()));
        } else {
            Prefs.setStringPref((String)"SourceControlSystem", (String)string);
        }
    }

    public static void enableSourceControlChoice(boolean bl) {
        sSourceControlChoice.setEnabled(bl);
    }

    public static void setSCCDefault() {
        Prefs.setStringPref((String)"SourceControlSystem", (String)sDefaultSystem);
    }

    static {
        CLEARCASE = "IBM Rational ClearCase";
        CHANGEMAN = "ChangeMan (Serena)";
        RCS = "RCS";
        CVS = "CVS";
        myBundle = XMLMessageSystem.getBundle((String)"MATLAB:sourceControl");
        sDefaultSystem = myBundle.getString("none");
        sInternalUnixChoices = new String[]{sDefaultSystem, "clearcase", "cvs", "pvcs", "rcs", "customverctrl"};
    }
}

