/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.shortcuts;

import com.mathworks.common.icons.ApplicationIcon;
import com.mathworks.common.icons.IconEnumerationUtils;
import com.mathworks.common.icons.ShortcutIcon;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Image;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

class ShortcutIconUtils {
    private static Map<String, ImageIcon> sStandardIconMap;
    private static final ResourceBundle sRes;
    static final String GENERAL_ICON_NAME;
    static final String MATLAB_ICON_NAME;
    static final String HELP_ICON_NAME;
    static final String SIMULINK_ICON_NAME;
    private static String[] sStandardNames;

    private ShortcutIconUtils() {
    }

    static String[] getStandardIconNames() {
        return sStandardNames;
    }

    static ImageIcon getStandardIcon(String string) {
        return sStandardIconMap.get(string);
    }

    static ImageIcon getIcon(String string) {
        ImageIcon imageIcon = ShortcutIconUtils.getStandardIcon(string);
        if (imageIcon != null) {
            return imageIcon;
        }
        if (string != null && string.equals(sRes.getString("icon.Editor"))) {
            return ApplicationIcon.EDITOR.getIcon();
        }
        ImageIcon imageIcon2 = null;
        if (string != null) {
            imageIcon2 = new ImageIcon(string);
            if (imageIcon2.getImageLoadStatus() != 8 && ShortcutIconUtils.class.getResource(string) != null) {
                imageIcon2 = new ImageIcon(ShortcutIconUtils.class.getResource(string));
            }
            if (imageIcon2.getImageLoadStatus() == 8) {
                Image image = imageIcon2.getImage().getScaledInstance(16, 16, 1);
                imageIcon2 = new ImageIcon(image);
            }
            if (imageIcon2.getImageLoadStatus() != 8) {
                imageIcon2 = null;
            }
        }
        if (imageIcon2 == null) {
            imageIcon2 = sStandardIconMap.get(GENERAL_ICON_NAME);
        }
        return imageIcon2;
    }

    private static boolean usingToolstrip() {
        Desktop desktop = MatlabDesktopServices.getDesktop();
        return desktop == null ? false : desktop.useToolstrip();
    }

    static {
        sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.shortcuts.resources.RES_Shortcuts");
        GENERAL_ICON_NAME = sRes.getString("icon.General");
        MATLAB_ICON_NAME = sRes.getString("icon.Matlab");
        HELP_ICON_NAME = sRes.getString("icon.Help");
        SIMULINK_ICON_NAME = sRes.getString("icon.Simulink");
        sStandardNames = new String[]{GENERAL_ICON_NAME, MATLAB_ICON_NAME, HELP_ICON_NAME, SIMULINK_ICON_NAME};
        sStandardIconMap = new HashMap<String, ImageIcon>();
        if (!ShortcutIconUtils.usingToolstrip()) {
            sStandardIconMap.put(GENERAL_ICON_NAME, ShortcutIcon.SHORTCUT.getIcon());
            sStandardIconMap.put(MATLAB_ICON_NAME, ApplicationIcon.MATLAB.getIcon());
            sStandardIconMap.put(HELP_ICON_NAME, ShortcutIcon.HELP.getIcon());
            sStandardIconMap.put(SIMULINK_ICON_NAME, ApplicationIcon.SIMULINK.getIcon());
        } else {
            String string;
            char c;
            int n;
            sStandardIconMap.put(GENERAL_ICON_NAME, ShortcutIcon.SHORTCUT_16.getIcon());
            sStandardIconMap.put(MATLAB_ICON_NAME, ShortcutIcon.MATLAB_16.getIcon());
            sStandardIconMap.put(HELP_ICON_NAME, ShortcutIcon.HELP_16.getIcon());
            sStandardIconMap.put(SIMULINK_ICON_NAME, ShortcutIcon.SIMULINK_16.getIcon());
            int n2 = sStandardNames.length;
            String[] stringArray = new String[n2 + 62];
            System.arraycopy(sStandardNames, 0, stringArray, 0, n2);
            for (n = 0; n < 26; ++n) {
                c = (char)(65 + n);
                stringArray[n2 + n] = string = MessageFormat.format(sRes.getString("label.UpperCase"), Character.valueOf(c));
                sStandardIconMap.put(string, IconEnumerationUtils.getIcon((String)("shortcut_" + c + ".png")));
            }
            for (n = 0; n < 26; ++n) {
                c = (char)(97 + n);
                stringArray[n2 + 26 + n] = string = MessageFormat.format(sRes.getString("label.LowerCase"), Character.valueOf(c));
                sStandardIconMap.put(string, IconEnumerationUtils.getIcon((String)("shortcut_lower_" + c + ".png")));
            }
            for (n = 0; n < 10; ++n) {
                String string2;
                stringArray[n2 + 52 + n] = string2 = MessageFormat.format(sRes.getString("label.Number"), n);
                sStandardIconMap.put(string2, IconEnumerationUtils.getIcon((String)("shortcut_" + n + ".png")));
            }
            sStandardNames = stringArray;
        }
    }
}

