/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.util;

import com.mathworks.jmi.MatlabMCR;
import com.mathworks.mlwidgets.workspace.WorkspaceCommands;
import com.mathworks.mwswing.datatransfer.MJDataFlavor;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.StringUtils;
import com.mathworks.widgets.datatransfer.MLDataFlavor;
import com.mathworks.widgets.datatransfer.SimpleVariableDefinition;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;

public class MatlabDropTargetListener
implements DropTargetListener {
    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        boolean bl = dropTargetDragEvent.isDataFlavorSupported(MLDataFlavor.simpleVariableListFlavor);
        if (!bl && MJDataFlavor.isDecodableFileFlavor((DropTargetDragEvent)dropTargetDragEvent)) {
            if (PlatformInfo.isMacintosh()) {
                bl = true;
            } else {
                try {
                    bl = MatlabDropTargetListener.transferableContainsGenuineFile(dropTargetDragEvent.getTransferable());
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    bl = false;
                }
                catch (IOException iOException) {
                    bl = false;
                }
            }
        }
        if (bl) {
            dropTargetDragEvent.acceptDrag(1);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            if (MJDataFlavor.isDecodableFileFlavor((DropTargetDropEvent)dropTargetDropEvent)) {
                dropTargetDropEvent.acceptDrop(1);
                this.openFilesInTransferable(dropTargetDropEvent.getTransferable());
                dropTargetDropEvent.dropComplete(true);
                return;
            }
            if (dropTargetDropEvent.isDataFlavorSupported(MLDataFlavor.simpleVariableListFlavor)) {
                dropTargetDropEvent.acceptDrop(1);
                this.openVariablesInTransferable(dropTargetDropEvent.getTransferable());
                dropTargetDropEvent.dropComplete(true);
                return;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        dropTargetDropEvent.rejectDrop();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    private static boolean transferableContainsGenuineFile(Transferable transferable) throws UnsupportedFlavorException, IOException {
        File[] fileArray = MJDataFlavor.decodeJavaFileListFlavor((Transferable)transferable);
        if (fileArray.length == 0) {
            return true;
        }
        boolean bl = false;
        for (int i = 0; !bl && i < fileArray.length; ++i) {
            bl = !fileArray[i].isDirectory();
        }
        return bl;
    }

    private void openFilesInTransferable(Transferable transferable) throws UnsupportedFlavorException, IOException {
        File[] fileArray;
        for (File file : fileArray = MJDataFlavor.decodeJavaFileListFlavor((Transferable)transferable)) {
            if (file.getAbsolutePath().endsWith(".mat")) {
                WorkspaceCommands.importData(file);
                continue;
            }
            new MatlabMCR("Drop target listener").evalConsoleOutput("try, open('" + StringUtils.quoteSingleQuotes((String)file.getAbsolutePath()) + "'); end");
        }
    }

    private void openVariablesInTransferable(Transferable transferable) throws UnsupportedFlavorException, IOException {
        SimpleVariableDefinition[] simpleVariableDefinitionArray;
        for (SimpleVariableDefinition simpleVariableDefinition : simpleVariableDefinitionArray = MLDataFlavor.decodeSimpleVariableListFlavor((Transferable)transferable)) {
            new MatlabMCR("Drop target listener").evalNoOutput("openvar('" + simpleVariableDefinition.getVariable() + "', " + simpleVariableDefinition.getVariable() + ");");
        }
    }
}

