/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.workspace;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.mlwidgets.workspace.WorkspaceResources;
import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJFrame;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.filechooser.FileFilter;

public class ImportFileChooser {
    private static MJFileChooserPerPlatform sMJFCPP;
    private static ImportFileFilter sAllRecognizedTypes;
    private static ImportFileFilter[] sFilters;
    private static boolean sIsInitialized;

    private static void initialize() {
        String string = "";
        if (Matlab.isMatlabAvailable()) {
            string = MatlabPath.getCWD();
        }
        MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform(string);
        mJFileChooserPerPlatform.setDialogTitle(WorkspaceResources.getResource("dialog.import.title"));
        sMJFCPP = mJFileChooserPerPlatform;
        sIsInitialized = true;
    }

    public static void setupExtensionsForDropDown(String string, Object[] objectArray, Object[] objectArray2) {
        ArrayList arrayList = new ArrayList();
        if (objectArray2 != null && objectArray2.length > 0) {
            for (int i = 0; i < objectArray2.length - 1; ++i) {
                Collections.addAll(arrayList, (String[])objectArray2[i]);
            }
        }
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        sAllRecognizedTypes = new ImportFileFilter(string, stringArray, false);
        sFilters = ImportFileChooser.createImportFileFiltersForExtensions(objectArray, objectArray2);
        if (!sIsInitialized || sMJFCPP == null) {
            ImportFileChooser.initialize();
        }
        sMJFCPP.getChoosableFileFilterList().clear();
        sMJFCPP.addChoosableFileFilter((FilePatternFilter)sAllRecognizedTypes);
        for (ImportFileFilter importFileFilter : sFilters) {
            sMJFCPP.addChoosableFileFilter((FilePatternFilter)importFileFilter);
        }
    }

    private static ImportFileFilter[] createImportFileFiltersForExtensions(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null || objectArray2 == null) {
            return null;
        }
        ImportFileFilter[] importFileFilterArray = new ImportFileFilter[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            importFileFilterArray[i] = new ImportFileFilter((String)objectArray[i], (String[])objectArray2[i]);
        }
        return importFileFilterArray;
    }

    private static String extStringProcess(String[] stringArray) {
        String string = "";
        if (stringArray != null) {
            String string2 = ", ";
            for (int i = 0; i < stringArray.length; ++i) {
                if (i == stringArray.length - 1) {
                    string2 = "";
                }
                string = string.concat('\"' + stringArray[i] + '\"' + string2);
            }
        }
        return string;
    }

    private ImportFileChooser() {
    }

    public static void showImportFileDialog(Component component) {
        if (!sIsInitialized || sMJFCPP == null) {
            ImportFileChooser.initialize();
        } else {
            sMJFCPP.setCurrentDirectory(new File(MatlabPath.getCWD()));
            sMJFCPP.showOpenDialog((Component)MJFrame.getFrame((Component)component));
        }
    }

    public static File getSelectedFile() {
        if (!sIsInitialized || sMJFCPP == null) {
            ImportFileChooser.initialize();
        }
        return sMJFCPP.getSelectedFile();
    }

    public static int getState() {
        if (!sIsInitialized || sMJFCPP == null) {
            ImportFileChooser.initialize();
        }
        return sMJFCPP.getState();
    }

    static {
        sFilters = new ImportFileFilter[0];
        sIsInitialized = false;
    }

    private static class ImportFileFilter
    extends FileFilter
    implements FilePatternFilter {
        private String fDescription;
        private String[] fExtensions;
        private boolean fShow;

        private ImportFileFilter(String string, String[] stringArray) {
            this(string, stringArray, true);
        }

        private ImportFileFilter(String string, String[] stringArray, boolean bl) {
            this.fDescription = string;
            this.fExtensions = stringArray;
            this.fShow = bl;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            boolean bl = false;
            String string = file.getName();
            for (String string2 : this.fExtensions) {
                bl |= string.endsWith(string2);
            }
            return bl;
        }

        @Override
        public String getDescription() {
            String string;
            if (!this.fShow) {
                return this.fDescription;
            }
            if (this.fExtensions.length == 1) {
                string = '*' + this.fExtensions[0];
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < this.fExtensions.length; ++i) {
                    stringBuilder.append('*').append(this.fExtensions[i]);
                    if (i >= this.fExtensions.length - 1) continue;
                    stringBuilder.append(", ");
                }
                string = stringBuilder.toString();
            }
            return this.fDescription + " (" + string + ')';
        }

        public String[] getPatterns() {
            int n = this.fExtensions.length;
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = '*' + this.fExtensions[i];
            }
            return stringArray;
        }
    }
}

