/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.workspace;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.workspace.FetchedValueBuffer;
import com.mathworks.mlwidgets.workspace.MatlabWorkspaceListener;
import com.mathworks.mlwidgets.workspace.StatisticalFunction;
import com.mathworks.mlwidgets.workspace.ValueLookup;
import com.mathworks.mlwidgets.workspace.WhosInformation;
import com.mathworks.mlwidgets.workspace.WhosRecordlistModel;
import com.mathworks.mlwidgets.workspace.WorkspaceChange;
import com.mathworks.mlwidgets.workspace.WorkspaceCommands;
import com.mathworks.mlwidgets.workspace.WorkspaceObserver;
import com.mathworks.mlwidgets.workspace.WorkspacePrefs;
import com.mathworks.mlwidgets.workspace.WorkspaceResources;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.widgets.recordlist.ICreationObserver;
import com.mathworks.widgets.recordlist.IDeletionObserver;
import com.mathworks.widgets.recordlist.IDuplicationObserver;
import com.mathworks.widgets.recordlist.IEditingObserver;
import com.mathworks.widgets.recordlist.IOpeningObserver;
import com.mathworks.widgets.recordlist.IRecordCreator;
import com.mathworks.widgets.recordlist.IRecordDeleter;
import com.mathworks.widgets.recordlist.IRecordDuplicator;
import com.mathworks.widgets.recordlist.IRecordEditor;
import com.mathworks.widgets.recordlist.IRecordFieldCopier;
import com.mathworks.widgets.recordlist.IRecordOpener;
import com.mathworks.widgets.recordlist.IRecordQueryInformant;
import com.mathworks.widgets.recordlist.IRecordlistRefresher;
import com.mathworks.widgets.recordlist.IRestrictedSortRecordlist;
import java.text.MessageFormat;

public class MatlabWorkspaceModel
extends WhosRecordlistModel
implements IRecordFieldCopier,
IRecordCreator,
IRecordDeleter,
IRecordDuplicator,
IRecordOpener,
IRecordEditor,
IRestrictedSortRecordlist,
IRecordlistRefresher,
ValueLookup {
    private int fWorkspaceID;
    private int LAST_COLUMN_INDEX = this.STD();
    protected WorkspaceObserver fWSObserver;
    protected PrefListener fPrefListener;
    private FetchedValueBuffer[] fBufferedValueLists;
    private IRecordQueryInformant fQueryInformant = null;
    private static String sRenameErrorTitle = null;
    private static String sRenameErrorMain = null;
    private static String sRenameErrorAddendum = null;
    private boolean fListening = false;

    public int VALUE() {
        return 1;
    }

    @Override
    public int SIZE() {
        return super.SIZE() + 1;
    }

    @Override
    public int BYTES() {
        return super.BYTES() + 1;
    }

    @Override
    public int CLASS() {
        return super.CLASS() + 1;
    }

    public int MIN() {
        return this.CLASS() + 1;
    }

    public int MAX() {
        return this.CLASS() + 2;
    }

    public int RANGE() {
        return this.CLASS() + 3;
    }

    public int MEAN() {
        return this.CLASS() + 4;
    }

    public int MEDIAN() {
        return this.CLASS() + 5;
    }

    public int MODE() {
        return this.CLASS() + 6;
    }

    public int VAR() {
        return this.CLASS() + 7;
    }

    public int STD() {
        return this.CLASS() + 8;
    }

    public MatlabWorkspaceModel() {
        this(0);
    }

    public MatlabWorkspaceModel(int n) {
        this.fWorkspaceID = n;
        this.fQueryInformant = new RQI();
        this.fWSObserver = new MWMCompletionObserver();
        this.fPrefListener = (PrefListener)this.fWSObserver;
        this.initializeBufferedValueLists();
        this.registerInterests();
    }

    private void initializeBufferedValueLists() {
        this.fBufferedValueLists = new FetchedValueBuffer[this.LAST_COLUMN_INDEX + 1];
        for (int i = 0; i <= this.LAST_COLUMN_INDEX; ++i) {
            if (!this.isCalculatedField(i)) continue;
            StatisticalFunction statisticalFunction = this.getStatFunctionFromField(i);
            this.fBufferedValueLists[this.calculatedFieldToHashIndex((int)i)] = new FetchedValueBuffer(this, this, statisticalFunction);
        }
    }

    private boolean isCalculatedField(int n) {
        return n == this.VALUE() || this.isStatisticalField(n);
    }

    private boolean isStatisticalField(int n) {
        return n == this.MIN() || n == this.MAX() || n == this.RANGE() || n == this.MEAN() || n == this.MEDIAN() || n == this.MODE() || n == this.VAR() || n == this.STD();
    }

    public void setRecordQueryInformant(IRecordQueryInformant iRecordQueryInformant) {
        this.fQueryInformant = iRecordQueryInformant;
    }

    public void registerInterests() {
        if (Matlab.isMatlabAvailable() && !this.fListening) {
            this.fListening = true;
            MatlabWorkspaceListener.addWorkspaceChangeObserver(this.fWSObserver);
            Prefs.addListener((PrefListener)this.fPrefListener, (String)"GeneralNumFormat2");
            WorkspacePrefs.addUseNaNsForStatCalculationsListener(this.fPrefListener);
            WorkspacePrefs.addStatCalculationsNumelLimitListener(this.fPrefListener);
        }
    }

    public void unregisterInterests() {
        if (this.fListening) {
            this.fListening = false;
            MatlabWorkspaceListener.removeWorkspaceChangeObserver(this.fWSObserver);
            Prefs.removeListener((PrefListener)this.fPrefListener, (String)"GeneralNumFormat2");
            WorkspacePrefs.removeUseNaNsForStatCalculationsListener(this.fPrefListener);
            WorkspacePrefs.removeStatCalculationsNumelLimitListener(this.fPrefListener);
        }
    }

    @Override
    public Class getFieldClass(int n) {
        Class clazz = String.class;
        if (n != this.VALUE()) {
            clazz = super.getFieldClass(n);
        }
        return clazz;
    }

    @Override
    public int getFieldCount() {
        return this.LAST_COLUMN_INDEX + 1;
    }

    @Override
    public String getFieldName(int n) {
        if (n == this.VALUE()) {
            return WorkspaceResources.getBundle().getString("fieldname.value");
        }
        if (this.isStatisticalField(n)) {
            return this.getStatFunctionFromField(n).getDescription();
        }
        return super.getFieldName(n);
    }

    @Override
    public synchronized Object getValueAt(int n, int n2) {
        Object object = !this.isCalculatedField(n2) ? super.getValueAt(n, n2) : this.fBufferedValueLists[this.calculatedFieldToHashIndex(n2)].getValueAt(this.getValueAt(n, this.NAME()).toString(), this.fWorkspaceID, this.getValueAt(n, this.CLASS()).toString(), n2, this.fQueryInformant.getForthcomingRequestRegion(n));
        return object;
    }

    @Override
    public void lookupValue(String[] stringArray, int n, StatisticalFunction statisticalFunction, CompletionObserver completionObserver) {
        if (statisticalFunction == null) {
            MatlabWorkspaceModel.lookupValueInMatlab(stringArray, n, completionObserver);
        } else {
            MatlabWorkspaceModel.lookupStatInMatlab(stringArray, n, statisticalFunction, completionObserver);
        }
    }

    private static void lookupValueInMatlab(Object[] objectArray, int n, CompletionObserver completionObserver) {
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        WorkspaceCommands.getVariableShortObjects(stringArray, n, completionObserver);
    }

    private static void lookupStatInMatlab(Object[] objectArray, int n, StatisticalFunction statisticalFunction, CompletionObserver completionObserver) {
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        WorkspaceCommands.getVariableStatObjects(stringArray, n, statisticalFunction, completionObserver);
    }

    private StatisticalFunction getStatFunctionFromField(int n) {
        if (n == this.MIN()) {
            return StatisticalFunction.MIN;
        }
        if (n == this.MAX()) {
            return StatisticalFunction.MAX;
        }
        if (n == this.RANGE()) {
            return StatisticalFunction.RANGE;
        }
        if (n == this.MEAN()) {
            return StatisticalFunction.MEAN;
        }
        if (n == this.MEDIAN()) {
            return StatisticalFunction.MEDIAN;
        }
        if (n == this.MODE()) {
            return StatisticalFunction.MODE;
        }
        if (n == this.VAR()) {
            return StatisticalFunction.VAR;
        }
        if (n == this.STD()) {
            return StatisticalFunction.STD;
        }
        return null;
    }

    public boolean areRecordsDeletable(int[] nArray) {
        return nArray.length > 0;
    }

    public void deleteRecords(int[] nArray, IDeletionObserver iDeletionObserver) {
        int n = iDeletionObserver.deletionStarted(nArray);
        if (n == 0) {
            WorkspaceCommands.clearVariables(this.getVariableNamesFromIDs(nArray), false, null);
        }
        iDeletionObserver.deletionCompleted(n, WorkspaceResources.getBundle().getString("error.delete"));
    }

    public boolean areRecordsCreatable() {
        return true;
    }

    public void createRecord(ICreationObserver iCreationObserver) {
        int n = iCreationObserver.creationStarted();
        WorkspaceCommands.createVariable();
        iCreationObserver.creationCompleted(n, WorkspaceResources.getBundle().getString("error.create"));
    }

    public boolean areRecordsDuplicatable(int[] nArray) {
        return nArray.length > 0;
    }

    public void duplicateRecords(int[] nArray, IDuplicationObserver iDuplicationObserver) {
        int n = iDuplicationObserver.duplicationStarted(nArray);
        WorkspaceCommands.duplicateVariables(this.getVariableNamesFromIDs(nArray));
        iDuplicationObserver.duplicationCompleted(n, WorkspaceResources.getBundle().getString("error.duplicate"));
    }

    public boolean areRecordsOpenable(int[] nArray) {
        return nArray.length > 0;
    }

    public void openRecords(int[] nArray, IOpeningObserver iOpeningObserver) {
        int n = iOpeningObserver.openingStarted(nArray);
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = (String)this.getValueAt(nArray[i], this.NAME());
        }
        WorkspaceCommands.openVariables(stringArray);
        iOpeningObserver.openingCompleted(n, WorkspaceResources.getBundle().getString("error.open"));
    }

    public boolean areRecordsEditable(int[] nArray, int n) {
        return nArray.length > 0 && (n == 0 || n == 1);
    }

    public static String createVariableRenameErrorMessage(String string) {
        if (sRenameErrorMain == null) {
            sRenameErrorMain = WorkspaceResources.getBundle().getString("dialog.badname.pre.message");
        }
        if (sRenameErrorAddendum == null) {
            sRenameErrorAddendum = WorkspaceResources.getBundle().getString("dialog.badname.message.addendum");
        }
        return MessageFormat.format(sRenameErrorMain, string) + sRenameErrorAddendum;
    }

    public void setRecordValues(int[] nArray, int n, Object[] objectArray, IEditingObserver iEditingObserver) {
        Object object;
        String string;
        iEditingObserver.editingStarted(nArray);
        String[] stringArray = this.getVariableNamesFromIDs(nArray);
        if (n == this.NAME()) {
            if (sRenameErrorTitle == null) {
                sRenameErrorTitle = WorkspaceResources.getBundle().getString("dialog.badname.title");
                sRenameErrorMain = WorkspaceResources.getBundle().getString("dialog.badname.pre.message");
                sRenameErrorAddendum = WorkspaceResources.getBundle().getString("dialog.badname.message.addendum");
            }
            string = (String)objectArray[0];
            object = new RenameObserver(iEditingObserver, MatlabWorkspaceModel.createVariableRenameErrorMessage(string));
            WorkspaceCommands.renameVariable(stringArray[0], string, (CompletionObserver)object);
        }
        if (n == this.VALUE()) {
            string = stringArray[0];
            object = (String)objectArray[0];
            if (object != null && ((String)object).trim().length() != 0) {
                this.fBufferedValueLists[this.calculatedFieldToHashIndex(n)].putValueForSet(string, object);
            }
            WorkspaceVariable workspaceVariable = new WorkspaceVariable(string, this.fWorkspaceID);
            WorkspaceCommands.assignVariable(workspaceVariable, (String)object, (CompletionObserver)new ValueObserver(iEditingObserver, string));
        }
    }

    public String[] getEditingDescriptions() {
        return new String[]{WorkspaceResources.getBundle().getString("operation.rename"), WorkspaceResources.getBundle().getString("operation.edit")};
    }

    public int[] getEditableFields() {
        int[] nArray = new int[]{0, 1};
        return nArray;
    }

    private String[] getVariableNamesFromIDs(int[] nArray) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = (String)this.getValueAt(nArray[i], this.NAME());
        }
        return stringArray;
    }

    private void setSuperWhosInformation(WhosInformation whosInformation) {
        super.setWhosInformation(whosInformation);
    }

    @Override
    protected void setWhosInformation(final WhosInformation whosInformation) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                MatlabWorkspaceModel.this.setSuperWhosInformation(whosInformation);
                if (MatlabWorkspaceModel.this.getRecordCount() == 0) {
                    for (int i = 0; i <= MatlabWorkspaceModel.this.LAST_COLUMN_INDEX; ++i) {
                        if (!MatlabWorkspaceModel.this.isCalculatedField(i)) continue;
                        MatlabWorkspaceModel.this.fBufferedValueLists[MatlabWorkspaceModel.this.calculatedFieldToHashIndex(i)].cleanAllValues();
                    }
                } else {
                    for (int i = 0; i <= MatlabWorkspaceModel.this.LAST_COLUMN_INDEX; ++i) {
                        if (!MatlabWorkspaceModel.this.isCalculatedField(i)) continue;
                        MatlabWorkspaceModel.this.fBufferedValueLists[MatlabWorkspaceModel.this.calculatedFieldToHashIndex(i)].prepareForNewValues();
                    }
                }
            }
        });
    }

    public int[] getUnsortableFields() {
        int[] nArray = new int[]{this.VALUE(), this.MIN(), this.MAX(), this.RANGE(), this.MEAN(), this.MEDIAN(), this.MODE(), this.VAR(), this.STD()};
        return nArray;
    }

    public void refresh() {
        MatlabWorkspaceListener.reportWSChange();
    }

    private int calculatedFieldToHashIndex(int n) {
        if (n == this.VALUE()) {
            return 0;
        }
        if (this.isStatisticalField(n)) {
            return n - this.CLASS();
        }
        return -1;
    }

    private static class RQI
    implements IRecordQueryInformant {
        private static final int BUFFER_SIZE = 32;

        private RQI() {
        }

        public int[] getForthcomingRequestRegion(int n) {
            int[] nArray;
            nArray = new int[]{n / 32 * 32, nArray[0] + 32 - 1};
            return nArray;
        }
    }

    private class MWMCompletionObserver
    implements WorkspaceObserver,
    PrefListener {
        private MWMCompletionObserver() {
        }

        @Override
        public void workspaceUpdate(WorkspaceChange workspaceChange, WhosInformation whosInformation) {
            MatlabWorkspaceModel.this.setWhosInformation(whosInformation);
        }

        public void prefChanged(PrefEvent prefEvent) {
            MatlabWorkspaceModel.this.refresh();
        }
    }

    private static class RenameObserver
    implements CompletionObserver {
        private String fMessage;
        private IEditingObserver fObserver;

        RenameObserver(IEditingObserver iEditingObserver, String string) {
            this.fObserver = iEditingObserver;
            this.fMessage = string;
        }

        public void completed(int n, Object object) {
            int n2 = 0;
            if (Matlab.getExecutionStatus((int)n) != 0) {
                n2 = 2;
            }
            this.fObserver.editingCompleted(n2, this.fMessage);
        }
    }

    private class ValueObserver
    implements CompletionObserver {
        private IEditingObserver fObserver;
        private String fVarName;

        ValueObserver(IEditingObserver iEditingObserver, String string) {
            this.fObserver = iEditingObserver;
            this.fVarName = string;
        }

        public void completed(int n, Object object) {
            int n2 = Matlab.getExecutionStatus((int)n);
            int n3 = 0;
            String string = null;
            switch (n2) {
                case 0: {
                    n3 = 0;
                    break;
                }
                case 1: {
                    string = WorkspaceResources.getBundle().getString("error.reassign.syntax");
                    break;
                }
                case 2: {
                    string = WorkspaceResources.getBundle().getString("error.reassign.evaluation");
                    break;
                }
                default: {
                    string = WorkspaceResources.getBundle().getString("error.reassign.unknown");
                }
            }
            if (string != null) {
                n3 = 2;
                MatlabWorkspaceModel.this.fBufferedValueLists[MatlabWorkspaceModel.this.calculatedFieldToHashIndex(MatlabWorkspaceModel.this.VALUE())].backOutValue(this.fVarName);
            }
            this.fObserver.editingCompleted(n3, string);
        }
    }
}

