/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.workspace;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.workspace.WorkspaceCommands;
import com.mathworks.mlwidgets.workspace.WorkspaceResources;
import com.mathworks.mlwidgets.workspace.util.WorkspaceIcon;
import com.mathworks.mwswing.datatransfer.MJClipboard;
import com.mathworks.mwswing.datatransfer.MJTransferable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.datatransfer.MLDataFlavor;
import com.mathworks.widgets.datatransfer.SimpleVariableDefinition;
import com.mathworks.widgets.datatransfer.VariableIdentifier;
import com.mathworks.widgets.datatransfer.VariableLiteral;
import com.mathworks.widgets.recordlist.AbstractRecordlistModel;
import com.mathworks.widgets.recordlist.ICopyingObserver;
import com.mathworks.widgets.recordlist.IGenericNameSupplier;
import com.mathworks.widgets.recordlist.IRecordIconProvider;
import com.mathworks.widgets.recordlist.IVirtualRecordContainer;
import com.mathworks.widgets.spreadsheet.format.FormatIdentifier;
import com.mathworks.widgets.spreadsheet.format.Formatter;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.Icon;

public abstract class VariableRecordlistModel
extends AbstractRecordlistModel
implements IRecordIconProvider,
IGenericNameSupplier,
IVirtualRecordContainer {
    private String[] fFieldNames = new String[4];
    protected Object fSemaphore = new Object();
    protected static final Formatter sEditingFormatter = FormatIdentifier.getDefaultInstance().getEditorIdentifier().getFormatter();

    public int NAME() {
        return 0;
    }

    public int SIZE() {
        return 1;
    }

    public int BYTES() {
        return 2;
    }

    public int CLASS() {
        return 3;
    }

    protected VariableRecordlistModel() {
        ResourceBundle resourceBundle = WorkspaceResources.getBundle();
        this.fFieldNames[0] = resourceBundle.getString("fieldname.name");
        this.fFieldNames[1] = resourceBundle.getString("fieldname.size");
        this.fFieldNames[2] = resourceBundle.getString("fieldname.bytes");
        this.fFieldNames[3] = resourceBundle.getString("fieldname.class");
    }

    public Class getFieldClass(int n) {
        if (n == this.BYTES()) {
            return Long.class;
        }
        return String.class;
    }

    public int getFieldCount() {
        return 4;
    }

    public String getFieldName(int n) {
        if (n == this.NAME()) {
            return this.fFieldNames[0];
        }
        if (n == this.SIZE()) {
            return this.fFieldNames[1];
        }
        if (n == this.BYTES()) {
            return this.fFieldNames[2];
        }
        if (n == this.CLASS()) {
            return this.fFieldNames[3];
        }
        return "";
    }

    public int getPrimaryFieldIndex() {
        return this.NAME();
    }

    public Object getSemaphore() {
        return this.fSemaphore;
    }

    public int getPresortFieldIndex() {
        return this.NAME();
    }

    public int getPresortFieldOrder() {
        return 0;
    }

    public Icon getRecordIcon(int n) {
        String string = (String)this.getValueAt(n, this.CLASS());
        return WorkspaceIcon.getIcon(string);
    }

    public int getMaxIconHeight() {
        return WorkspaceIcon.getMaxIconHeight();
    }

    public String getGenericNameSingular() {
        return WorkspaceResources.getBundle().getString("variable.singular");
    }

    public String getGenericNamePlural() {
        return WorkspaceResources.getBundle().getString("variable.plural");
    }

    public boolean areRecordsCopyable(int[] nArray) {
        return nArray.length > 0;
    }

    public void copyRecords(int[] nArray, ICopyingObserver iCopyingObserver) {
        this.copyRecords(nArray, this.NAME(), iCopyingObserver);
    }

    public void copyRecords(int[] nArray, int n, final ICopyingObserver iCopyingObserver) {
        final int n2 = iCopyingObserver.copyingStarted(nArray);
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            String string = sEditingFormatter.format(this.getValueAt(nArray[i], n));
            stringArray[i] = string != null ? string.toString() : "";
        }
        SimpleVariableDefinition[] simpleVariableDefinitionArray = new SimpleVariableDefinition[nArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i + 1 < stringArray.length) {
                stringBuilder.append(", ");
            }
            simpleVariableDefinitionArray[i] = new SimpleVariableDefinition(new VariableIdentifier(stringArray[i], stringArray[i], 0), (VariableLiteral)new WorkspaceVariableLiteral(stringArray[i], stringArray[i]));
        }
        WorkspaceClipboardOwner workspaceClipboardOwner = new WorkspaceClipboardOwner();
        if (n == this.NAME()) {
            String string = stringBuilder.toString();
            Transferable[] transferableArray = new Transferable[3];
            transferableArray[0] = MLDataFlavor.encodeSerializedVariableListFlavor((SimpleVariableDefinition[])simpleVariableDefinitionArray);
            transferableArray[1] = new StringSelection(string);
            Transferable transferable = MJTransferable.getCombinedTransferable((Transferable[])transferableArray);
            if (!Matlab.isMatlabAvailable()) {
                return;
            }
            if (PlatformInfo.isXWindows()) {
                MJClipboard.getMJClipboard().setXSelectionContents(transferableArray[1].toString());
            }
            MJClipboard.getMJClipboard().setContents(transferable, transferable, (ClipboardOwner)workspaceClipboardOwner);
            WorkspaceCommands.SerializingMatlabWorker serializingMatlabWorker = new WorkspaceCommands.SerializingMatlabWorker(new Object[]{WorkspaceCommands.WhichCall.copyworkspacevariables, string.split(", "), string.split(", ")}){

                @Override
                public void runOnAWTEventDispatchThread(Object object) {
                    iCopyingObserver.copyingCompleted(n2, WorkspaceResources.getBundle().getString("error.copy"));
                }
            };
            serializingMatlabWorker.start();
        } else {
            if (PlatformInfo.isXWindows()) {
                MJClipboard.getMJClipboard().setXSelectionContents(stringBuilder.toString());
            }
            MJClipboard.getMJClipboard().setContents(stringBuilder.toString(), (ClipboardOwner)workspaceClipboardOwner);
        }
    }

    public boolean blockCalculation(int n) {
        return this.isUnassignedClass(n);
    }

    protected boolean isUnassignedClass(int n) {
        return ((String)this.getValueAt(n, this.CLASS())).startsWith("(unassigned)");
    }

    public static class WorkspaceVariableLiteral
    implements VariableLiteral {
        private String fMatlabLiteral;
        private String fExternalLiteral;

        public WorkspaceVariableLiteral(String string, String string2) {
            this.fMatlabLiteral = string;
            this.fExternalLiteral = string2;
        }

        public String getMatlabLiteral() {
            return this.fMatlabLiteral;
        }

        public String getExternalLiteral() {
            return this.fExternalLiteral;
        }
    }

    public static class WorkspaceClipboardOwner
    implements ClipboardOwner {
        @Override
        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
            try {
                if (clipboard.isDataFlavorAvailable(MLDataFlavor.serializedVariableListFlavor)) {
                    DataFlavor[] dataFlavorArray;
                    String string = "application/x-matlab-serialized-variable-list";
                    for (DataFlavor dataFlavor : dataFlavorArray = transferable.getTransferDataFlavors()) {
                        DataFlavor[] dataFlavorArray2;
                        if (!dataFlavor.isMimeTypeEqual(string)) continue;
                        StringBuilder stringBuilder = new StringBuilder();
                        for (DataFlavor dataFlavor2 : dataFlavorArray2 = clipboard.getAvailableDataFlavors()) {
                            SimpleVariableDefinition[] simpleVariableDefinitionArray;
                            if (!dataFlavor2.isMimeTypeEqual(string) || (simpleVariableDefinitionArray = MLDataFlavor.decodeSerializedVariableListFlavor((Transferable)clipboard.getContents(null))) == null) continue;
                            for (SimpleVariableDefinition simpleVariableDefinition : simpleVariableDefinitionArray) {
                                String string2 = simpleVariableDefinition.getVariable();
                                stringBuilder.append(string2);
                                stringBuilder.append(", ");
                            }
                        }
                        WorkspaceCommands.SerializingMatlabWorker.callSerializedWorker(new Object[]{WorkspaceCommands.WhichCall.clearstoredworkspacevariables, stringBuilder.toString().split(", ")});
                    }
                } else {
                    WorkspaceCommands.SerializingMatlabWorker.callSerializedWorker(new Object[]{WorkspaceCommands.WhichCall.clearstoredworkspacevariables});
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class SizeStringComparator
    implements Comparator<String> {
        @Override
        public int compare(String string, String string2) {
            if (string == null && string2 == null) {
                return 0;
            }
            if (string == null) {
                return -1;
            }
            if (string2 == null) {
                return 1;
            }
            try {
                String[] stringArray = string.split("x");
                String[] stringArray2 = string2.split("x");
                int n = stringArray.length < stringArray2.length ? stringArray.length : stringArray2.length;
                for (int i = 0; i < n; ++i) {
                    if (Integer.parseInt(stringArray[i]) < Integer.parseInt(stringArray2[i])) {
                        return -1;
                    }
                    if (Integer.parseInt(stringArray[i]) <= Integer.parseInt(stringArray2[i])) continue;
                    return 1;
                }
                if (stringArray.length < stringArray2.length) {
                    return -1;
                }
                if (stringArray2.length < stringArray.length) {
                    return 1;
                }
                return 0;
            }
            catch (Exception exception) {
                return Integer.signum(string.compareTo(string2));
            }
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof SizeStringComparator;
        }
    }
}

