/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.mjs.impl;

import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.client.core.http.HttpMethodName;
import com.mathworks.webservices.client.core.http.HttpRequest;
import com.mathworks.webservices.mjs.CloudMJSQueueAccess;
import com.mathworks.webservices.mjs.exception.QueueNotSpecifiedException;
import com.mathworks.webservices.mjs.exception.UuidNotSpecifiedException;
import com.mathworks.webservices.mjs.impl.BaseServiceImpl;
import com.mathworks.webservices.mjs.impl.CloudMJSClientImpl;
import com.mathworks.webservices.mjs.model.queue.CloudQueueMetadata;
import com.mathworks.webservices.mjs.model.queue.QueueAction;
import com.mathworks.webservices.mjs.model.request.CloudQueueDemoteRequest;
import com.mathworks.webservices.mjs.model.request.CloudQueueEnsureRequest;
import com.mathworks.webservices.mjs.model.request.CloudQueueJobRemoveRequest;
import com.mathworks.webservices.mjs.model.request.CloudQueueMetadataReadRequest;
import com.mathworks.webservices.mjs.model.request.CloudQueuePromoteRequest;
import com.mathworks.webservices.mjs.model.request.CloudQueueRemoveRequest;
import com.mathworks.webservices.mjs.model.response.CloudQueueDemoteResponse;
import com.mathworks.webservices.mjs.model.response.CloudQueueEnsureResponse;
import com.mathworks.webservices.mjs.model.response.CloudQueueJobRemoveResponse;
import com.mathworks.webservices.mjs.model.response.CloudQueueMetadataReadResponse;
import com.mathworks.webservices.mjs.model.response.CloudQueuePromoteResponse;
import com.mathworks.webservices.mjs.model.response.CloudQueueRemoveResponse;

public class CloudMJSQueueAccessImpl
extends BaseServiceImpl
implements CloudMJSQueueAccess {
    public CloudMJSQueueAccessImpl(CloudMJSClientImpl cloudMJSClient) {
        super(cloudMJSClient);
    }

    @Override
    public CloudQueueEnsureResponse ensure(CloudQueueEnsureRequest cloudQueueEnsureRequest) {
        this.basicValidation(cloudQueueEnsureRequest);
        if (this.isEmpty(cloudQueueEnsureRequest.getQueueUuid())) {
            throw new UuidNotSpecifiedException("Queue uuid cannot be null or empty");
        }
        HttpRequest req = this.createHttpRequest(HttpMethodName.PUT, "/v1/queue", cloudQueueEnsureRequest.getQueueUuid(), cloudQueueEnsureRequest);
        try {
            CloudQueueEnsureResponse response = (CloudQueueEnsureResponse)this.getCloudMJSClient().executeRequestNew(req).getResponsePayload();
            this.getCloudMJSClient().setQueueUuid(cloudQueueEnsureRequest.getQueueUuid());
            return response;
        }
        catch (MathWorksServiceException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
        catch (MathWorksClientException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
    }

    @Override
    public CloudQueuePromoteResponse promoteJob(CloudQueuePromoteRequest cloudQueuePromoteRequest) {
        this.basicValidation(cloudQueuePromoteRequest);
        if (this.isEmpty(this.getCloudMJSClient().getQueueUuid())) {
            throw new QueueNotSpecifiedException("Queue cannot be null or empty");
        }
        HttpRequest req = this.createHttpRequestWithQueueContext(HttpMethodName.PUT, "/v1/queue", this.getCloudMJSClient().getQueueUuid(), cloudQueuePromoteRequest);
        req.addParameter("jobUuid", cloudQueuePromoteRequest.getJobUuid());
        req.addParameter("action", QueueAction.PROMOTE_JOB.toString());
        try {
            return (CloudQueuePromoteResponse)this.getCloudMJSClient().executeRequestNew(req).getResponsePayload();
        }
        catch (MathWorksServiceException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
        catch (MathWorksClientException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
    }

    @Override
    public CloudQueueDemoteResponse demoteJob(CloudQueueDemoteRequest cloudQueueDemoteRequest) {
        this.basicValidation(cloudQueueDemoteRequest);
        if (this.isEmpty(this.getCloudMJSClient().getQueueUuid())) {
            throw new QueueNotSpecifiedException("Queue cannot be null or empty");
        }
        HttpRequest req = this.createHttpRequestWithQueueContext(HttpMethodName.PUT, "/v1/queue", this.getCloudMJSClient().getQueueUuid(), cloudQueueDemoteRequest);
        req.addParameter("jobUuid", cloudQueueDemoteRequest.getJobUuid());
        req.addParameter("action", QueueAction.DEMOTE_JOB.toString());
        try {
            return (CloudQueueDemoteResponse)this.getCloudMJSClient().executeRequestNew(req).getResponsePayload();
        }
        catch (MathWorksServiceException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
        catch (MathWorksClientException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
    }

    @Override
    public CloudQueueJobRemoveResponse removeJob(CloudQueueJobRemoveRequest cloudQueueJobRemoveRequest) {
        this.basicValidation(cloudQueueJobRemoveRequest);
        if (this.isEmpty(this.getCloudMJSClient().getQueueUuid())) {
            throw new QueueNotSpecifiedException("Queue cannot be null or empty");
        }
        HttpRequest req = this.createHttpRequestWithQueueContext(HttpMethodName.PUT, "/v1/queue", this.getCloudMJSClient().getQueueUuid(), cloudQueueJobRemoveRequest);
        req.addParameter("jobUuid", cloudQueueJobRemoveRequest.getJobUuid());
        req.addParameter("action", QueueAction.REMOVE_JOB.toString());
        try {
            return (CloudQueueJobRemoveResponse)this.getCloudMJSClient().executeRequestNew(req).getResponsePayload();
        }
        catch (MathWorksServiceException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
        catch (MathWorksClientException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
    }

    @Override
    public CloudQueueMetadataReadResponse metadataRead(CloudQueueMetadataReadRequest cloudQueueMetadataReadRequest) {
        this.basicValidation(cloudQueueMetadataReadRequest);
        HttpRequest req = this.createHttpRequest(HttpMethodName.GET, "/v1/queue", null, cloudQueueMetadataReadRequest);
        try {
            return (CloudQueueMetadataReadResponse)this.getCloudMJSClient().executeRequestNew(req).getResponsePayload();
        }
        catch (MathWorksServiceException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
        catch (MathWorksClientException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
    }

    @Override
    public CloudQueueRemoveResponse remove(CloudQueueRemoveRequest cloudQueueRemoveRequest) {
        this.basicValidation(cloudQueueRemoveRequest);
        HttpRequest request = this.createHttpRequest(HttpMethodName.DELETE, "/v1/queue", null, cloudQueueRemoveRequest);
        this.addRequestMetadataCriteria(request, cloudQueueRemoveRequest.getCloudQueueMetadata());
        if (cloudQueueRemoveRequest.getAllowRemoveAll() != null) {
            request.addParameter("allowRemoveAll", cloudQueueRemoveRequest.getAllowRemoveAll().toString());
        }
        try {
            return (CloudQueueRemoveResponse)this.getCloudMJSClient().executeRequestNew(request).getResponsePayload();
        }
        catch (MathWorksServiceException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
        catch (MathWorksClientException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
    }

    private void addRequestMetadataCriteria(HttpRequest request, CloudQueueMetadata[] criteriaList) {
        if (criteriaList == null) {
            return;
        }
        for (int index = 0; index < criteriaList.length; ++index) {
            CloudQueueMetadata criteria = criteriaList[index];
            if (criteria == null) continue;
            this.addCriteriaParam(request, index, "uuid", criteria.getUuid());
        }
    }
}

