/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls;

import com.vladium.jcd.cls.IClassDefVisitor;
import com.vladium.jcd.cls.IConstantCollection;
import com.vladium.jcd.cls.constant.CONSTANT_Class_info;
import com.vladium.jcd.cls.constant.CONSTANT_Utf8_info;
import com.vladium.jcd.cls.constant.CONSTANT_info;
import com.vladium.jcd.lib.UDataOutputStream;
import com.vladium.util.ObjectIntMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class ConstantCollection
implements IConstantCollection {
    private List m_constants;
    private int m_size;
    private transient ObjectIntMap m_CONSTANT_Utf8_index;
    private transient ObjectIntMap m_CONSTANT_Class_index;

    public CONSTANT_info get(int index) {
        Object result = this.m_constants.get(index - 1);
        if (result == null) {
            throw new IllegalStateException("assertion failure: dereferencing an invalid constant pool slot " + index);
        }
        return (CONSTANT_info)result;
    }

    public IConstantCollection.IConstantIterator iterator() {
        return new ConstantIterator(this.m_constants);
    }

    public int find(int type, IConstantCollection.IConstantComparator comparator) {
        if (comparator == null) {
            throw new IllegalArgumentException("null input: comparator");
        }
        for (int i = 0; i < this.m_constants.size(); ++i) {
            CONSTANT_info constant = (CONSTANT_info)this.m_constants.get(i);
            if (constant == null || constant.tag() != type || !comparator.equals(constant)) continue;
            return i + 1;
        }
        return -1;
    }

    public int findCONSTANT_Utf8(String value) {
        int[] result;
        if (value == null) {
            throw new IllegalArgumentException("null input: value");
        }
        ObjectIntMap index = this.getCONSTANT_Utf8_index();
        if (index.get(value, result = new int[1])) {
            return result[0] + 1;
        }
        return -1;
    }

    public int findCONSTANT_Class(String value) {
        int[] result;
        if (value == null) {
            throw new IllegalArgumentException("null input: value");
        }
        ObjectIntMap index = this.getCONSTANT_Class_index();
        if (index.get(value, result = new int[1])) {
            return result[0] + 1;
        }
        return -1;
    }

    public int size() {
        return this.m_size;
    }

    public Object clone() {
        try {
            ConstantCollection _clone = (ConstantCollection)super.clone();
            int constants_count = this.m_constants.size();
            _clone.m_constants = new ArrayList(constants_count);
            for (int c = 0; c < constants_count; ++c) {
                CONSTANT_info constant = (CONSTANT_info)this.m_constants.get(c);
                _clone.m_constants.add(constant == null ? null : constant.clone());
            }
            return _clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public void writeInClassFormat(UDataOutputStream out) throws IOException {
        CONSTANT_info entry;
        int constant_pool_count = this.m_constants.size();
        out.writeU2(constant_pool_count + 1);
        ConstantIterator i = new ConstantIterator(this.m_constants);
        while ((entry = i.nextConstant()) != null) {
            entry.writeInClassFormat(out);
        }
    }

    public void accept(IClassDefVisitor visitor, Object ctx) {
        visitor.visit(this, ctx);
    }

    public CONSTANT_info set(int index, CONSTANT_info constant) {
        int zindex = index - 1;
        CONSTANT_info result = (CONSTANT_info)this.m_constants.get(zindex);
        if (result == null) {
            throw new IllegalStateException("assertion failure: dereferencing an invalid constant pool slot " + index);
        }
        if (result.width() != constant.width()) {
            throw new IllegalArgumentException("assertion failure: can't set entry of type [" + result.getClass().getName() + "] to an entry of type [" + result.getClass().getName() + "] at pool slot " + index);
        }
        this.m_constants.set(zindex, constant);
        if (this.m_CONSTANT_Utf8_index != null) {
            int[] out;
            String mapKey;
            if (result instanceof CONSTANT_Utf8_info && this.m_CONSTANT_Utf8_index.get(mapKey = ((CONSTANT_Utf8_info)result).m_value, out = new int[1]) && out[0] == zindex) {
                this.m_CONSTANT_Utf8_index.remove(mapKey);
            }
            if (constant instanceof CONSTANT_Utf8_info) {
                this.m_CONSTANT_Utf8_index.put(((CONSTANT_Utf8_info)constant).m_value, zindex);
            }
        }
        return result;
    }

    public int add(CONSTANT_info constant) {
        this.m_constants.add(constant);
        ++this.m_size;
        int result = this.m_constants.size();
        for (int width = 1; width < constant.width(); ++width) {
            ++this.m_size;
            this.m_constants.add(null);
        }
        if (this.m_CONSTANT_Utf8_index != null && constant instanceof CONSTANT_Utf8_info) {
            this.m_CONSTANT_Utf8_index.put(((CONSTANT_Utf8_info)constant).m_value, result - 1);
        }
        return result;
    }

    ConstantCollection(int capacity) {
        this.m_constants = capacity < 0 ? new ArrayList() : new ArrayList(capacity);
    }

    private ObjectIntMap getCONSTANT_Utf8_index() {
        if (this.m_CONSTANT_Utf8_index == null) {
            ObjectIntMap index = new ObjectIntMap(this.m_size);
            for (int i = 0; i < this.m_constants.size(); ++i) {
                CONSTANT_info constant = (CONSTANT_info)this.m_constants.get(i);
                if (constant == null || constant.tag() != 1) continue;
                index.put(((CONSTANT_Utf8_info)constant).m_value, i);
            }
            this.m_CONSTANT_Utf8_index = index;
        }
        return this.m_CONSTANT_Utf8_index;
    }

    private ObjectIntMap getCONSTANT_Class_index() {
        if (this.m_CONSTANT_Class_index == null) {
            ObjectIntMap index = new ObjectIntMap(this.m_size);
            for (int i = 0; i < this.m_constants.size(); ++i) {
                CONSTANT_info constant = (CONSTANT_info)this.m_constants.get(i);
                if (constant == null || constant.tag() != 7) continue;
                int nameindex = ((CONSTANT_Class_info)constant).m_name_index;
                index.put(((CONSTANT_Utf8_info)this.m_constants.get((int)(nameindex - 1))).m_value, i);
            }
            this.m_CONSTANT_Class_index = index;
        }
        return this.m_CONSTANT_Class_index;
    }

    private static final class ConstantIterator
    implements IConstantCollection.IConstantIterator {
        private int m_index;
        private int m_prev_index;
        private int m_next_index;
        private List m_constants;

        ConstantIterator(List constants) {
            this.m_constants = constants;
            this.m_next_index = 1;
            this.shift();
        }

        public int nextIndex() {
            int result = this.m_index;
            this.shift();
            return result;
        }

        public CONSTANT_info nextConstant() {
            int nextIndex = this.nextIndex();
            if (nextIndex < 0) {
                return null;
            }
            return (CONSTANT_info)this.m_constants.get(nextIndex - 1);
        }

        public CONSTANT_info set(CONSTANT_info constant) {
            int zindex = this.m_prev_index - 1;
            CONSTANT_info result = (CONSTANT_info)this.m_constants.get(zindex);
            if (result == null) {
                throw new IllegalStateException("assertion failure: dereferencing an invalid constant pool slot " + this.m_prev_index);
            }
            if (result.width() != constant.width()) {
                throw new IllegalArgumentException("assertion failure: can't set entry of type [" + result.getClass().getName() + "] to an entry of type [" + result.getClass().getName() + "] at pool slot " + this.m_prev_index);
            }
            this.m_constants.set(zindex, constant);
            return result;
        }

        private void shift() {
            this.m_prev_index = this.m_index;
            this.m_index = this.m_next_index;
            if (this.m_index > 0) {
                try {
                    CONSTANT_info entry = (CONSTANT_info)this.m_constants.get(this.m_index - 1);
                    this.m_next_index += entry.width();
                    if (this.m_next_index > this.m_constants.size()) {
                        this.m_next_index = -1;
                    }
                }
                catch (IndexOutOfBoundsException ioobe) {
                    this.m_next_index = -1;
                    this.m_index = -1;
                }
            }
        }
    }
}

