/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp;

import java.util.HashMap;
import java.util.Map;
import org.apache.fop.afp.AFPResourceInfo;
import org.apache.fop.afp.AFPResourceLevel;

public class AFPResourceLevelDefaults {
    private static final Map RESOURCE_TYPE_NAMES = new HashMap();
    private Map defaultResourceLevels = new HashMap();

    private static void registerResourceTypeName(String string, byte by) {
        RESOURCE_TYPE_NAMES.put(string.toLowerCase(), new Byte(by));
    }

    private static byte getResourceType(String string) {
        Byte by = (Byte)RESOURCE_TYPE_NAMES.get(string.toLowerCase());
        if (by == null) {
            throw new IllegalArgumentException("Unknown resource type name: " + string);
        }
        return by;
    }

    public AFPResourceLevelDefaults() {
        this.setDefaultResourceLevel((byte)3, new AFPResourceLevel(0));
    }

    public void setDefaultResourceLevel(String string, AFPResourceLevel aFPResourceLevel) {
        this.setDefaultResourceLevel(AFPResourceLevelDefaults.getResourceType(string), aFPResourceLevel);
    }

    public void setDefaultResourceLevel(byte by, AFPResourceLevel aFPResourceLevel) {
        this.defaultResourceLevels.put(new Byte(by), aFPResourceLevel);
    }

    public AFPResourceLevel getDefaultResourceLevel(byte by) {
        AFPResourceLevel aFPResourceLevel = (AFPResourceLevel)this.defaultResourceLevels.get(new Byte(by));
        if (aFPResourceLevel == null) {
            aFPResourceLevel = AFPResourceInfo.DEFAULT_LEVEL;
        }
        return aFPResourceLevel;
    }

    public void mergeFrom(AFPResourceLevelDefaults aFPResourceLevelDefaults) {
        for (Map.Entry entry : aFPResourceLevelDefaults.defaultResourceLevels.entrySet()) {
            Byte by = (Byte)entry.getKey();
            AFPResourceLevel aFPResourceLevel = (AFPResourceLevel)entry.getValue();
            this.defaultResourceLevels.put(by, aFPResourceLevel);
        }
    }

    static {
        AFPResourceLevelDefaults.registerResourceTypeName("goca", (byte)3);
        AFPResourceLevelDefaults.registerResourceTypeName("bitmap", (byte)6);
    }
}

