/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.goca;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.fop.afp.goca.AbstractGraphicsDrawingOrder;
import org.apache.xmlgraphics.java2d.color.CIELabColorSpace;
import org.apache.xmlgraphics.java2d.color.ColorUtil;
import org.apache.xmlgraphics.java2d.color.ColorWithAlternatives;

public class GraphicsSetProcessColor
extends AbstractGraphicsDrawingOrder {
    private static final byte RGB = 1;
    private static final byte CMYK = 4;
    private static final byte CIELAB = 8;
    private final Color color;
    private final int componentsSize;

    public GraphicsSetProcessColor(Color color) {
        Object object;
        Color color2;
        if (color instanceof ColorWithAlternatives && (color2 = (object = (ColorWithAlternatives)color).getFirstAlternativeOfType(9)) != null) {
            this.color = color2;
            this.componentsSize = 4;
            return;
        }
        object = color.getColorSpace();
        int n = ((ColorSpace)object).getType();
        this.color = n == 9 ? color : (object instanceof CIELabColorSpace ? color : (!color.getColorSpace().isCS_sRGB() ? ColorUtil.toSRGBColor((Color)color) : color));
        this.componentsSize = this.color.getColorSpace().getNumComponents();
    }

    public int getDataLength() {
        return 12 + this.componentsSize;
    }

    byte getOrderCode() {
        return -78;
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        byte[] byArray;
        byte by;
        float[] fArray = this.color.getColorComponents(null);
        ColorSpace colorSpace = this.color.getColorSpace();
        int n = colorSpace.getType();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (n == 9) {
            by = 4;
            byArray = new byte[]{8, 8, 8, 8};
            for (int i = 0; i < fArray.length; ++i) {
                byteArrayOutputStream.write(Math.round(fArray[i] * 255.0f));
            }
        } else if (n == 5) {
            by = 1;
            byArray = new byte[]{8, 8, 8, 0};
            for (int i = 0; i < fArray.length; ++i) {
                byteArrayOutputStream.write(Math.round(fArray[i] * 255.0f));
            }
        } else if (colorSpace instanceof CIELabColorSpace) {
            by = 8;
            byArray = new byte[]{8, 8, 8, 0};
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
            int n2 = Math.round(fArray[0] * 100.0f);
            int n3 = Math.round(fArray[1] * 255.0f) - 128;
            int n4 = Math.round(fArray[2] * 255.0f) - 128;
            dataOutputStream.writeByte(n2);
            dataOutputStream.writeByte(n3);
            dataOutputStream.writeByte(n4);
        } else {
            throw new IllegalStateException();
        }
        int n5 = this.getDataLength();
        byte[] byArray2 = new byte[]{this.getOrderCode(), (byte)(n5 - 2), 0, by, 0, 0, 0, 0, byArray[0], byArray[1], byArray[2], byArray[3]};
        outputStream.write(byArray2);
        byteArrayOutputStream.writeTo(outputStream);
    }

    public String toString() {
        return "GraphicsSetProcessColor(col=" + this.color + ")";
    }
}

