/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.ioca;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.afp.Streamable;

public class IDEStructureParameter
implements Streamable {
    public static final byte COLOR_MODEL_RGB = 1;
    public static final byte COLOR_MODEL_YCRCB = 2;
    public static final byte COLOR_MODEL_CMYK = 4;
    public static final byte COLOR_MODEL_YCBCR = 18;
    private boolean subtractive = false;
    private boolean grayCoding = false;
    private byte colorModel = 1;
    private byte[] bitsPerIDE = new byte[]{1};

    public void setColorModel(byte by) {
        this.colorModel = by;
    }

    public void setDefaultRGBColorModel() {
        this.colorModel = 1;
        this.setUniformBitsPerComponent(3, 8);
    }

    public void setDefaultCMYKColorModel() {
        this.colorModel = (byte)4;
        this.setUniformBitsPerComponent(4, 8);
    }

    public void setUniformBitsPerComponent(int n, int n2) {
        if (n2 < 0 || n2 >= 256) {
            throw new IllegalArgumentException("The number of bits per component must be between 0 and 255");
        }
        this.bitsPerIDE = new byte[n];
        for (int i = 0; i < n; ++i) {
            this.bitsPerIDE[i] = (byte)n2;
        }
    }

    public void setBitsPerComponent(int[] nArray) {
        int n = nArray.length;
        this.bitsPerIDE = new byte[n];
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (n2 < 0 || n2 >= 256) {
                throw new IllegalArgumentException("The number of bits per component must be between 0 and 255");
            }
            this.bitsPerIDE[i] = (byte)n2;
        }
    }

    public void setSubtractive(boolean bl) {
        this.subtractive = bl;
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        int n = 7 + this.bitsPerIDE.length;
        int n2 = 0;
        if (this.subtractive) {
            n2 = (byte)(n2 | 0x80);
        }
        if (this.grayCoding) {
            n2 = (byte)(n2 | 0x40);
        }
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeByte(155);
        dataOutputStream.writeByte(n - 2);
        dataOutputStream.writeByte(n2);
        dataOutputStream.writeByte(this.colorModel);
        for (int i = 0; i < 3; ++i) {
            dataOutputStream.writeByte(0);
        }
        dataOutputStream.write(this.bitsPerIDE);
    }
}

