/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.fop.afp.fonts.AFPFont;
import org.apache.fop.afp.fonts.CharacterSet;
import org.apache.fop.afp.fonts.DoubleByteFont;
import org.apache.fop.afp.fonts.FontRuntimeException;
import org.apache.fop.afp.fonts.OutlineFont;
import org.apache.fop.afp.fonts.RasterFont;
import org.apache.fop.afp.modca.AbstractStructuredObject;
import org.apache.fop.afp.modca.MaximumSizeExceededException;
import org.apache.fop.afp.util.BinaryUtils;

public class MapCodedFont
extends AbstractStructuredObject {
    private final List fontList = new ArrayList();

    public void writeToStream(OutputStream outputStream) throws IOException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[9];
        this.copySF(byArray, (byte)-85, (byte)-118);
        byteArrayOutputStream.write(byArray);
        Iterator iterator = this.fontList.iterator();
        while (iterator.hasNext()) {
            object = (FontDefinition)iterator.next();
            byteArrayOutputStream.write(0);
            if (((FontDefinition)object).scale == 0) {
                byteArrayOutputStream.write(34);
            } else {
                byteArrayOutputStream.write(58);
            }
            byteArrayOutputStream.write(12);
            byteArrayOutputStream.write(2);
            byteArrayOutputStream.write(-122);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(((FontDefinition)object).characterSet);
            byteArrayOutputStream.write(12);
            byteArrayOutputStream.write(2);
            byteArrayOutputStream.write(-123);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(((FontDefinition)object).codePage);
            byteArrayOutputStream.write(4);
            byteArrayOutputStream.write(38);
            byteArrayOutputStream.write(((FontDefinition)object).orientation);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(4);
            byteArrayOutputStream.write(36);
            byteArrayOutputStream.write(5);
            byteArrayOutputStream.write(((FontDefinition)object).fontReferenceKey);
            if (((FontDefinition)object).scale == 0) continue;
            byteArrayOutputStream.write(20);
            byteArrayOutputStream.write(31);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(BinaryUtils.convert(((FontDefinition)object).scale, 2));
            byteArrayOutputStream.write(new byte[]{0, 0});
            byteArrayOutputStream.write(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
            byteArrayOutputStream.write(96);
            byteArrayOutputStream.write(4);
            byteArrayOutputStream.write(93);
            byteArrayOutputStream.write(BinaryUtils.convert(((FontDefinition)object).scale, 2));
        }
        object = byteArrayOutputStream.toByteArray();
        byte[] byArray2 = BinaryUtils.convert(((byte[])object).length - 1, 2);
        object[1] = byArray2[0];
        object[2] = byArray2[1];
        outputStream.write((byte[])object);
    }

    public void addFont(int n, AFPFont aFPFont, int n2, int n3) throws MaximumSizeExceededException {
        FontDefinition fontDefinition = new FontDefinition();
        fontDefinition.fontReferenceKey = BinaryUtils.convert(n)[0];
        switch (n3) {
            case 90: {
                fontDefinition.orientation = (byte)45;
                break;
            }
            case 180: {
                fontDefinition.orientation = (byte)90;
                break;
            }
            case 270: {
                fontDefinition.orientation = (byte)-121;
                break;
            }
            default: {
                fontDefinition.orientation = (byte)0;
            }
        }
        try {
            if (aFPFont instanceof RasterFont) {
                RasterFont rasterFont = (RasterFont)aFPFont;
                CharacterSet characterSet = rasterFont.getCharacterSet(n2);
                if (characterSet == null) {
                    String string = "Character set not found for font " + aFPFont.getFontName() + " with point size " + n2;
                    LOG.error((Object)string);
                    throw new FontRuntimeException(string);
                }
                FontDefinition.access$102(fontDefinition, characterSet.getNameBytes());
                if (fontDefinition.characterSet.length != 8) {
                    throw new IllegalArgumentException("The character set " + new String(fontDefinition.characterSet, "Cp1146") + " must have a fixed length of 8 characters.");
                }
                FontDefinition.access$202(fontDefinition, characterSet.getCodePage().getBytes("Cp1146"));
                if (fontDefinition.codePage.length != 8) {
                    throw new IllegalArgumentException("The code page " + new String(fontDefinition.codePage, "Cp1146") + " must have a fixed length of 8 characters.");
                }
            } else if (aFPFont instanceof OutlineFont) {
                OutlineFont outlineFont = (OutlineFont)aFPFont;
                CharacterSet characterSet = outlineFont.getCharacterSet();
                FontDefinition.access$102(fontDefinition, characterSet.getNameBytes());
                fontDefinition.scale = 20 * n2 / 1000;
                FontDefinition.access$202(fontDefinition, characterSet.getCodePage().getBytes("Cp1146"));
                if (fontDefinition.codePage.length != 8) {
                    throw new IllegalArgumentException("The code page " + new String(fontDefinition.codePage, "Cp1146") + " must have a fixed length of 8 characters.");
                }
            } else if (aFPFont instanceof DoubleByteFont) {
                DoubleByteFont doubleByteFont = (DoubleByteFont)aFPFont;
                CharacterSet characterSet = doubleByteFont.getCharacterSet();
                FontDefinition.access$102(fontDefinition, characterSet.getNameBytes());
                fontDefinition.scale = 20 * n2 / 1000;
                FontDefinition.access$202(fontDefinition, characterSet.getCodePage().getBytes("Cp1146"));
                if (fontDefinition.codePage.length != 8) {
                    throw new IllegalArgumentException("The code page " + new String(fontDefinition.codePage, "Cp1146") + " must have a fixed length of 8 characters.");
                }
            } else {
                String string = "Font of type " + aFPFont.getClass().getName() + " not recognized.";
                LOG.error((Object)string);
                throw new FontRuntimeException(string);
            }
            if (this.fontList.size() > 253) {
                throw new MaximumSizeExceededException();
            }
            this.fontList.add(fontDefinition);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new FontRuntimeException("Failed to create font  due to a UnsupportedEncodingException", unsupportedEncodingException);
        }
    }

    private static final class FontDefinition {
        private byte[] codePage;
        private byte[] characterSet;
        private byte fontReferenceKey;
        private byte orientation;
        private int scale = 0;

        private FontDefinition() {
        }

        static /* synthetic */ byte[] access$102(FontDefinition fontDefinition, byte[] byArray) {
            fontDefinition.characterSet = byArray;
            return byArray;
        }

        static /* synthetic */ byte[] access$202(FontDefinition fontDefinition, byte[] byArray) {
            fontDefinition.codePage = byArray;
            return byArray;
        }
    }
}

