/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.afp.modca.AbstractAFPObject;
import org.apache.fop.afp.modca.MaximumSizeExceededException;
import org.apache.fop.afp.util.BinaryUtils;

public class MapPageOverlay
extends AbstractAFPObject {
    private static final int MAX_SIZE = 253;
    private List overLays = null;

    private List getOverlays() {
        if (this.overLays == null) {
            this.overLays = new ArrayList();
        }
        return this.overLays;
    }

    public void addOverlay(String string) throws MaximumSizeExceededException {
        if (this.getOverlays().size() > 253) {
            throw new MaximumSizeExceededException();
        }
        if (string.length() != 8) {
            throw new IllegalArgumentException("The name of overlay " + string + " must be 8 characters");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addOverlay():: adding overlay " + string));
        }
        try {
            byte[] byArray = string.getBytes("Cp1146");
            this.getOverlays().add(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOG.error((Object)("addOverlay():: UnsupportedEncodingException translating the name " + string));
        }
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        int n = this.getOverlays().size();
        int n2 = n * 18;
        byte[] byArray = new byte[n2 + 9];
        byArray[0] = 90;
        byte[] byArray2 = BinaryUtils.convert(n2 + 8, 2);
        byArray[1] = byArray2[0];
        byArray[2] = byArray2[1];
        byArray[3] = -45;
        byArray[4] = -85;
        byArray[5] = -40;
        byArray[6] = 0;
        byArray[7] = 0;
        byArray[8] = 0;
        int n3 = 8;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            n4 = (byte)(n4 + 1);
            byArray[++n3] = 0;
            byArray[++n3] = 18;
            byArray[++n3] = 12;
            byArray[++n3] = 2;
            byArray[++n3] = -124;
            byArray[++n3] = 0;
            byte[] byArray3 = (byte[])this.overLays.get(i);
            for (int j = 0; j < byArray3.length; ++j) {
                byArray[++n3] = byArray3[j];
            }
            byArray[++n3] = 4;
            byArray[++n3] = 36;
            byArray[++n3] = 2;
            byArray[++n3] = n4;
        }
        outputStream.write(byArray);
    }
}

