/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.afp.modca.AbstractDescriptor;
import org.apache.fop.afp.modca.AbstractNamedAFPObject;
import org.apache.fop.afp.modca.MapContainerData;
import org.apache.fop.afp.modca.MapDataResource;
import org.apache.fop.afp.modca.MapImageObject;
import org.apache.fop.afp.modca.ObjectAreaDescriptor;
import org.apache.fop.afp.modca.ObjectAreaPosition;
import org.apache.fop.afp.modca.PresentationEnvironmentControl;
import org.apache.fop.afp.util.BinaryUtils;

public final class ObjectEnvironmentGroup
extends AbstractNamedAFPObject {
    private PresentationEnvironmentControl presentationEnvironmentControl;
    private ObjectAreaDescriptor objectAreaDescriptor;
    private ObjectAreaPosition objectAreaPosition;
    private MapImageObject mapImageObject;
    private AbstractDescriptor dataDescriptor;
    private MapDataResource mapDataResource;
    private MapContainerData mapContainerData;

    public ObjectEnvironmentGroup(String string) {
        super(string);
    }

    public void setObjectAreaDescriptor(ObjectAreaDescriptor objectAreaDescriptor) {
        this.objectAreaDescriptor = objectAreaDescriptor;
    }

    public void setObjectAreaPosition(ObjectAreaPosition objectAreaPosition) {
        this.objectAreaPosition = objectAreaPosition;
    }

    public void setMapImageObject(MapImageObject mapImageObject) {
        this.mapImageObject = mapImageObject;
    }

    protected void writeStart(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[17];
        this.copySF(byArray, (byte)-88, (byte)-57);
        int n = this.getTripletDataLength();
        int n2 = byArray.length + n - 1;
        byte[] byArray2 = BinaryUtils.convert(n2, 2);
        byArray[1] = byArray2[0];
        byArray[2] = byArray2[1];
        outputStream.write(byArray);
        this.writeTriplets(outputStream);
    }

    protected void writeContent(OutputStream outputStream) throws IOException {
        super.writeContent(outputStream);
        if (this.presentationEnvironmentControl != null) {
            this.presentationEnvironmentControl.writeToStream(outputStream);
        }
        if (this.objectAreaDescriptor != null) {
            this.objectAreaDescriptor.writeToStream(outputStream);
        }
        if (this.objectAreaPosition != null) {
            this.objectAreaPosition.writeToStream(outputStream);
        }
        if (this.mapImageObject != null) {
            this.mapImageObject.writeToStream(outputStream);
        }
        if (this.mapContainerData != null) {
            this.mapContainerData.writeToStream(outputStream);
        }
        if (this.mapDataResource != null) {
            this.mapDataResource.writeToStream(outputStream);
        }
        if (this.dataDescriptor != null) {
            this.dataDescriptor.writeToStream(outputStream);
        }
    }

    protected void writeEnd(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[17];
        this.copySF(byArray, (byte)-87, (byte)-57);
        outputStream.write(byArray);
    }

    public void setPresentationEnvironmentControl(PresentationEnvironmentControl presentationEnvironmentControl) {
        this.presentationEnvironmentControl = presentationEnvironmentControl;
    }

    public void setDataDescriptor(AbstractDescriptor abstractDescriptor) {
        this.dataDescriptor = abstractDescriptor;
    }

    public void setMapDataResource(MapDataResource mapDataResource) {
        this.mapDataResource = mapDataResource;
    }

    public void setMapContainerData(MapContainerData mapContainerData) {
        this.mapContainerData = mapContainerData;
    }

    public ObjectAreaDescriptor getObjectAreaDescriptor() {
        return this.objectAreaDescriptor;
    }
}

