/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.apache.fop.datatypes.FODimension;
import org.apache.fop.traits.WritingMode;

public class CTM
implements Serializable {
    private static final long serialVersionUID = -8743287485623778341L;
    private double a;
    private double b;
    private double c;
    private double d;
    private double e;
    private double f;
    private static final CTM CTM_LRTB = new CTM(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    private static final CTM CTM_RLTB = new CTM(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    private static final CTM CTM_TBRL = new CTM(0.0, 1.0, -1.0, 0.0, 0.0, 0.0);

    public CTM() {
        this.a = 1.0;
        this.b = 0.0;
        this.c = 0.0;
        this.d = 1.0;
        this.e = 0.0;
        this.f = 0.0;
    }

    public CTM(double d, double d2, double d3, double d4, double d5, double d6) {
        this.a = d;
        this.b = d2;
        this.c = d3;
        this.d = d4;
        this.e = d5;
        this.f = d6;
    }

    public CTM(double d, double d2) {
        this.a = 1.0;
        this.b = 0.0;
        this.c = 0.0;
        this.d = 1.0;
        this.e = d;
        this.f = d2;
    }

    protected CTM(CTM cTM) {
        this.a = cTM.a;
        this.b = cTM.b;
        this.c = cTM.c;
        this.d = cTM.d;
        this.e = cTM.e;
        this.f = cTM.f;
    }

    public CTM(AffineTransform affineTransform) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        this.a = dArray[0];
        this.b = dArray[1];
        this.c = dArray[2];
        this.d = dArray[3];
        this.e = dArray[4];
        this.f = dArray[5];
    }

    public static CTM getWMctm(WritingMode writingMode, int n, int n2) {
        switch (writingMode.getEnumValue()) {
            case 79: {
                return new CTM(CTM_LRTB);
            }
            case 121: {
                return new CTM(CTM_RLTB);
            }
            case 140: 
            case 205: {
                CTM cTM = new CTM(CTM_TBRL);
                cTM.e = n2;
                return cTM;
            }
        }
        return null;
    }

    public CTM multiply(CTM cTM) {
        return new CTM(cTM.a * this.a + cTM.b * this.c, cTM.a * this.b + cTM.b * this.d, cTM.c * this.a + cTM.d * this.c, cTM.c * this.b + cTM.d * this.d, cTM.e * this.a + cTM.f * this.c + this.e, cTM.e * this.b + cTM.f * this.d + this.f);
    }

    public CTM rotate(double d) {
        double d2;
        double d3;
        if (d == 90.0 || d == -270.0) {
            d3 = 0.0;
            d2 = 1.0;
        } else if (d == 270.0 || d == -90.0) {
            d3 = 0.0;
            d2 = -1.0;
        } else if (d == 180.0 || d == -180.0) {
            d3 = -1.0;
            d2 = 0.0;
        } else {
            double d4 = Math.toRadians(d);
            d3 = Math.cos(d4);
            d2 = Math.sin(d4);
        }
        CTM cTM = new CTM(d3, -d2, d2, d3, 0.0, 0.0);
        return this.multiply(cTM);
    }

    public CTM translate(double d, double d2) {
        CTM cTM = new CTM(1.0, 0.0, 0.0, 1.0, d, d2);
        return this.multiply(cTM);
    }

    public CTM scale(double d, double d2) {
        CTM cTM = new CTM(d, 0.0, 0.0, d2, 0.0, 0.0);
        return this.multiply(cTM);
    }

    public Rectangle2D transform(Rectangle2D rectangle2D) {
        int n;
        int n2 = (int)(rectangle2D.getX() * this.a + rectangle2D.getY() * this.c + this.e);
        int n3 = (int)(rectangle2D.getX() * this.b + rectangle2D.getY() * this.d + this.f);
        int n4 = (int)((rectangle2D.getX() + rectangle2D.getWidth()) * this.a + (rectangle2D.getY() + rectangle2D.getHeight()) * this.c + this.e);
        int n5 = (int)((rectangle2D.getX() + rectangle2D.getWidth()) * this.b + (rectangle2D.getY() + rectangle2D.getHeight()) * this.d + this.f);
        if (n2 > n4) {
            n = n4;
            n4 = n2;
            n2 = n;
        }
        if (n3 > n5) {
            n = n5;
            n5 = n3;
            n3 = n;
        }
        return new Rectangle(n2, n3, n4 - n2, n5 - n3);
    }

    public String toString() {
        return "[" + this.a + " " + this.b + " " + this.c + " " + this.d + " " + this.e + " " + this.f + "]";
    }

    public double[] toArray() {
        return new double[]{this.a, this.b, this.c, this.d, this.e, this.f};
    }

    public AffineTransform toAffineTransform() {
        return new AffineTransform(this.toArray());
    }

    public static CTM getCTMandRelDims(int n, WritingMode writingMode, Rectangle2D rectangle2D, FODimension fODimension) {
        int n2;
        int n3;
        if (n % 180 == 0) {
            n3 = (int)rectangle2D.getWidth();
            n2 = (int)rectangle2D.getHeight();
        } else {
            n2 = (int)rectangle2D.getWidth();
            n3 = (int)rectangle2D.getHeight();
        }
        CTM cTM = new CTM(rectangle2D.getX(), rectangle2D.getY());
        if (n != 0) {
            switch (n) {
                case -270: 
                case 90: {
                    cTM = cTM.translate(0.0, n3);
                    break;
                }
                case -180: 
                case 180: {
                    cTM = cTM.translate(n3, n2);
                    break;
                }
                case -90: 
                case 270: {
                    cTM = cTM.translate(n2, 0.0);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            cTM = cTM.rotate(n);
        }
        switch (writingMode.getEnumValue()) {
            case 140: 
            case 205: {
                fODimension.ipd = n2;
                fODimension.bpd = n3;
                break;
            }
            default: {
                fODimension.ipd = n3;
                fODimension.bpd = n2;
            }
        }
        return cTM.multiply(CTM.getWMctm(writingMode, fODimension.ipd, fODimension.bpd));
    }
}

