/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.InlineArea;

public class LineArea
extends Area {
    private static final long serialVersionUID = 7670235908329290684L;
    private LineAdjustingInfo adjustingInfo = null;
    private List<InlineArea> inlineAreas = new ArrayList<InlineArea>();

    public LineArea() {
    }

    public LineArea(int n, int n2, int n3, int n4) {
        this.adjustingInfo = new LineAdjustingInfo(n, n2, n3, n4);
    }

    public void addChildArea(Area area) {
        if (area instanceof InlineArea) {
            this.addInlineArea((InlineArea)area);
            ((InlineArea)area).setParentArea(this);
        }
    }

    public void addInlineArea(InlineArea inlineArea) {
        this.inlineAreas.add(inlineArea);
    }

    public void setInlineAreas(List list) {
        for (InlineArea inlineArea : list) {
            Area area = inlineArea.getParentArea();
            if (area == null) {
                inlineArea.setParentArea(this);
                continue;
            }
            assert (area == this);
        }
        this.inlineAreas = list;
    }

    public List getInlineAreas() {
        return this.inlineAreas;
    }

    public int getStartIndent() {
        if (this.hasTrait(Trait.START_INDENT)) {
            return this.getTraitAsInteger(Trait.START_INDENT);
        }
        return 0;
    }

    public int getEndIndent() {
        if (this.hasTrait(Trait.END_INDENT)) {
            return this.getTraitAsInteger(Trait.END_INDENT);
        }
        return 0;
    }

    public void updateExtentsFromChildren() {
        int n = 0;
        int n2 = 0;
        int n3 = this.inlineAreas.size();
        for (int i = 0; i < n3; ++i) {
            n = Math.max(n, this.inlineAreas.get(i).getAllocIPD());
            n2 += this.inlineAreas.get(i).getAllocBPD();
        }
        this.setIPD(n);
        this.setBPD(n2);
    }

    public void handleIPDVariation(int n) {
        int n2 = this.getStartIndent();
        int n3 = this.getEndIndent();
        switch (this.adjustingInfo.lineAlignment) {
            case 135: {
                this.addTrait(Trait.END_INDENT, n3 - n);
                break;
            }
            case 23: {
                this.addTrait(Trait.START_INDENT, n2 - n / 2);
                this.addTrait(Trait.END_INDENT, n3 - n / 2);
                break;
            }
            case 39: {
                this.addTrait(Trait.START_INDENT, n2 - n);
                break;
            }
            case 70: {
                this.adjustingInfo.variationFactor *= (float)(this.adjustingInfo.difference - n) / (float)this.adjustingInfo.difference;
                this.adjustingInfo.difference -= n;
                if (!this.adjustingInfo.bAddedToAreaTree) break;
                this.finish();
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public void finish() {
        if (this.adjustingInfo.lineAlignment == 70) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Applying variation factor to justified line: " + this.adjustingInfo));
            }
            boolean bl = false;
            int n = this.inlineAreas.size();
            for (int i = 0; i < n; ++i) {
                bl |= this.inlineAreas.get(i).applyVariationFactor(this.adjustingInfo.variationFactor, this.adjustingInfo.availableStretch, this.adjustingInfo.availableShrink);
            }
            if (!bl) {
                this.adjustingInfo = null;
            } else {
                if (!this.adjustingInfo.bAddedToAreaTree) {
                    this.adjustingInfo.bAddedToAreaTree = true;
                }
                this.adjustingInfo.variationFactor = 1.0;
            }
        }
    }

    private final class LineAdjustingInfo
    implements Serializable {
        private static final long serialVersionUID = -6103629976229458273L;
        private int lineAlignment;
        private int difference;
        private int availableStretch;
        private int availableShrink;
        private double variationFactor;
        private boolean bAddedToAreaTree;

        private LineAdjustingInfo(int n, int n2, int n3, int n4) {
            this.lineAlignment = n;
            this.difference = n2;
            this.availableStretch = n3;
            this.availableShrink = n4;
            this.variationFactor = 1.0;
            this.bAddedToAreaTree = false;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": diff=" + this.difference + ", variation=" + this.variationFactor + ", stretch=" + this.availableStretch + ", shrink=" + this.availableShrink;
        }
    }
}

