/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.AreaEventProducer;
import org.apache.fop.area.AreaTreeModel;
import org.apache.fop.area.OffDocumentItem;
import org.apache.fop.area.PageSequence;
import org.apache.fop.area.PageViewport;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererEventProducer;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderPagesModel
extends AreaTreeModel {
    protected Renderer renderer;
    protected List<PageViewport> prepared = new ArrayList<PageViewport>();
    private List<OffDocumentItem> pendingODI = new ArrayList<OffDocumentItem>();
    private List<OffDocumentItem> endDocODI = new ArrayList<OffDocumentItem>();

    public RenderPagesModel(FOUserAgent fOUserAgent, String string, FontInfo fontInfo, OutputStream outputStream) throws FOPException {
        this.renderer = fOUserAgent.getRendererFactory().createRenderer(fOUserAgent, string);
        try {
            this.renderer.setupFontInfo(fontInfo);
            if (!fontInfo.isSetupValid()) {
                throw new FOPException("No default font defined by OutputConverter");
            }
            this.renderer.startRenderer(outputStream);
        }
        catch (IOException iOException) {
            throw new FOPException(iOException);
        }
    }

    @Override
    public void setDocumentLocale(Locale locale) {
        this.renderer.setDocumentLocale(locale);
    }

    @Override
    public void startPageSequence(PageSequence pageSequence) {
        super.startPageSequence(pageSequence);
        if (this.renderer.supportsOutOfOrder()) {
            this.renderer.startPageSequence(this.getCurrentPageSequence());
        }
    }

    @Override
    public void addPage(PageViewport pageViewport) {
        boolean bl;
        super.addPage(pageViewport);
        boolean bl2 = bl = this.renderer.supportsOutOfOrder() && pageViewport.isResolved();
        if (bl) {
            if (!this.renderer.supportsOutOfOrder() && pageViewport.getPageSequence().isFirstPage(pageViewport)) {
                this.renderer.startPageSequence(this.getCurrentPageSequence());
            }
            try {
                this.renderer.renderPage(pageViewport);
            }
            catch (RuntimeException runtimeException) {
                String string = "Error while rendering page " + pageViewport.getPageNumberString();
                log.error((Object)string, (Throwable)runtimeException);
                throw runtimeException;
            }
            catch (IOException iOException) {
                RendererEventProducer rendererEventProducer = RendererEventProducer.Provider.get(this.renderer.getUserAgent().getEventBroadcaster());
                rendererEventProducer.ioError(this, iOException);
            }
            catch (FOPException fOPException) {
                String string = "Error while rendering page " + pageViewport.getPageNumberString();
                log.error((Object)string, (Throwable)fOPException);
                throw new IllegalStateException("Fatal error occurred. Cannot continue. " + fOPException.getClass().getName() + ": " + string);
            }
            pageViewport.clear();
        } else {
            this.preparePage(pageViewport);
        }
        boolean bl3 = this.checkPreparedPages(pageViewport, false);
        if (bl3) {
            this.processOffDocumentItems(this.pendingODI);
            this.pendingODI.clear();
        }
    }

    protected boolean checkPreparedPages(PageViewport pageViewport, boolean bl) {
        Iterator<PageViewport> iterator = this.prepared.iterator();
        while (iterator.hasNext()) {
            PageViewport pageViewport2 = iterator.next();
            if (pageViewport2.isResolved() || bl) {
                if (!this.renderer.supportsOutOfOrder() && pageViewport2.getPageSequence().isFirstPage(pageViewport2)) {
                    this.renderer.startPageSequence(pageViewport2.getPageSequence());
                }
                this.renderPage(pageViewport2);
                pageViewport2.clear();
                iterator.remove();
                continue;
            }
            if (this.renderer.supportsOutOfOrder()) continue;
            break;
        }
        return this.renderer.supportsOutOfOrder() || this.prepared.isEmpty();
    }

    protected void renderPage(PageViewport pageViewport) {
        block4: {
            try {
                this.renderer.renderPage(pageViewport);
                if (!pageViewport.isResolved()) {
                    String[] stringArray;
                    for (String string : stringArray = pageViewport.getIDRefs()) {
                        AreaEventProducer areaEventProducer = AreaEventProducer.Provider.get(this.renderer.getUserAgent().getEventBroadcaster());
                        areaEventProducer.unresolvedIDReferenceOnPage(this, pageViewport.getPageNumberString(), string);
                    }
                }
            }
            catch (Exception exception) {
                AreaEventProducer areaEventProducer = AreaEventProducer.Provider.get(this.renderer.getUserAgent().getEventBroadcaster());
                areaEventProducer.pageRenderingError(this, pageViewport.getPageNumberString(), exception);
                if (!(exception instanceof RuntimeException)) break block4;
                throw (RuntimeException)exception;
            }
        }
    }

    protected void preparePage(PageViewport pageViewport) {
        if (this.renderer.supportsOutOfOrder()) {
            this.renderer.preparePage(pageViewport);
        }
        this.prepared.add(pageViewport);
    }

    @Override
    public void handleOffDocumentItem(OffDocumentItem offDocumentItem) {
        switch (offDocumentItem.getWhenToProcess()) {
            case 0: {
                this.renderer.processOffDocumentItem(offDocumentItem);
                break;
            }
            case 1: {
                this.pendingODI.add(offDocumentItem);
                break;
            }
            case 2: {
                this.endDocODI.add(offDocumentItem);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private void processOffDocumentItems(List<OffDocumentItem> list) {
        for (OffDocumentItem offDocumentItem : list) {
            this.renderer.processOffDocumentItem(offDocumentItem);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.checkPreparedPages(null, true);
        this.processOffDocumentItems(this.pendingODI);
        this.pendingODI.clear();
        this.processOffDocumentItems(this.endDocODI);
        try {
            this.renderer.stopRenderer();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }
}

