/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area.inline;

import java.util.List;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Resolvable;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.complexscripts.bidi.InlineRun;
import org.apache.fop.fonts.Font;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnresolvedPageNumber
extends TextArea
implements Resolvable {
    private static final long serialVersionUID = -1758090835371647980L;
    private boolean resolved = false;
    private String pageIDRef;
    private String text;
    private boolean pageType;
    public static final boolean FIRST = true;
    public static final boolean LAST = false;
    private transient Font font;

    public UnresolvedPageNumber(String string, Font font) {
        this(string, font, true);
    }

    public UnresolvedPageNumber(String string, Font font, boolean bl) {
        this.pageIDRef = string;
        this.font = font;
        this.text = "?";
        this.pageType = bl;
    }

    @Override
    public String[] getIDRefs() {
        return new String[]{this.pageIDRef};
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void resolveIDRef(String string, List<PageViewport> list) {
        if (!this.resolved && this.pageIDRef.equals(string) && list != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resolving pageNumber: " + string));
            }
            this.resolved = true;
            int n = this.pageType ? 0 : list.size() - 1;
            PageViewport pageViewport = list.get(n);
            this.removeText();
            this.text = pageViewport.getPageNumberString();
            this.addWord(this.text, 0, this.getBidiLevel());
            if (this.font != null) {
                this.handleIPDVariation(this.font.getWordWidth(this.text) - this.getIPD());
                this.font = null;
            } else {
                log.warn((Object)"Cannot update the IPD of an unresolved page number. No font information available.");
            }
        }
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public boolean applyVariationFactor(double d, int n, int n2) {
        return true;
    }

    @Override
    public List collectInlineRuns(List list) {
        assert (list != null);
        list.add(new InlineRun(this, new int[]{this.getBidiLevel()}));
        return list;
    }
}

