/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.events;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.fop.events.CompositeEventListener;
import org.apache.fop.events.Event;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.events.EventExceptionManager;
import org.apache.fop.events.EventListener;
import org.apache.fop.events.EventProducer;
import org.apache.fop.events.model.EventMethodModel;
import org.apache.fop.events.model.EventModel;
import org.apache.fop.events.model.EventModelParser;
import org.apache.fop.events.model.EventProducerModel;
import org.apache.fop.events.model.EventSeverity;

public class DefaultEventBroadcaster
implements EventBroadcaster {
    protected CompositeEventListener listeners = new CompositeEventListener();
    private static List eventModels = new ArrayList();
    private Map proxies = new HashMap();

    public void addEventListener(EventListener eventListener) {
        this.listeners.addEventListener(eventListener);
    }

    public void removeEventListener(EventListener eventListener) {
        this.listeners.removeEventListener(eventListener);
    }

    public boolean hasEventListeners() {
        return this.listeners.hasEventListeners();
    }

    public void broadcastEvent(Event event) {
        this.listeners.processEvent(event);
    }

    private static EventModel loadModel(Class clazz) {
        String string = "event-model.xml";
        InputStream inputStream = clazz.getResourceAsStream(string);
        if (inputStream == null) {
            throw new MissingResourceException("File " + string + " not found", DefaultEventBroadcaster.class.getName(), "");
        }
        try {
            EventModel eventModel = EventModelParser.parse(new StreamSource(inputStream));
            return eventModel;
        }
        catch (TransformerException transformerException) {
            throw new MissingResourceException("Error reading " + string + ": " + transformerException.getMessage(), DefaultEventBroadcaster.class.getName(), "");
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public static synchronized void addEventModel(EventModel eventModel) {
        eventModels.add(eventModel);
    }

    private static synchronized EventProducerModel getEventProducerModel(Class clazz) {
        int n = eventModels.size();
        for (int i = 0; i < n; ++i) {
            EventModel eventModel = (EventModel)eventModels.get(i);
            EventProducerModel eventProducerModel = eventModel.getProducer(clazz);
            if (eventProducerModel == null) continue;
            return eventProducerModel;
        }
        EventModel eventModel = DefaultEventBroadcaster.loadModel(clazz);
        DefaultEventBroadcaster.addEventModel(eventModel);
        return eventModel.getProducer(clazz);
    }

    public EventProducer getEventProducerFor(Class clazz) {
        if (!EventProducer.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class must be an implementation of the EventProducer interface: " + clazz.getName());
        }
        EventProducer eventProducer = (EventProducer)this.proxies.get(clazz);
        if (eventProducer == null) {
            eventProducer = this.createProxyFor(clazz);
            this.proxies.put(clazz, eventProducer);
        }
        return eventProducer;
    }

    protected EventProducer createProxyFor(Class clazz) {
        final EventProducerModel eventProducerModel = DefaultEventBroadcaster.getEventProducerModel(clazz);
        if (eventProducerModel == null) {
            throw new IllegalStateException("Event model doesn't contain the definition for " + clazz.getName());
        }
        return (EventProducer)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                Serializable serializable2;
                String string = method.getName();
                EventMethodModel eventMethodModel = eventProducerModel.getMethod(string);
                String string2 = eventProducerModel.getInterfaceName() + "." + string;
                if (eventMethodModel == null) {
                    throw new IllegalStateException("Event model isn't consistent with the EventProducer interface. Please rebuild FOP! Affected method: " + string2);
                }
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                int n = 1;
                for (Serializable serializable2 : eventMethodModel.getParameters()) {
                    hashMap.put(((EventMethodModel.Parameter)serializable2).getName(), objectArray[n]);
                    ++n;
                }
                serializable2 = new Event(objectArray[0], string2, eventMethodModel.getSeverity(), hashMap);
                DefaultEventBroadcaster.this.broadcastEvent((Event)serializable2);
                if (((Event)serializable2).getSeverity() == EventSeverity.FATAL) {
                    EventExceptionManager.throwException((Event)serializable2, eventMethodModel.getExceptionClass());
                }
                return null;
            }
        });
    }
}

