/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.events;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.events.Event;
import org.apache.fop.util.XMLResourceBundle;
import org.apache.fop.util.text.AdvancedMessageFormat;

public final class EventFormatter {
    private static final Pattern INCLUDES_PATTERN = Pattern.compile("\\{\\{.+\\}\\}");
    private static Log log = LogFactory.getLog(EventFormatter.class);

    private EventFormatter() {
    }

    private static ResourceBundle getBundle(String string, Locale locale) {
        ResourceBundle resourceBundle;
        String string2 = string != null ? string : EventFormatter.class.getName();
        try {
            ClassLoader classLoader = EventFormatter.class.getClassLoader();
            resourceBundle = XMLResourceBundle.getXMLBundle(string2, locale, classLoader);
        }
        catch (MissingResourceException missingResourceException) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("No XMLResourceBundle for " + string2 + " available."));
            }
            resourceBundle = null;
        }
        return resourceBundle;
    }

    public static String format(Event event) {
        return EventFormatter.format(event, event.getLocale());
    }

    public static String format(Event event, Locale locale) {
        return EventFormatter.format(event, EventFormatter.getBundle(event.getEventGroupID(), locale));
    }

    private static String format(Event event, ResourceBundle resourceBundle) {
        assert (event != null);
        String string = event.getEventKey();
        String string2 = resourceBundle != null ? resourceBundle.getString(string) : "Missing bundle. Can't lookup event key: '" + string + "'.";
        return EventFormatter.format(event, EventFormatter.processIncludes(string2, resourceBundle));
    }

    private static String processIncludes(String string, ResourceBundle resourceBundle) {
        StringBuffer stringBuffer;
        int n;
        CharSequence charSequence = string;
        do {
            stringBuffer = new StringBuffer(Math.max(16, charSequence.length()));
            n = EventFormatter.processIncludesInner(charSequence, stringBuffer, resourceBundle);
            charSequence = stringBuffer;
        } while (n > 0);
        String string2 = stringBuffer.toString();
        return string2;
    }

    private static int processIncludesInner(CharSequence charSequence, StringBuffer stringBuffer, ResourceBundle resourceBundle) {
        int n = 0;
        if (resourceBundle != null) {
            Matcher matcher = INCLUDES_PATTERN.matcher(charSequence);
            while (matcher.find()) {
                String string = matcher.group();
                string = string.substring(2, string.length() - 2);
                matcher.appendReplacement(stringBuffer, resourceBundle.getString(string));
                ++n;
            }
            matcher.appendTail(stringBuffer);
        }
        return n;
    }

    public static String format(Event event, String string) {
        AdvancedMessageFormat advancedMessageFormat = new AdvancedMessageFormat(string);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(event.getParams());
        hashMap.put("source", event.getSource());
        hashMap.put("severity", event.getSeverity());
        hashMap.put("groupID", event.getEventGroupID());
        hashMap.put("locale", event.getLocale());
        return advancedMessageFormat.format(hashMap);
    }

    public static class LookupFieldPartFactory
    implements AdvancedMessageFormat.PartFactory {
        public AdvancedMessageFormat.Part newPart(String string, String string2) {
            return new LookupFieldPart(string);
        }

        public String getFormat() {
            return "lookup";
        }
    }

    private static class LookupFieldPart
    implements AdvancedMessageFormat.Part {
        private String fieldName;

        public LookupFieldPart(String string) {
            this.fieldName = string;
        }

        public boolean isGenerated(Map map) {
            return this.getKey(map) != null;
        }

        public void write(StringBuffer stringBuffer, Map map) {
            Locale locale;
            String string = (String)map.get("groupID");
            ResourceBundle resourceBundle = EventFormatter.getBundle(string, locale = (Locale)map.get("locale"));
            if (resourceBundle != null) {
                stringBuffer.append(resourceBundle.getString(this.getKey(map)));
            }
        }

        private String getKey(Map map) {
            return (String)map.get(this.fieldName);
        }

        public String toString() {
            return "{" + this.fieldName + ", lookup}";
        }
    }
}

