/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.events.model;

import java.util.Stack;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.events.model.EventMethodModel;
import org.apache.fop.events.model.EventModel;
import org.apache.fop.events.model.EventProducerModel;
import org.apache.fop.events.model.EventSeverity;
import org.apache.fop.util.DefaultErrorListener;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class EventModelParser {
    private static final Log LOG = LogFactory.getLog(EventModelParser.class);
    private static SAXTransformerFactory tFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();

    private EventModelParser() {
    }

    public static EventModel parse(Source source) throws TransformerException {
        Transformer transformer = tFactory.newTransformer();
        transformer.setErrorListener(new DefaultErrorListener(LOG));
        EventModel eventModel = new EventModel();
        SAXResult sAXResult = new SAXResult(EventModelParser.getContentHandler(eventModel));
        transformer.transform(source, sAXResult);
        return eventModel;
    }

    public static ContentHandler getContentHandler(EventModel eventModel) {
        return new Handler(eventModel);
    }

    private static class Handler
    extends DefaultHandler {
        private EventModel model;
        private Stack objectStack = new Stack();

        public Handler(EventModel eventModel) {
            this.model = eventModel;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            block10: {
                try {
                    if ("event-model".equals(string2)) {
                        if (this.objectStack.size() > 0) {
                            throw new SAXException("event-model must be the root element");
                        }
                        this.objectStack.push(this.model);
                        break block10;
                    }
                    if ("producer".equals(string2)) {
                        EventProducerModel eventProducerModel = new EventProducerModel(attributes.getValue("name"));
                        EventModel eventModel = (EventModel)this.objectStack.peek();
                        eventModel.addProducer(eventProducerModel);
                        this.objectStack.push(eventProducerModel);
                        break block10;
                    }
                    if ("method".equals(string2)) {
                        EventSeverity eventSeverity = EventSeverity.valueOf(attributes.getValue("severity"));
                        String string4 = attributes.getValue("exception");
                        EventMethodModel eventMethodModel = new EventMethodModel(attributes.getValue("name"), eventSeverity);
                        if (string4 != null && string4.length() > 0) {
                            eventMethodModel.setExceptionClass(string4);
                        }
                        EventProducerModel eventProducerModel = (EventProducerModel)this.objectStack.peek();
                        eventProducerModel.addMethod(eventMethodModel);
                        this.objectStack.push(eventMethodModel);
                        break block10;
                    }
                    if ("parameter".equals(string2)) {
                        Class<?> clazz;
                        String string5 = attributes.getValue("type");
                        try {
                            clazz = Class.forName(string5);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new SAXException("Could not find Class for: " + string5, classNotFoundException);
                        }
                        String string6 = attributes.getValue("name");
                        EventMethodModel eventMethodModel = (EventMethodModel)this.objectStack.peek();
                        this.objectStack.push(eventMethodModel.addParameter(clazz, string6));
                        break block10;
                    }
                    throw new SAXException("Invalid element: " + string3);
                }
                catch (ClassCastException classCastException) {
                    throw new SAXException("XML format error: " + string3, classCastException);
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            this.objectStack.pop();
        }
    }
}

