/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.extensions.svg;

import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.fop.util.ContentHandlerFactory;
import org.apache.fop.util.DelegatingContentHandler;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SVGDOMContentHandlerFactory
implements ContentHandlerFactory {
    private static SAXTransformerFactory tFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();

    public String[] getSupportedNamespaces() {
        return new String[]{"http://www.w3.org/2000/svg"};
    }

    public ContentHandler createContentHandler() throws SAXException {
        return new Handler();
    }

    private static class Handler
    extends DelegatingContentHandler
    implements ContentHandlerFactory.ObjectSource {
        private Document doc;
        private ContentHandlerFactory.ObjectBuiltListener obListener;

        public Document getDocument() {
            return this.doc;
        }

        public Object getObject() {
            return this.getDocument();
        }

        public void setObjectBuiltListener(ContentHandlerFactory.ObjectBuiltListener objectBuiltListener) {
            this.obListener = objectBuiltListener;
        }

        public void startDocument() throws SAXException {
            if (this.doc != null) {
                super.startDocument();
            }
        }

        private DOMImplementation getDOMImplementation(String string) {
            if (string == null || string.length() == 0 || string.equals("1.0") || string.equals("1.1")) {
                return SVGDOMImplementation.getDOMImplementation();
            }
            if (string.equals("1.2")) {
                try {
                    Class<?> clazz = Class.forName("org.apache.batik.dom.svg12.SVG12DOMImplementation");
                    return (DOMImplementation)clazz.getMethod("getDOMImplementation", null).invoke(null, (Object[])null);
                }
                catch (Exception exception) {
                    return SVGDOMImplementation.getDOMImplementation();
                }
            }
            throw new RuntimeException("Unsupport SVG version '" + string + "'");
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.doc == null) {
                TransformerHandler transformerHandler;
                try {
                    transformerHandler = tFactory.newTransformerHandler();
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                    throw new SAXException("Error creating a new TransformerHandler", transformerConfigurationException);
                }
                String string4 = attributes.getValue("version");
                DOMImplementation dOMImplementation = this.getDOMImplementation(string4);
                this.doc = dOMImplementation.createDocument(string, string3, null);
                this.doc.removeChild(this.doc.getDocumentElement());
                transformerHandler.setResult(new DOMResult(this.doc));
                this.setDelegateContentHandler(transformerHandler);
                this.setDelegateLexicalHandler(transformerHandler);
                this.setDelegateDTDHandler(transformerHandler);
                transformerHandler.startDocument();
            }
            super.startElement(string, string2, string3, attributes);
        }

        public void endDocument() throws SAXException {
            super.endDocument();
            if (this.obListener != null) {
                this.obListener.notifyObjectBuilt(this.getObject());
            }
        }
    }
}

