/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.InlineLevel;
import org.apache.fop.fo.properties.StructureTreeElementHolder;
import org.xml.sax.Locator;

public class BasicLink
extends InlineLevel
implements StructureTreeElementHolder {
    private Length alignmentAdjust;
    private int alignmentBaseline;
    private Length baselineShift;
    private int dominantBaseline;
    private StructureTreeElement structureTreeElement;
    private String externalDestination;
    private String internalDestination;
    private int showDestination;
    private boolean blockOrInlineItemFound = false;

    public BasicLink(FONode fONode) {
        super(fONode);
    }

    public void bind(PropertyList propertyList) throws FOPException {
        super.bind(propertyList);
        this.alignmentAdjust = propertyList.get(3).getLength();
        this.alignmentBaseline = propertyList.get(4).getEnum();
        this.baselineShift = propertyList.get(15).getLength();
        this.dominantBaseline = propertyList.get(88).getEnum();
        this.externalDestination = propertyList.get(94).getString();
        this.internalDestination = propertyList.get(128).getString();
        this.showDestination = propertyList.get(219).getEnum();
        if (this.internalDestination.length() > 0) {
            this.externalDestination = null;
        } else if (this.externalDestination.length() == 0) {
            this.getFOValidationEventProducer().missingLinkDestination(this, this.getName(), this.locator);
        }
    }

    protected void startOfNode() throws FOPException {
        super.startOfNode();
        this.getFOEventHandler().startLink(this);
    }

    protected void endOfNode() throws FOPException {
        super.endOfNode();
        this.getFOEventHandler().endLink(this);
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            if (string2.equals("marker")) {
                if (this.blockOrInlineItemFound) {
                    this.nodesOutOfOrderError(locator, "fo:marker", "(#PCDATA|%inline;|%block;)");
                }
            } else if (!this.isBlockOrInlineItem(string, string2)) {
                this.invalidChildError(locator, string, string2);
            } else {
                this.blockOrInlineItemFound = true;
            }
        }
    }

    public Length getAlignmentAdjust() {
        return this.alignmentAdjust;
    }

    public int getAlignmentBaseline() {
        return this.alignmentBaseline;
    }

    public Length getBaselineShift() {
        return this.baselineShift;
    }

    public int getDominantBaseline() {
        return this.dominantBaseline;
    }

    public void setStructureTreeElement(StructureTreeElement structureTreeElement) {
        this.structureTreeElement = structureTreeElement;
    }

    public StructureTreeElement getStructureTreeElement() {
        return this.structureTreeElement;
    }

    public String getInternalDestination() {
        return this.internalDestination;
    }

    public String getExternalDestination() {
        return this.externalDestination;
    }

    public boolean hasInternalDestination() {
        return this.internalDestination != null && this.internalDestination.length() > 0;
    }

    public boolean hasExternalDestination() {
        return this.externalDestination != null && this.externalDestination.length() > 0;
    }

    public int getShowDestination() {
        return this.showDestination;
    }

    public String getLocalName() {
        return "basic-link";
    }

    public int getNameId() {
        return 1;
    }
}

