/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonMarginInline;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.apache.fop.fo.properties.SpaceProperty;
import org.apache.fop.traits.Direction;
import org.apache.fop.traits.WritingMode;
import org.apache.fop.traits.WritingModeTraits;
import org.xml.sax.Locator;

public class InlineContainer
extends FObj {
    private Length alignmentAdjust;
    private int alignmentBaseline;
    private Length baselineShift;
    private LengthRangeProperty blockProgressionDimension;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private CommonMarginInline commonMarginInline;
    private int clip;
    private int dominantBaseline;
    private LengthRangeProperty inlineProgressionDimension;
    private KeepProperty keepTogether;
    private SpaceProperty lineHeight;
    private int overflow;
    private Numeric referenceOrientation;
    private WritingModeTraits writingModeTraits;
    private boolean blockItemFound = false;

    public InlineContainer(FONode fONode) {
        super(fONode);
    }

    public void bind(PropertyList propertyList) throws FOPException {
        super.bind(propertyList);
        this.alignmentAdjust = propertyList.get(3).getLength();
        this.alignmentBaseline = propertyList.get(4).getEnum();
        this.baselineShift = propertyList.get(15).getLength();
        this.blockProgressionDimension = propertyList.get(17).getLengthRange();
        this.commonBorderPaddingBackground = propertyList.getBorderPaddingBackgroundProps();
        this.commonMarginInline = propertyList.getMarginInlineProps();
        this.clip = propertyList.get(71).getEnum();
        this.dominantBaseline = propertyList.get(88).getEnum();
        this.inlineProgressionDimension = propertyList.get(127).getLengthRange();
        this.keepTogether = propertyList.get(131).getKeep();
        this.lineHeight = propertyList.get(144).getSpace();
        this.overflow = propertyList.get(169).getEnum();
        this.referenceOrientation = propertyList.get(197).getNumeric();
        this.writingModeTraits = new WritingModeTraits(WritingMode.valueOf(propertyList.get(267).getEnum()));
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            if (string2.equals("marker")) {
                if (this.blockItemFound) {
                    this.nodesOutOfOrderError(locator, "fo:marker", "(%block;)");
                }
            } else if (!this.isBlockItem(string, string2)) {
                this.invalidChildError(locator, string, string2);
            } else {
                this.blockItemFound = true;
            }
        }
    }

    protected void endOfNode() throws FOPException {
        if (!this.blockItemFound) {
            this.missingChildElementError("marker* (%block;)+");
        }
    }

    public Length getAlignmentAdjust() {
        return this.alignmentAdjust;
    }

    public int getAlignmentBaseline() {
        return this.alignmentBaseline;
    }

    public Length getBaselineShift() {
        return this.baselineShift;
    }

    public LengthRangeProperty getBlockProgressionDimension() {
        return this.blockProgressionDimension;
    }

    public int getClip() {
        return this.clip;
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public CommonMarginInline getCommonMarginInline() {
        return this.commonMarginInline;
    }

    public int getDominantBaseline() {
        return this.dominantBaseline;
    }

    public KeepProperty getKeepTogether() {
        return this.keepTogether;
    }

    public LengthRangeProperty getInlineProgressionDimension() {
        return this.inlineProgressionDimension;
    }

    public SpaceProperty getLineHeight() {
        return this.lineHeight;
    }

    public int getOverflow() {
        return this.overflow;
    }

    public int getReferenceOrientation() {
        return this.referenceOrientation.getValue();
    }

    public Direction getInlineProgressionDirection() {
        return this.writingModeTraits.getInlineProgressionDirection();
    }

    public Direction getBlockProgressionDirection() {
        return this.writingModeTraits.getBlockProgressionDirection();
    }

    public Direction getColumnProgressionDirection() {
        return this.writingModeTraits.getColumnProgressionDirection();
    }

    public Direction getRowProgressionDirection() {
        return this.writingModeTraits.getRowProgressionDirection();
    }

    public Direction getShiftDirection() {
        return this.writingModeTraits.getShiftDirection();
    }

    public WritingMode getWritingMode() {
        return this.writingModeTraits.getWritingMode();
    }

    public String getLocalName() {
        return "inline-container";
    }

    public int getNameId() {
        return 36;
    }

    public boolean isDelimitedTextRangeBoundary(int n) {
        return false;
    }
}

