/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.Stack;
import org.apache.fop.apps.FOPException;
import org.apache.fop.complexscripts.bidi.DelimitedTextRange;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.ListItemBody;
import org.apache.fop.fo.flow.ListItemLabel;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.properties.BreakPropertySet;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAccessibilityHolder;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.KeepProperty;
import org.xml.sax.Locator;

public class ListItem
extends FObj
implements BreakPropertySet,
CommonAccessibilityHolder {
    private CommonAccessibility commonAccessibility;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private CommonMarginBlock commonMarginBlock;
    private int breakAfter;
    private int breakBefore;
    private KeepProperty keepTogether;
    private KeepProperty keepWithNext;
    private KeepProperty keepWithPrevious;
    private ListItemLabel label = null;
    private ListItemBody body = null;

    public ListItem(FONode fONode) {
        super(fONode);
    }

    public void bind(PropertyList propertyList) throws FOPException {
        super.bind(propertyList);
        this.commonAccessibility = CommonAccessibility.getInstance(propertyList);
        this.commonBorderPaddingBackground = propertyList.getBorderPaddingBackgroundProps();
        this.commonMarginBlock = propertyList.getMarginBlockProps();
        this.breakAfter = propertyList.get(58).getEnum();
        this.breakBefore = propertyList.get(59).getEnum();
        this.keepTogether = propertyList.get(131).getKeep();
        this.keepWithNext = propertyList.get(132).getKeep();
        this.keepWithPrevious = propertyList.get(133).getKeep();
    }

    protected void startOfNode() throws FOPException {
        super.startOfNode();
        this.getFOEventHandler().startListItem(this);
    }

    protected void endOfNode() throws FOPException {
        if (this.label == null || this.body == null) {
            this.missingChildElementError("marker* (list-item-label,list-item-body)");
        }
        this.getFOEventHandler().endListItem(this);
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            if (string2.equals("marker")) {
                if (this.label != null) {
                    this.nodesOutOfOrderError(locator, "fo:marker", "fo:list-item-label");
                }
            } else if (string2.equals("list-item-label")) {
                if (this.label != null) {
                    this.tooManyNodesError(locator, "fo:list-item-label");
                }
            } else if (string2.equals("list-item-body")) {
                if (this.label == null) {
                    this.nodesOutOfOrderError(locator, "fo:list-item-label", "fo:list-item-body");
                } else if (this.body != null) {
                    this.tooManyNodesError(locator, "fo:list-item-body");
                }
            } else {
                this.invalidChildError(locator, string, string2);
            }
        }
    }

    public void addChildNode(FONode fONode) {
        int n = fONode.getNameId();
        if (n == 43) {
            this.label = (ListItemLabel)fONode;
        } else if (n == 42) {
            this.body = (ListItemBody)fONode;
        } else if (n == 44) {
            this.addMarker((Marker)fONode);
        }
    }

    public CommonAccessibility getCommonAccessibility() {
        return this.commonAccessibility;
    }

    public CommonMarginBlock getCommonMarginBlock() {
        return this.commonMarginBlock;
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public int getBreakAfter() {
        return this.breakAfter;
    }

    public int getBreakBefore() {
        return this.breakBefore;
    }

    public KeepProperty getKeepWithNext() {
        return this.keepWithNext;
    }

    public KeepProperty getKeepWithPrevious() {
        return this.keepWithPrevious;
    }

    public KeepProperty getKeepTogether() {
        return this.keepTogether;
    }

    public ListItemLabel getLabel() {
        return this.label;
    }

    public ListItemBody getBody() {
        return this.body;
    }

    public String getLocalName() {
        return "list-item";
    }

    public int getNameId() {
        return 41;
    }

    protected Stack collectDelimitedTextRanges(Stack stack, DelimitedTextRange delimitedTextRange) {
        ListItemBody listItemBody;
        ListItemLabel listItemLabel = this.getLabel();
        if (listItemLabel != null) {
            stack = listItemLabel.collectDelimitedTextRanges(stack);
        }
        if ((listItemBody = this.getBody()) != null) {
            stack = listItemBody.collectDelimitedTextRanges(stack);
        }
        return stack;
    }
}

