/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.fo.flow.table.GridUnit;
import org.apache.fop.fo.flow.table.PrimaryGridUnit;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.layoutmgr.Keep;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.util.BreakUtil;

public class EffRow {
    public static final int FIRST_IN_PART = 0;
    public static final int LAST_IN_PART = 1;
    private List gridUnits = new ArrayList();
    private int index;
    private int bodyType;
    private MinOptMax height;
    private MinOptMax explicitHeight;

    public EffRow(int n, int n2, List list) {
        this.index = n;
        this.bodyType = n2;
        this.gridUnits = list;
        for (Object e : list) {
            if (!(e instanceof PrimaryGridUnit)) continue;
            ((PrimaryGridUnit)e).setRowIndex(n);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public int getBodyType() {
        return this.bodyType;
    }

    public TableRow getTableRow() {
        return this.getGridUnit(0).getRow();
    }

    public MinOptMax getHeight() {
        return this.height;
    }

    public void setHeight(MinOptMax minOptMax) {
        this.height = minOptMax;
    }

    public MinOptMax getExplicitHeight() {
        return this.explicitHeight;
    }

    public void setExplicitHeight(MinOptMax minOptMax) {
        this.explicitHeight = minOptMax;
    }

    public List getGridUnits() {
        return this.gridUnits;
    }

    public GridUnit getGridUnit(int n) {
        return (GridUnit)this.gridUnits.get(n);
    }

    public GridUnit safelyGetGridUnit(int n) {
        if (n < this.gridUnits.size()) {
            return (GridUnit)this.gridUnits.get(n);
        }
        return null;
    }

    public boolean getFlag(int n) {
        if (n == 0) {
            return this.getGridUnit(0).getFlag(0);
        }
        if (n == 1) {
            return this.getGridUnit(0).getFlag(1);
        }
        throw new IllegalArgumentException("Illegal flag queried: " + n);
    }

    public Keep getKeepWithPrevious() {
        Keep keep = Keep.KEEP_AUTO;
        TableRow tableRow = this.getTableRow();
        if (tableRow != null) {
            keep = Keep.getKeep(tableRow.getKeepWithPrevious());
        }
        for (GridUnit gridUnit : this.gridUnits) {
            if (!gridUnit.isPrimary()) continue;
            keep = keep.compare(gridUnit.getPrimary().getKeepWithPrevious());
        }
        return keep;
    }

    public Keep getKeepWithNext() {
        Keep keep = Keep.KEEP_AUTO;
        TableRow tableRow = this.getTableRow();
        if (tableRow != null) {
            keep = Keep.getKeep(tableRow.getKeepWithNext());
        }
        for (GridUnit gridUnit : this.gridUnits) {
            if (gridUnit.isEmpty() || gridUnit.getColSpanIndex() != 0 || !gridUnit.isLastGridUnitRowSpan()) continue;
            keep = keep.compare(gridUnit.getPrimary().getKeepWithNext());
        }
        return keep;
    }

    public Keep getKeepTogether() {
        TableRow tableRow = this.getTableRow();
        Keep keep = Keep.KEEP_AUTO;
        if (tableRow != null) {
            keep = Keep.getKeep(tableRow.getKeepTogether());
        }
        return keep;
    }

    public int getBreakBefore() {
        int n = 9;
        for (GridUnit gridUnit : this.gridUnits) {
            if (!gridUnit.isPrimary()) continue;
            n = BreakUtil.compareBreakClasses(n, gridUnit.getPrimary().getBreakBefore());
        }
        return n;
    }

    public int getBreakAfter() {
        int n = 9;
        for (GridUnit gridUnit : this.gridUnits) {
            if (gridUnit.isEmpty() || gridUnit.getColSpanIndex() != 0 || !gridUnit.isLastGridUnitRowSpan()) continue;
            n = BreakUtil.compareBreakClasses(n, gridUnit.getPrimary().getBreakAfter());
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("EffRow {");
        stringBuffer.append(this.index);
        if (this.getBodyType() == 0) {
            stringBuffer.append(" in body");
        } else if (this.getBodyType() == 1) {
            stringBuffer.append(" in header");
        } else {
            stringBuffer.append(" in footer");
        }
        stringBuffer.append(", ").append(this.height);
        stringBuffer.append(", ").append(this.explicitHeight);
        stringBuffer.append(", ").append(this.gridUnits.size()).append(" gu");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

