/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.fo.Constants;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.EnumProperty;
import org.apache.fop.fo.properties.Property;

public class FontStretchPropertyMaker
extends EnumProperty.Maker
implements Constants {
    private Property[] orderedFontStretchValues = null;

    public FontStretchPropertyMaker(int n) {
        super(n);
    }

    public Property convertProperty(Property property, PropertyList propertyList, FObj fObj) throws PropertyException {
        if (property.getEnum() == 85) {
            return this.computeNextAbsoluteFontStretch(propertyList.getFromParent(this.getPropId()), -1);
        }
        if (property.getEnum() == 160) {
            return this.computeNextAbsoluteFontStretch(propertyList.getFromParent(this.getPropId()), 1);
        }
        return super.convertProperty(property, propertyList, fObj);
    }

    private Property computeNextAbsoluteFontStretch(Property property, int n) {
        if (this.orderedFontStretchValues == null) {
            this.orderedFontStretchValues = new Property[]{this.checkEnumValues("ultra-condensed"), this.checkEnumValues("extra-condensed"), this.checkEnumValues("condensed"), this.checkEnumValues("semi-condensed"), this.checkEnumValues("normal"), this.checkEnumValues("semi-expanded"), this.checkEnumValues("expanded"), this.checkEnumValues("extra-expanded"), this.checkEnumValues("ultra-expanded")};
        }
        int n2 = property.getEnum();
        for (int i = 0; i < this.orderedFontStretchValues.length; ++i) {
            if (n2 != this.orderedFontStretchValues[i].getEnum()) continue;
            i = Math.min(Math.max(0, i + n), this.orderedFontStretchValues.length - 1);
            return this.orderedFontStretchValues[i];
        }
        return this.orderedFontStretchValues[4];
    }
}

