/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CIDSubset {
    private Map<Integer, Integer> usedGlyphs = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> usedGlyphsIndex = new HashMap<Integer, Integer>();
    private int usedGlyphsCount = 0;
    private Map<Integer, Character> usedCharsIndex = new HashMap<Integer, Character>();

    public void setupFirstGlyph() {
        this.usedGlyphs.put(0, 0);
        this.usedGlyphsIndex.put(0, 0);
        ++this.usedGlyphsCount;
    }

    public int getGlyphIndexForSubsetIndex(int n) {
        Integer n2 = this.usedGlyphsIndex.get(n);
        if (n2 != null) {
            return n2;
        }
        return -1;
    }

    public char getUnicodeForSubsetIndex(int n) {
        Character c = this.usedCharsIndex.get(n);
        if (c != null) {
            return c.charValue();
        }
        return '\uffff';
    }

    public int mapSubsetChar(int n, char c) {
        Integer n2 = this.usedGlyphs.get(n);
        if (n2 == null) {
            int n3 = this.usedGlyphsCount++;
            this.usedGlyphs.put(n, n3);
            this.usedGlyphsIndex.put(n3, n);
            this.usedCharsIndex.put(n3, Character.valueOf(c));
            return n3;
        }
        return n2;
    }

    public Map<Integer, Integer> getSubsetGlyphs() {
        return Collections.unmodifiableMap(this.usedGlyphs);
    }

    public char[] getSubsetChars() {
        char[] cArray = new char[this.usedGlyphsCount];
        for (int i = 0; i < this.usedGlyphsCount; ++i) {
            cArray[i] = this.getUnicodeForSubsetIndex(i);
        }
        return cArray;
    }

    public int getSubsetSize() {
        return this.usedGlyphsCount;
    }

    public BitSet getGlyphIndexBitSet() {
        BitSet bitSet = new BitSet();
        for (Integer n : this.usedGlyphs.keySet()) {
            bitSet.set(n);
        }
        return bitSet;
    }
}

