/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.truetype;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.TTFDirTabEntry;
import org.apache.fop.fonts.truetype.TTFMtxEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlyfTable {
    private final TTFMtxEntry[] mtxTab;
    private final long tableOffset;
    private final Set<Long> remappedComposites;
    private final Map<Integer, Integer> subset;
    private final FontFileReader in;
    private Set<Integer> compositeGlyphs = new TreeSet<Integer>();
    private Set<Integer> composedGlyphs = new TreeSet<Integer>();

    GlyfTable(FontFileReader fontFileReader, TTFMtxEntry[] tTFMtxEntryArray, TTFDirTabEntry tTFDirTabEntry, Map<Integer, Integer> map) throws IOException {
        this.mtxTab = tTFMtxEntryArray;
        this.tableOffset = tTFDirTabEntry.getOffset();
        this.remappedComposites = new HashSet<Long>();
        this.subset = map;
        this.in = fontFileReader;
    }

    void populateGlyphsWithComposites() throws IOException {
        for (int n : this.subset.keySet()) {
            this.scanGlyphsRecursively(n);
        }
        this.addAllComposedGlyphsToSubset();
        for (int n : this.compositeGlyphs) {
            long l = this.tableOffset + this.mtxTab[n].getOffset() + 10L;
            if (this.remappedComposites.contains(l)) continue;
            this.remapComposite(l);
        }
    }

    private void scanGlyphsRecursively(int n) throws IOException {
        if (!this.subset.containsKey(n)) {
            this.composedGlyphs.add(n);
        }
        if (this.isComposite(n)) {
            this.compositeGlyphs.add(n);
            Set<Integer> set = this.retrieveComposedGlyphs(n);
            for (Integer n2 : set) {
                this.scanGlyphsRecursively(n2);
            }
        }
    }

    private void addAllComposedGlyphsToSubset() {
        int n = this.subset.size();
        for (int n2 : this.composedGlyphs) {
            this.subset.put(n2, n++);
        }
    }

    private void remapComposite(long l) throws IOException {
        long l2 = l;
        this.remappedComposites.add(l2);
        int n = 0;
        do {
            n = this.in.readTTFUShort(l2);
            int n2 = this.in.readTTFUShort(l2 + 2L);
            Integer n3 = this.subset.get(n2);
            assert (n3 != null);
            this.in.writeTTFUShort(l2 + 2L, n3);
            l2 += (long)(4 + GlyfFlags.getOffsetToNextComposedGlyf(n));
        } while (GlyfFlags.hasMoreComposites(n));
    }

    private boolean isComposite(int n) throws IOException {
        short s = this.in.readTTFShort(this.tableOffset + this.mtxTab[n].getOffset());
        return s < 0;
    }

    private Set<Integer> retrieveComposedGlyphs(int n) throws IOException {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        long l = this.tableOffset + this.mtxTab[n].getOffset() + 10L;
        int n2 = 0;
        do {
            n2 = this.in.readTTFUShort(l);
            hashSet.add(this.in.readTTFUShort(l + 2L));
            l += (long)(4 + GlyfFlags.getOffsetToNextComposedGlyf(n2));
        } while (GlyfFlags.hasMoreComposites(n2));
        return hashSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum GlyfFlags {
        ARG_1_AND_2_ARE_WORDS(4, 2),
        ARGS_ARE_XY_VALUES,
        ROUND_XY_TO_GRID,
        WE_HAVE_A_SCALE(2),
        RESERVED,
        MORE_COMPONENTS,
        WE_HAVE_AN_X_AND_Y_SCALE(4),
        WE_HAVE_A_TWO_BY_TWO(8),
        WE_HAVE_INSTRUCTIONS,
        USE_MY_METRICS,
        OVERLAP_COMPOUND,
        SCALED_COMPONENT_OFFSET,
        UNSCALED_COMPONENT_OFFSET;

        private final int bitMask = 1 << this.ordinal();
        private final int argsCountIfSet;
        private final int argsCountIfNotSet;

        private GlyfFlags(int n2, int n3) {
            this.argsCountIfSet = n2;
            this.argsCountIfNotSet = n3;
        }

        private GlyfFlags(int n2) {
            this(n2, 0);
        }

        private GlyfFlags() {
            this(0, 0);
        }

        static int getOffsetToNextComposedGlyf(int n) {
            int n2 = 0;
            for (GlyfFlags glyfFlags : GlyfFlags.values()) {
                n2 += (n & glyfFlags.bitMask) > 0 ? glyfFlags.argsCountIfSet : glyfFlags.argsCountIfNotSet;
            }
            return n2;
        }

        static boolean hasMoreComposites(int n) {
            return (n & GlyfFlags.MORE_COMPONENTS.bitMask) > 0;
        }
    }
}

