/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.truetype;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.GlyfTable;
import org.apache.fop.fonts.truetype.TTFDirTabEntry;
import org.apache.fop.fonts.truetype.TTFFile;
import org.apache.fop.fonts.truetype.TTFGlyphOutputStream;
import org.apache.fop.fonts.truetype.TTFOutputStream;
import org.apache.fop.fonts.truetype.TTFTableName;
import org.apache.fop.fonts.truetype.TTFTableOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TTFSubSetFile
extends TTFFile {
    private byte[] output = null;
    private int realSize = 0;
    private int currentPos = 0;
    private Map<TTFTableName, Integer> offsets = new HashMap<TTFTableName, Integer>();
    private int checkSumAdjustmentOffset = 0;
    private int locaOffset = 0;
    private int[] glyphOffsets;
    private Map<TTFTableName, TTFDirTabEntry> newDirTabs = new HashMap<TTFTableName, TTFDirTabEntry>();

    public TTFSubSetFile() {
    }

    public TTFSubSetFile(boolean bl, boolean bl2) {
        super(bl, bl2);
    }

    private int determineTableCount() {
        int n = 4;
        if (this.isCFF()) {
            throw new UnsupportedOperationException("OpenType fonts with CFF glyphs are not supported");
        }
        n += 5;
        if (this.hasCvt()) {
            ++n;
        }
        if (this.hasFpgm()) {
            ++n;
        }
        if (this.hasPrep()) {
            ++n;
        }
        return n;
    }

    private void createDirectory() {
        int n = this.determineTableCount();
        this.writeByte((byte)0);
        this.writeByte((byte)1);
        this.writeByte((byte)0);
        this.writeByte((byte)0);
        this.realSize += 4;
        this.writeUShort(n);
        this.realSize += 2;
        int n2 = this.maxPow2(n);
        int n3 = (int)Math.pow(2.0, n2) * 16;
        this.writeUShort(n3);
        this.realSize += 2;
        this.writeUShort(n2);
        this.realSize += 2;
        this.writeUShort(n * 16 - n3);
        this.realSize += 2;
        this.writeTableName(TTFTableName.OS2);
        if (this.hasCvt()) {
            this.writeTableName(TTFTableName.CVT);
        }
        if (this.hasFpgm()) {
            this.writeTableName(TTFTableName.FPGM);
        }
        this.writeTableName(TTFTableName.GLYF);
        this.writeTableName(TTFTableName.HEAD);
        this.writeTableName(TTFTableName.HHEA);
        this.writeTableName(TTFTableName.HMTX);
        this.writeTableName(TTFTableName.LOCA);
        this.writeTableName(TTFTableName.MAXP);
        this.writeTableName(TTFTableName.NAME);
        this.writeTableName(TTFTableName.POST);
        if (this.hasPrep()) {
            this.writeTableName(TTFTableName.PREP);
        }
        this.newDirTabs.put(TTFTableName.TABLE_DIRECTORY, new TTFDirTabEntry(0L, this.currentPos));
    }

    private void writeTableName(TTFTableName tTFTableName) {
        this.writeString(tTFTableName.getName());
        this.offsets.put(tTFTableName, this.currentPos);
        this.currentPos += 12;
        this.realSize += 16;
    }

    private boolean hasCvt() {
        return this.dirTabs.containsKey(TTFTableName.CVT);
    }

    private boolean hasFpgm() {
        return this.dirTabs.containsKey(TTFTableName.FPGM);
    }

    private boolean hasPrep() {
        return this.dirTabs.containsKey(TTFTableName.PREP);
    }

    private void createLoca(int n) throws IOException {
        this.pad4();
        this.locaOffset = this.currentPos;
        int n2 = this.offsets.get(TTFTableName.LOCA);
        this.writeULong(n2 + 4, this.currentPos);
        this.writeULong(n2 + 8, n * 4 + 4);
        this.currentPos += n * 4 + 4;
        this.realSize += n * 4 + 4;
    }

    private boolean copyTable(FontFileReader fontFileReader, TTFTableName tTFTableName) throws IOException {
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get(tTFTableName);
        if (tTFDirTabEntry != null) {
            this.pad4();
            this.seekTab(fontFileReader, tTFTableName, 0L);
            System.arraycopy(fontFileReader.getBytes((int)tTFDirTabEntry.getOffset(), (int)tTFDirTabEntry.getLength()), 0, this.output, this.currentPos, (int)tTFDirTabEntry.getLength());
            this.updateCheckSum(this.currentPos, (int)tTFDirTabEntry.getLength(), tTFTableName);
            this.currentPos += (int)tTFDirTabEntry.getLength();
            this.realSize += (int)tTFDirTabEntry.getLength();
            return true;
        }
        return false;
    }

    private boolean createCvt(FontFileReader fontFileReader) throws IOException {
        return this.copyTable(fontFileReader, TTFTableName.CVT);
    }

    private boolean createFpgm(FontFileReader fontFileReader) throws IOException {
        return this.copyTable(fontFileReader, TTFTableName.FPGM);
    }

    private boolean createName(FontFileReader fontFileReader) throws IOException {
        return this.copyTable(fontFileReader, TTFTableName.NAME);
    }

    private boolean createOS2(FontFileReader fontFileReader) throws IOException {
        return this.copyTable(fontFileReader, TTFTableName.OS2);
    }

    private void createMaxp(FontFileReader fontFileReader, int n) throws IOException {
        TTFTableName tTFTableName = TTFTableName.MAXP;
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get(tTFTableName);
        if (tTFDirTabEntry != null) {
            this.pad4();
            this.seekTab(fontFileReader, tTFTableName, 0L);
            System.arraycopy(fontFileReader.getBytes((int)tTFDirTabEntry.getOffset(), (int)tTFDirTabEntry.getLength()), 0, this.output, this.currentPos, (int)tTFDirTabEntry.getLength());
            this.writeUShort(this.currentPos + 4, n);
            this.updateCheckSum(this.currentPos, (int)tTFDirTabEntry.getLength(), tTFTableName);
            this.currentPos += (int)tTFDirTabEntry.getLength();
            this.realSize += (int)tTFDirTabEntry.getLength();
        } else {
            throw new IOException("Can't find maxp table");
        }
    }

    private void createPost(FontFileReader fontFileReader) throws IOException {
        TTFTableName tTFTableName = TTFTableName.POST;
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get(tTFTableName);
        if (tTFDirTabEntry != null) {
            this.pad4();
            this.seekTab(fontFileReader, tTFTableName, 0L);
            int n = 32;
            byte[] byArray = new byte[n];
            System.arraycopy(fontFileReader.getBytes((int)tTFDirTabEntry.getOffset(), n), 0, byArray, 0, n);
            byArray[1] = 3;
            System.arraycopy(byArray, 0, this.output, this.currentPos, n);
            this.updateCheckSum(this.currentPos, n, tTFTableName);
            this.currentPos += n;
            this.realSize += n;
        } else {
            throw new IOException("Can't find post table");
        }
    }

    private boolean createPrep(FontFileReader fontFileReader) throws IOException {
        return this.copyTable(fontFileReader, TTFTableName.PREP);
    }

    private void createHhea(FontFileReader fontFileReader, int n) throws IOException {
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get(TTFTableName.HHEA);
        if (tTFDirTabEntry != null) {
            this.pad4();
            this.seekTab(fontFileReader, TTFTableName.HHEA, 0L);
            System.arraycopy(fontFileReader.getBytes((int)tTFDirTabEntry.getOffset(), (int)tTFDirTabEntry.getLength()), 0, this.output, this.currentPos, (int)tTFDirTabEntry.getLength());
            this.writeUShort((int)tTFDirTabEntry.getLength() + this.currentPos - 2, n);
            this.updateCheckSum(this.currentPos, (int)tTFDirTabEntry.getLength(), TTFTableName.HHEA);
            this.currentPos += (int)tTFDirTabEntry.getLength();
            this.realSize += (int)tTFDirTabEntry.getLength();
        } else {
            throw new IOException("Can't find hhea table");
        }
    }

    private void createHead(FontFileReader fontFileReader) throws IOException {
        TTFTableName tTFTableName = TTFTableName.HEAD;
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get(tTFTableName);
        if (tTFDirTabEntry != null) {
            this.pad4();
            this.seekTab(fontFileReader, tTFTableName, 0L);
            System.arraycopy(fontFileReader.getBytes((int)tTFDirTabEntry.getOffset(), (int)tTFDirTabEntry.getLength()), 0, this.output, this.currentPos, (int)tTFDirTabEntry.getLength());
            this.checkSumAdjustmentOffset = this.currentPos + 8;
            this.output[this.currentPos + 8] = 0;
            this.output[this.currentPos + 9] = 0;
            this.output[this.currentPos + 10] = 0;
            this.output[this.currentPos + 11] = 0;
            this.output[this.currentPos + 50] = 0;
            this.output[this.currentPos + 51] = 1;
            this.updateCheckSum(this.currentPos, (int)tTFDirTabEntry.getLength(), tTFTableName);
            this.currentPos += (int)tTFDirTabEntry.getLength();
            this.realSize += (int)tTFDirTabEntry.getLength();
        } else {
            throw new IOException("Can't find head table");
        }
    }

    private void createGlyf(FontFileReader fontFileReader, Map<Integer, Integer> map) throws IOException {
        int n;
        int n2;
        int n3;
        TTFTableName tTFTableName = TTFTableName.GLYF;
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get(tTFTableName);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (tTFDirTabEntry != null) {
            this.pad4();
            n5 = this.currentPos;
            int[] nArray = this.buildSubsetIndexToOrigIndexMap(map);
            this.glyphOffsets = new int[nArray.length];
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n2 = 0;
                n = nArray[n3];
                n2 = n >= this.mtxTab.length - 1 ? (int)this.lastLoca : (int)this.mtxTab[n + 1].getOffset();
                int n7 = (int)this.mtxTab[n].getOffset();
                int n8 = n2 - n7;
                byte[] byArray = fontFileReader.getBytes((int)tTFDirTabEntry.getOffset() + n7, n8);
                int n9 = n6;
                System.arraycopy(byArray, 0, this.output, this.currentPos, n8);
                this.writeULong(this.locaOffset + n3 * 4, this.currentPos - n5);
                if (this.currentPos - n5 + n8 > n9) {
                    n9 = this.currentPos - n5 + n8;
                }
                this.glyphOffsets[n3] = this.currentPos;
                this.currentPos += n8;
                this.realSize += n8;
                n6 = n9;
            }
            n4 = this.currentPos - n5;
            this.currentPos += 12;
            this.realSize += 12;
        } else {
            throw new IOException("Can't find glyf table");
        }
        this.updateCheckSum(n5, n4 + 12, tTFTableName);
        this.writeULong(this.locaOffset + map.size() * 4, n6);
        n3 = map.size() * 4 + 4;
        n2 = TTFSubSetFile.getCheckSum(this.output, this.locaOffset, n3);
        this.writeULong(this.offsets.get(TTFTableName.LOCA), n2);
        n = (this.locaOffset + n3) % 4;
        this.newDirTabs.put(TTFTableName.LOCA, new TTFDirTabEntry(this.locaOffset, n3 + n));
    }

    private int[] buildSubsetIndexToOrigIndexMap(Map<Integer, Integer> map) {
        int[] nArray = new int[map.size()];
        for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
            int n = entry.getKey();
            int n2 = entry.getValue();
            nArray[n2] = n;
        }
        return nArray;
    }

    private void createHmtx(FontFileReader fontFileReader, Map<Integer, Integer> map) throws IOException {
        TTFTableName tTFTableName = TTFTableName.HMTX;
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get(tTFTableName);
        int n = map.size() * 2;
        int n2 = map.size() * 2;
        int n3 = n + n2;
        if (tTFDirTabEntry != null) {
            this.pad4();
            for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
                Integer n4 = entry.getKey();
                Integer n5 = entry.getValue();
                this.writeUShort(this.currentPos + n5 * 4, this.mtxTab[n4].getWx());
                this.writeUShort(this.currentPos + n5 * 4 + 2, this.mtxTab[n4].getLsb());
            }
            this.updateCheckSum(this.currentPos, n3, tTFTableName);
            this.currentPos += n3;
            this.realSize += n3;
        } else {
            throw new IOException("Can't find hmtx table");
        }
    }

    @Override
    public void readFont(FontFileReader fontFileReader, String string, Map<Integer, Integer> map) throws IOException {
        this.fontFile = fontFileReader;
        if (!this.checkTTC(string)) {
            throw new IOException("Failed to read font");
        }
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>(map);
        this.output = new byte[fontFileReader.getFileSize()];
        this.readDirTabs();
        this.readFontHeader();
        this.getNumGlyphs();
        this.readHorizontalHeader();
        this.readHorizontalMetrics();
        this.readIndexToLocation();
        this.scanGlyphs(fontFileReader, hashMap);
        this.createDirectory();
        boolean bl = this.createCvt(fontFileReader);
        if (!bl) {
            this.log.debug((Object)"TrueType: ctv table not present. Skipped.");
        }
        if (!(bl = this.createFpgm(fontFileReader))) {
            this.log.debug((Object)"TrueType: fpgm table not present. Skipped.");
        }
        this.createLoca(hashMap.size());
        this.createGlyf(fontFileReader, hashMap);
        this.createOS2(fontFileReader);
        this.createHead(fontFileReader);
        this.createHhea(fontFileReader, hashMap.size());
        this.createHmtx(fontFileReader, hashMap);
        this.createMaxp(fontFileReader, hashMap.size());
        this.createName(fontFileReader);
        this.createPost(fontFileReader);
        bl = this.createPrep(fontFileReader);
        if (!bl) {
            this.log.debug((Object)"TrueType: prep table not present. Skipped.");
        }
        this.pad4();
        this.createCheckSumAdjustment();
    }

    public byte[] getFontSubset() {
        byte[] byArray = new byte[this.realSize];
        System.arraycopy(this.output, 0, byArray, 0, this.realSize);
        return byArray;
    }

    private void handleGlyphSubset(TTFGlyphOutputStream tTFGlyphOutputStream) throws IOException {
        tTFGlyphOutputStream.startGlyphStream();
        for (int i = 0; i < this.glyphOffsets.length - 1; ++i) {
            tTFGlyphOutputStream.streamGlyph(this.output, this.glyphOffsets[i], this.glyphOffsets[i + 1] - this.glyphOffsets[i]);
        }
        TTFDirTabEntry tTFDirTabEntry = this.newDirTabs.get(TTFTableName.GLYF);
        long l = tTFDirTabEntry.getLength() - ((long)this.glyphOffsets[this.glyphOffsets.length - 1] - tTFDirTabEntry.getOffset());
        tTFGlyphOutputStream.streamGlyph(this.output, this.glyphOffsets[this.glyphOffsets.length - 1], (int)l);
        tTFGlyphOutputStream.endGlyphStream();
    }

    @Override
    public void stream(TTFOutputStream tTFOutputStream) throws IOException {
        SortedSet<Map.Entry<TTFTableName, TTFDirTabEntry>> sortedSet = this.sortDirTabMap(this.newDirTabs);
        TTFTableOutputStream tTFTableOutputStream = tTFOutputStream.getTableOutputStream();
        TTFGlyphOutputStream tTFGlyphOutputStream = tTFOutputStream.getGlyphOutputStream();
        tTFOutputStream.startFontStream();
        for (Map.Entry entry : sortedSet) {
            if (((TTFTableName)entry.getKey()).equals(TTFTableName.GLYF)) {
                this.handleGlyphSubset(tTFGlyphOutputStream);
                continue;
            }
            tTFTableOutputStream.streamTable(this.output, (int)((TTFDirTabEntry)entry.getValue()).getOffset(), (int)((TTFDirTabEntry)entry.getValue()).getLength());
        }
        tTFOutputStream.endFontStream();
    }

    private void scanGlyphs(FontFileReader fontFileReader, Map<Integer, Integer> map) throws IOException {
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get(TTFTableName.GLYF);
        if (tTFDirTabEntry == null) {
            throw new IOException("Glyf table could not be found");
        }
        GlyfTable glyfTable = new GlyfTable(fontFileReader, this.mtxTab, tTFDirTabEntry, map);
        glyfTable.populateGlyphsWithComposites();
    }

    private int writeString(String string) {
        int n = 0;
        try {
            byte[] byArray = string.getBytes("ISO-8859-1");
            System.arraycopy(byArray, 0, this.output, this.currentPos, byArray.length);
            n = byArray.length;
            this.currentPos += n;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return n;
    }

    private void writeByte(byte by) {
        this.output[this.currentPos++] = by;
    }

    private void writeUShort(int n) {
        byte by = (byte)(n >> 8 & 0xFF);
        byte by2 = (byte)(n & 0xFF);
        this.writeByte(by);
        this.writeByte(by2);
    }

    private void writeUShort(int n, int n2) {
        byte by = (byte)(n2 >> 8 & 0xFF);
        byte by2 = (byte)(n2 & 0xFF);
        this.output[n] = by;
        this.output[n + 1] = by2;
    }

    private void writeULong(int n, int n2) {
        byte by = (byte)(n2 >> 24 & 0xFF);
        byte by2 = (byte)(n2 >> 16 & 0xFF);
        byte by3 = (byte)(n2 >> 8 & 0xFF);
        byte by4 = (byte)(n2 & 0xFF);
        this.output[n] = by;
        this.output[n + 1] = by2;
        this.output[n + 2] = by3;
        this.output[n + 3] = by4;
    }

    private void pad4() {
        int n = this.getPadSize(this.currentPos);
        if (n < 4) {
            for (int i = 0; i < n; ++i) {
                this.output[this.currentPos++] = 0;
                ++this.realSize;
            }
        }
    }

    private int maxPow2(int n) {
        int n2 = 0;
        while (Math.pow(2.0, n2) <= (double)n) {
            ++n2;
        }
        return n2 - 1;
    }

    private void updateCheckSum(int n, int n2, TTFTableName tTFTableName) {
        int n3 = TTFSubSetFile.getCheckSum(this.output, n, n2);
        int n4 = this.offsets.get(tTFTableName);
        int n5 = this.getPadSize(n + n2);
        this.newDirTabs.put(tTFTableName, new TTFDirTabEntry(n, n2 + n5));
        this.writeULong(n4, n3);
        this.writeULong(n4 + 4, n);
        this.writeULong(n4 + 8, n2);
    }

    private static int getCheckSum(byte[] byArray, int n, int n2) {
        int n3 = n2 % 4;
        if (n3 != 0) {
            n2 += n3;
        }
        long l = 0L;
        for (int i = 0; i < n2; i += 4) {
            long l2 = 0L;
            for (int j = 0; j < 4; ++j) {
                l2 <<= 8;
                l2 |= (long)(byArray[n + i + j] & 0xFF);
            }
            l += l2;
        }
        return (int)l;
    }

    private void createCheckSumAdjustment() {
        long l = TTFSubSetFile.getCheckSum(this.output, 0, this.realSize);
        int n = (int)(-1313820742L - l);
        this.writeULong(this.checkSumAdjustmentOffset, n);
    }
}

