/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.BlockParent;
import org.apache.fop.fo.pagination.Flow;
import org.apache.fop.layoutmgr.AreaAdditionUtil;
import org.apache.fop.layoutmgr.BlockContainerLayoutManager;
import org.apache.fop.layoutmgr.BlockLayoutManager;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.Keep;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.util.ListUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowLayoutManager
extends BlockStackingLayoutManager
implements BlockLevelLayoutManager {
    private static Log log = LogFactory.getLog(FlowLayoutManager.class);
    private BlockParent[] currentAreas = new BlockParent[6];

    public FlowLayoutManager(PageSequenceLayoutManager pageSequenceLayoutManager, Flow flow) {
        super(flow);
        this.setParent(pageSequenceLayoutManager);
    }

    @Override
    public List getNextKnuthElements(LayoutContext layoutContext, int n) {
        return this.getNextKnuthElements(layoutContext, n, null, null);
    }

    List getNextKnuthElements(LayoutContext layoutContext, int n, Position position, LayoutManager layoutManager) {
        LayoutManager layoutManager2;
        boolean bl;
        LinkedList<ListElement> linkedList = new LinkedList<ListElement>();
        boolean bl2 = bl = position != null;
        Stack<LayoutManager> stack = new Stack<LayoutManager>();
        if (bl) {
            layoutManager2 = position.getLM();
            if (layoutManager2 == null) {
                throw new IllegalStateException("Cannot find layout manager to restart from");
            }
            if (layoutManager != null && layoutManager.getParent() == this) {
                layoutManager2 = layoutManager;
            } else {
                while (layoutManager2.getParent() != this) {
                    stack.push(layoutManager2);
                    layoutManager2 = layoutManager2.getParent();
                }
                bl2 = false;
            }
            this.setCurrentChildLM(layoutManager2);
        } else {
            layoutManager2 = this.getChildLM();
        }
        while (layoutManager2 != null) {
            if (!bl || bl2) {
                if (bl2) {
                    layoutManager2.reset();
                }
                if (this.addChildElements(linkedList, layoutManager2, layoutContext, n, null, null, null) != null) {
                    return linkedList;
                }
            } else {
                if (this.addChildElements(linkedList, layoutManager2, layoutContext, n, stack, position, layoutManager) != null) {
                    return linkedList;
                }
                bl2 = true;
            }
            layoutManager2 = this.getChildLM();
        }
        SpaceResolver.resolveElementList(linkedList);
        this.setFinished(true);
        assert (!linkedList.isEmpty());
        return linkedList;
    }

    private List<ListElement> addChildElements(List<ListElement> list, LayoutManager layoutManager, LayoutContext layoutContext, int n, Stack<LayoutManager> stack, Position position, LayoutManager layoutManager2) {
        if (this.handleSpanChange(layoutManager, layoutContext)) {
            SpaceResolver.resolveElementList(list);
            return list;
        }
        LayoutContext layoutContext2 = this.makeChildLayoutContext(layoutContext);
        List<ListElement> list2 = this.getNextChildElements(layoutManager, layoutContext, layoutContext2, n, stack, position, layoutManager2);
        if (list.isEmpty()) {
            layoutContext.updateKeepWithPreviousPending(layoutContext2.getKeepWithPreviousPending());
        }
        if (!list.isEmpty() && !ElementListUtils.startsWithForcedBreak(list2)) {
            this.addInBetweenBreak(list, layoutContext, layoutContext2);
        }
        layoutContext.updateKeepWithNextPending(layoutContext2.getKeepWithNextPending());
        list.addAll(list2);
        if (ElementListUtils.endsWithForcedBreak(list)) {
            if (layoutManager.isFinished() && !this.hasNextChildLM()) {
                this.setFinished(true);
            }
            SpaceResolver.resolveElementList(list);
            return list;
        }
        return null;
    }

    private boolean handleSpanChange(LayoutManager layoutManager, LayoutContext layoutContext) {
        int n = 95;
        int n2 = 48;
        if (layoutManager instanceof BlockLayoutManager) {
            n = ((BlockLayoutManager)layoutManager).getBlockFO().getSpan();
            n2 = ((BlockLayoutManager)layoutManager).getBlockFO().getDisableColumnBalancing();
        } else if (layoutManager instanceof BlockContainerLayoutManager) {
            n = ((BlockContainerLayoutManager)layoutManager).getBlockContainerFO().getSpan();
            n2 = ((BlockContainerLayoutManager)layoutManager).getBlockContainerFO().getDisableColumnBalancing();
        }
        int n3 = layoutContext.getCurrentSpan();
        if (n3 != n) {
            if (n == 5) {
                layoutContext.setDisableColumnBalancing(n2);
            }
            log.debug((Object)("span change from " + n3 + " to " + n));
            layoutContext.signalSpanChange(n);
            return true;
        }
        return false;
    }

    @Override
    protected LayoutContext makeChildLayoutContext(LayoutContext layoutContext) {
        LayoutContext layoutContext2 = new LayoutContext(0);
        layoutContext2.setStackLimitBP(layoutContext.getStackLimitBP());
        layoutContext2.setRefIPD(layoutContext.getRefIPD());
        layoutContext2.setWritingMode(this.getCurrentPage().getSimplePageMaster().getWritingMode());
        return layoutContext2;
    }

    @Override
    protected List<ListElement> getNextChildElements(LayoutManager layoutManager, LayoutContext layoutContext, LayoutContext layoutContext2, int n, Stack<LayoutManager> stack, Position position, LayoutManager layoutManager2) {
        List<ListElement> list = stack == null ? layoutManager.getNextKnuthElements(layoutContext2, n) : layoutManager.getNextKnuthElements(layoutContext2, n, stack, position, layoutManager2);
        assert (!list.isEmpty());
        LinkedList<ListElement> linkedList = list;
        list = new LinkedList<ListElement>();
        this.wrapPositionElements(linkedList, list);
        return list;
    }

    @Override
    public int negotiateBPDAdjustment(int n, KnuthElement knuthElement) {
        log.debug((Object)(" FLM.negotiateBPDAdjustment> " + n));
        if (knuthElement.getPosition() instanceof NonLeafPosition) {
            NonLeafPosition nonLeafPosition = (NonLeafPosition)knuthElement.getPosition();
            knuthElement.setPosition(nonLeafPosition.getPosition());
            int n2 = ((BlockLevelLayoutManager)knuthElement.getLayoutManager()).negotiateBPDAdjustment(n, knuthElement);
            knuthElement.setPosition(nonLeafPosition);
            log.debug((Object)(" FLM.negotiateBPDAdjustment> result " + n2));
            return n2;
        }
        return 0;
    }

    @Override
    public void discardSpace(KnuthGlue knuthGlue) {
        log.debug((Object)" FLM.discardSpace> ");
        if (knuthGlue.getPosition() instanceof NonLeafPosition) {
            NonLeafPosition nonLeafPosition = (NonLeafPosition)knuthGlue.getPosition();
            knuthGlue.setPosition(nonLeafPosition.getPosition());
            ((BlockLevelLayoutManager)knuthGlue.getLayoutManager()).discardSpace(knuthGlue);
            knuthGlue.setPosition(nonLeafPosition);
        }
    }

    @Override
    public Keep getKeepTogether() {
        return Keep.KEEP_AUTO;
    }

    @Override
    public Keep getKeepWithNext() {
        return Keep.KEEP_AUTO;
    }

    @Override
    public Keep getKeepWithPrevious() {
        return Keep.KEEP_AUTO;
    }

    @Override
    public List<KnuthElement> getChangedKnuthElements(List list, int n) {
        Object object;
        ListIterator listIterator = list.listIterator();
        LinkedList<KnuthPenalty> linkedList = new LinkedList<KnuthPenalty>();
        LinkedList<KnuthElement> linkedList2 = new LinkedList<KnuthElement>();
        ListElement listElement = null;
        KnuthElement knuthElement = null;
        int n2 = 0;
        while (listIterator.hasNext()) {
            KnuthElement knuthElement2 = (KnuthElement)listIterator.next();
            if (knuthElement2.getPosition() instanceof NonLeafPosition) {
                knuthElement2.setPosition(knuthElement2.getPosition().getPosition());
                continue;
            }
            listIterator.remove();
        }
        listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            knuthElement = (KnuthElement)listIterator.next();
            if (listElement != null && listElement.getLayoutManager() != knuthElement.getLayoutManager()) {
                object = (BlockLevelLayoutManager)listElement.getLayoutManager();
                BlockLevelLayoutManager blockLevelLayoutManager = (BlockLevelLayoutManager)knuthElement.getLayoutManager();
                linkedList.addAll(object.getChangedKnuthElements(list.subList(n2, listIterator.previousIndex()), n));
                n2 = listIterator.previousIndex();
                if (object.mustKeepWithNext() || blockLevelLayoutManager.mustKeepWithPrevious()) {
                    linkedList.add(new KnuthPenalty(0, 1000, false, new Position(this), false));
                } else if (!((KnuthElement)ListUtil.getLast(linkedList)).isGlue()) {
                    linkedList.add(new KnuthPenalty(0, 0, false, new Position(this), false));
                }
            }
            listElement = knuthElement;
        }
        if (knuthElement != null) {
            object = (BlockLevelLayoutManager)knuthElement.getLayoutManager();
            linkedList.addAll(object.getChangedKnuthElements(list.subList(n2, list.size()), n));
        }
        object = linkedList.listIterator();
        while (object.hasNext()) {
            KnuthElement knuthElement3 = (KnuthElement)object.next();
            if (knuthElement3.getLayoutManager() != this) {
                knuthElement3.setPosition(new NonLeafPosition((LayoutManager)this, knuthElement3.getPosition()));
            }
            linkedList2.add(knuthElement3);
        }
        return linkedList2;
    }

    @Override
    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        AreaAdditionUtil.addAreas(this, positionIterator, layoutContext);
        this.flush();
    }

    @Override
    public void addChildArea(Area area) {
        this.getParentArea(area);
        this.addChildToArea(area, this.currentAreas[area.getAreaClass()]);
    }

    @Override
    public Area getParentArea(Area area) {
        BlockParent blockParent = null;
        int n = area.getAreaClass();
        if (n == 0) {
            blockParent = this.getCurrentPV().getCurrentFlow();
        } else if (n == 3) {
            blockParent = this.getCurrentPV().getBodyRegion().getBeforeFloat();
        } else if (n == 4) {
            blockParent = this.getCurrentPV().getBodyRegion().getFootnote();
        } else {
            throw new IllegalStateException("(internal error) Invalid area class (" + n + ") requested.");
        }
        this.currentAreas[n] = blockParent;
        this.setCurrentArea(blockParent);
        return blockParent;
    }

    @Override
    public int getContentAreaIPD() {
        return this.getCurrentPV().getCurrentSpan().getColumnWidth();
    }

    @Override
    public int getContentAreaBPD() {
        return this.getCurrentPV().getBodyRegion().getBPD();
    }

    @Override
    public boolean isRestartable() {
        return true;
    }
}

