/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.fop.layoutmgr.AbstractBreaker;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.Position;

public class KnuthPenalty
extends KnuthElement {
    public static final int FLAGGED_PENALTY = 50;
    public static final KnuthPenalty DUMMY_ZERO_PENALTY = new KnuthPenalty(0, 0, false, null, true);
    private int penalty;
    private boolean penaltyFlagged;
    private int breakClass = -1;

    public KnuthPenalty(int n, int n2, boolean bl, Position position, boolean bl2) {
        super(n, position, bl2);
        this.penalty = n2;
        this.penaltyFlagged = bl;
    }

    public KnuthPenalty(int n, int n2, boolean bl, int n3, Position position, boolean bl2) {
        this(n, n2, bl, position, bl2);
        this.breakClass = n3;
    }

    private static String getBreakClassName(int n) {
        return AbstractBreaker.getBreakClassName(n);
    }

    protected static String valueOf(int n) {
        String string = n < 0 ? "-" : "";
        int n2 = Math.abs(n);
        string = string + (n2 == 1000 ? "INFINITE" : String.valueOf(n2));
        return string;
    }

    public boolean isPenalty() {
        return true;
    }

    public int getPenalty() {
        return this.penalty;
    }

    public void setPenalty(int n) {
        this.penalty = n;
    }

    public boolean isPenaltyFlagged() {
        return this.penaltyFlagged;
    }

    public boolean isForcedBreak() {
        return this.penalty == -1000;
    }

    public int getBreakClass() {
        return this.breakClass;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        if (this.isAuxiliary()) {
            stringBuffer.append("aux. ");
        }
        stringBuffer.append("penalty");
        stringBuffer.append(" p=");
        stringBuffer.append(KnuthPenalty.valueOf(this.penalty));
        if (this.penaltyFlagged) {
            stringBuffer.append(" [flagged]");
        }
        stringBuffer.append(" w=");
        stringBuffer.append(this.getWidth());
        if (this.isForcedBreak()) {
            stringBuffer.append(" (forced break, ").append(KnuthPenalty.getBreakClassName(this.breakClass)).append(")");
        } else if (this.penalty >= 0 && this.breakClass != -1) {
            stringBuffer.append(" (keep constraint, ").append(KnuthPenalty.getBreakClassName(this.breakClass)).append(")");
        }
        return stringBuffer.toString();
    }
}

