/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.util.ListUtil;

public abstract class KnuthSequence
extends ArrayList {
    public KnuthSequence() {
    }

    public KnuthSequence(List list) {
        super(list);
    }

    public void startSequence() {
    }

    public abstract KnuthSequence endSequence();

    public abstract boolean canAppendSequence(KnuthSequence var1);

    public abstract boolean appendSequence(KnuthSequence var1, boolean var2, BreakElement var3);

    public abstract boolean appendSequence(KnuthSequence var1);

    public boolean appendSequenceOrClose(KnuthSequence knuthSequence) {
        if (!this.appendSequence(knuthSequence)) {
            this.endSequence();
            return false;
        }
        return true;
    }

    public boolean appendSequenceOrClose(KnuthSequence knuthSequence, boolean bl, BreakElement breakElement) {
        if (!this.appendSequence(knuthSequence, bl, breakElement)) {
            this.endSequence();
            return false;
        }
        return true;
    }

    public void wrapPositions(LayoutManager layoutManager) {
        ListIterator listIterator = this.listIterator();
        while (listIterator.hasNext()) {
            ListElement listElement = (ListElement)listIterator.next();
            listElement.setPosition(layoutManager.notifyPos(new NonLeafPosition(layoutManager, listElement.getPosition())));
        }
    }

    public ListElement getLast() {
        return this.isEmpty() ? null : (ListElement)ListUtil.getLast(this);
    }

    public ListElement removeLast() {
        return this.isEmpty() ? null : (ListElement)ListUtil.removeLast(this);
    }

    public ListElement getElement(int n) {
        return n >= this.size() || n < 0 ? null : (ListElement)this.get(n);
    }

    protected int getFirstBoxIndex() {
        if (this.isEmpty()) {
            return -1;
        }
        return this.getFirstBoxIndex(0);
    }

    protected int getFirstBoxIndex(int n) {
        int n2;
        if (this.isEmpty() || n < 0 || n >= this.size()) {
            return -1;
        }
        ListElement listElement = null;
        int n3 = this.size();
        for (n2 = n; n2 < n3 && !(listElement = this.getElement(n2)).isBox(); ++n2) {
        }
        if (n2 != n) {
            if (listElement != null && listElement.isBox()) {
                return n2 - 1;
            }
            return n;
        }
        return n;
    }

    public abstract boolean isInlineSequence();

    public String toString() {
        return "<KnuthSequence " + super.toString() + ">";
    }
}

