/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.fop.layoutmgr.Keep;
import org.apache.fop.layoutmgr.SpaceSpecifier;
import org.apache.fop.layoutmgr.UnresolvedListElementWithLength;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.WritingMode;

public class LayoutContext {
    public static final int LINEBREAK_AT_LF_ONLY = 1;
    public static final int NEW_AREA = 2;
    public static final int IPD_UNKNOWN = 4;
    public static final int CHECK_REF_AREA = 8;
    public static final int SUPPRESS_BREAK_BEFORE = 16;
    public static final int FIRST_AREA = 32;
    public static final int TRY_HYPHENATE = 64;
    public static final int LAST_AREA = 128;
    public static final int RESOLVE_LEADING_SPACE = 256;
    private int flags;
    private MinOptMax stackLimitBP;
    private int currentSpan = 0;
    private int nextSpan = 0;
    private int refIPD;
    private WritingMode writingMode = WritingMode.LR_TB;
    private SpaceSpecifier trailingSpace;
    private SpaceSpecifier leadingSpace;
    private List pendingAfterMarks;
    private List pendingBeforeMarks;
    private HyphContext hyphContext = null;
    private int bpAlignment = 135;
    private double ipdAdjust = 0.0;
    private double dSpaceAdjust = 0.0;
    private AlignmentContext alignmentContext = null;
    private int spaceBefore = 0;
    private int spaceAfter = 0;
    private int lineStartBorderAndPaddingWidth = 0;
    private int lineEndBorderAndPaddingWidth = 0;
    private int breakBefore;
    private int breakAfter;
    private Keep pendingKeepWithNext = Keep.KEEP_AUTO;
    private Keep pendingKeepWithPrevious = Keep.KEEP_AUTO;
    private int disableColumnBalancing;

    public LayoutContext(LayoutContext layoutContext) {
        this.flags = layoutContext.flags;
        this.refIPD = layoutContext.refIPD;
        this.writingMode = layoutContext.writingMode;
        this.setStackLimitBP(layoutContext.getStackLimitBP());
        this.leadingSpace = layoutContext.leadingSpace;
        this.trailingSpace = layoutContext.trailingSpace;
        this.hyphContext = layoutContext.hyphContext;
        this.bpAlignment = layoutContext.bpAlignment;
        this.dSpaceAdjust = layoutContext.dSpaceAdjust;
        this.ipdAdjust = layoutContext.ipdAdjust;
        this.alignmentContext = layoutContext.alignmentContext;
        this.lineStartBorderAndPaddingWidth = layoutContext.lineStartBorderAndPaddingWidth;
        this.lineEndBorderAndPaddingWidth = layoutContext.lineEndBorderAndPaddingWidth;
        this.copyPendingMarksFrom(layoutContext);
        this.pendingKeepWithNext = layoutContext.pendingKeepWithNext;
        this.pendingKeepWithPrevious = layoutContext.pendingKeepWithPrevious;
        this.disableColumnBalancing = layoutContext.disableColumnBalancing;
    }

    public LayoutContext(int n) {
        this.flags = n;
        this.refIPD = 0;
        this.stackLimitBP = MinOptMax.ZERO;
        this.leadingSpace = null;
        this.trailingSpace = null;
    }

    public void copyPendingMarksFrom(LayoutContext layoutContext) {
        if (layoutContext.pendingAfterMarks != null) {
            this.pendingAfterMarks = new ArrayList(layoutContext.pendingAfterMarks);
        }
        if (layoutContext.pendingBeforeMarks != null) {
            this.pendingBeforeMarks = new ArrayList(layoutContext.pendingBeforeMarks);
        }
    }

    public void setFlags(int n) {
        this.setFlags(n, true);
    }

    public void setFlags(int n, boolean bl) {
        this.flags = bl ? (this.flags |= n) : (this.flags &= ~n);
    }

    public void unsetFlags(int n) {
        this.setFlags(n, false);
    }

    public boolean isStart() {
        return (this.flags & 2) != 0;
    }

    public boolean startsNewArea() {
        return (this.flags & 2) != 0 && this.leadingSpace != null;
    }

    public boolean isFirstArea() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isLastArea() {
        return (this.flags & 0x80) != 0;
    }

    public boolean suppressBreakBefore() {
        return (this.flags & 0x10) != 0;
    }

    public Keep getKeepWithNextPending() {
        return this.pendingKeepWithNext;
    }

    public Keep getKeepWithPreviousPending() {
        return this.pendingKeepWithPrevious;
    }

    public void clearKeepWithNextPending() {
        this.pendingKeepWithNext = Keep.KEEP_AUTO;
    }

    public void clearKeepWithPreviousPending() {
        this.pendingKeepWithPrevious = Keep.KEEP_AUTO;
    }

    public void clearKeepsPending() {
        this.clearKeepWithPreviousPending();
        this.clearKeepWithNextPending();
    }

    public void updateKeepWithNextPending(Keep keep) {
        this.pendingKeepWithNext = this.pendingKeepWithNext.compare(keep);
    }

    public void updateKeepWithPreviousPending(Keep keep) {
        this.pendingKeepWithPrevious = this.pendingKeepWithPrevious.compare(keep);
    }

    public boolean isKeepWithNextPending() {
        return !this.getKeepWithNextPending().isAuto();
    }

    public boolean isKeepWithPreviousPending() {
        return !this.getKeepWithPreviousPending().isAuto();
    }

    public void setLeadingSpace(SpaceSpecifier spaceSpecifier) {
        this.leadingSpace = spaceSpecifier;
    }

    public SpaceSpecifier getLeadingSpace() {
        return this.leadingSpace;
    }

    public boolean resolveLeadingSpace() {
        return (this.flags & 0x100) != 0;
    }

    public void setTrailingSpace(SpaceSpecifier spaceSpecifier) {
        this.trailingSpace = spaceSpecifier;
    }

    public SpaceSpecifier getTrailingSpace() {
        return this.trailingSpace;
    }

    public void addPendingAfterMark(UnresolvedListElementWithLength unresolvedListElementWithLength) {
        if (this.pendingAfterMarks == null) {
            this.pendingAfterMarks = new ArrayList();
        }
        this.pendingAfterMarks.add(unresolvedListElementWithLength);
    }

    public List getPendingAfterMarks() {
        if (this.pendingAfterMarks != null) {
            return Collections.unmodifiableList(this.pendingAfterMarks);
        }
        return null;
    }

    public void clearPendingMarks() {
        this.pendingBeforeMarks = null;
        this.pendingAfterMarks = null;
    }

    public void addPendingBeforeMark(UnresolvedListElementWithLength unresolvedListElementWithLength) {
        if (this.pendingBeforeMarks == null) {
            this.pendingBeforeMarks = new ArrayList();
        }
        this.pendingBeforeMarks.add(unresolvedListElementWithLength);
    }

    public List getPendingBeforeMarks() {
        if (this.pendingBeforeMarks != null) {
            return Collections.unmodifiableList(this.pendingBeforeMarks);
        }
        return null;
    }

    public void setStackLimitBP(MinOptMax minOptMax) {
        this.stackLimitBP = minOptMax;
    }

    public MinOptMax getStackLimitBP() {
        return this.stackLimitBP;
    }

    public void setRefIPD(int n) {
        this.refIPD = n;
    }

    public int getRefIPD() {
        return this.refIPD;
    }

    public void setHyphContext(HyphContext hyphContext) {
        this.hyphContext = hyphContext;
    }

    public HyphContext getHyphContext() {
        return this.hyphContext;
    }

    public boolean tryHyphenate() {
        return (this.flags & 0x40) != 0;
    }

    public void setBPAlignment(int n) {
        this.bpAlignment = n;
    }

    public int getBPAlignment() {
        return this.bpAlignment;
    }

    public void setSpaceAdjust(double d) {
        this.dSpaceAdjust = d;
    }

    public double getSpaceAdjust() {
        return this.dSpaceAdjust;
    }

    public void setIPDAdjust(double d) {
        this.ipdAdjust = d;
    }

    public double getIPDAdjust() {
        return this.ipdAdjust;
    }

    public void setAlignmentContext(AlignmentContext alignmentContext) {
        this.alignmentContext = alignmentContext;
    }

    public AlignmentContext getAlignmentContext() {
        return this.alignmentContext;
    }

    public void resetAlignmentContext() {
        if (this.alignmentContext != null) {
            this.alignmentContext = this.alignmentContext.getParentAlignmentContext();
        }
    }

    public int getLineStartBorderAndPaddingWidth() {
        return this.lineStartBorderAndPaddingWidth;
    }

    public void setLineStartBorderAndPaddingWidth(int n) {
        this.lineStartBorderAndPaddingWidth = n;
    }

    public int getLineEndBorderAndPaddingWidth() {
        return this.lineEndBorderAndPaddingWidth;
    }

    public void setLineEndBorderAndPaddingWidth(int n) {
        this.lineEndBorderAndPaddingWidth = n;
    }

    public int getNextSpan() {
        return this.nextSpan;
    }

    public int getCurrentSpan() {
        return this.currentSpan == 0 ? 95 : this.currentSpan;
    }

    public void signalSpanChange(int n) {
        switch (n) {
            case 0: 
            case 5: 
            case 95: {
                this.currentSpan = this.nextSpan;
                this.nextSpan = n;
                break;
            }
            default: {
                assert (false);
                throw new IllegalArgumentException("Illegal value on signalSpanChange() for span: " + n);
            }
        }
    }

    public WritingMode getWritingMode() {
        return this.writingMode;
    }

    public void setWritingMode(WritingMode writingMode) {
        this.writingMode = writingMode;
    }

    public int getSpaceBefore() {
        return this.spaceBefore;
    }

    public void setSpaceBefore(int n) {
        this.spaceBefore = n;
    }

    public int getSpaceAfter() {
        return this.spaceAfter;
    }

    public void setSpaceAfter(int n) {
        this.spaceAfter = n;
    }

    public int getBreakBefore() {
        return this.breakBefore;
    }

    public void setBreakBefore(int n) {
        this.breakBefore = n;
    }

    public int getBreakAfter() {
        return this.breakAfter;
    }

    public void setBreakAfter(int n) {
        this.breakAfter = n;
    }

    public String toString() {
        return "Layout Context:\nStack Limit BPD: \t" + (this.getStackLimitBP() == null ? "null" : this.getStackLimitBP().toString()) + "\nTrailing Space: \t" + (this.getTrailingSpace() == null ? "null" : this.getTrailingSpace().toString()) + "\nLeading Space: \t" + (this.getLeadingSpace() == null ? "null" : this.getLeadingSpace().toString()) + "\nReference IPD: \t" + this.getRefIPD() + "\nSpace Adjust: \t" + this.getSpaceAdjust() + "\nIPD Adjust: \t" + this.getIPDAdjust() + "\nResolve Leading Space: \t" + this.resolveLeadingSpace() + "\nSuppress Break Before: \t" + this.suppressBreakBefore() + "\nIs First Area: \t" + this.isFirstArea() + "\nStarts New Area: \t" + this.startsNewArea() + "\nIs Last Area: \t" + this.isLastArea() + "\nTry Hyphenate: \t" + this.tryHyphenate() + "\nKeeps: \t[keep-with-next=" + this.getKeepWithNextPending() + "][keep-with-previous=" + this.getKeepWithPreviousPending() + "] pending" + "\nBreaks: \tforced [" + (this.breakBefore != 9 ? "break-before" : "") + "][" + (this.breakAfter != 9 ? "break-after" : "") + "]";
    }

    public int getDisableColumnBalancing() {
        return this.disableColumnBalancing;
    }

    public void setDisableColumnBalancing(int n) {
        this.disableColumnBalancing = n;
    }
}

