/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.AreaTreeHandler;
import org.apache.fop.area.AreaTreeModel;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.PageSequence;
import org.apache.fop.complexscripts.bidi.BidiResolver;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.SideRegion;
import org.apache.fop.fo.pagination.StaticContent;
import org.apache.fop.layoutmgr.AbstractPageSequenceLayoutManager;
import org.apache.fop.layoutmgr.Page;
import org.apache.fop.layoutmgr.PageBreaker;
import org.apache.fop.layoutmgr.PageProvider;
import org.apache.fop.layoutmgr.StaticContentLayoutManager;
import org.apache.fop.layoutmgr.inline.ContentLayoutManager;

public class PageSequenceLayoutManager
extends AbstractPageSequenceLayoutManager {
    private static Log log = LogFactory.getLog(PageSequenceLayoutManager.class);
    private PageProvider pageProvider;

    public PageSequenceLayoutManager(AreaTreeHandler areaTreeHandler, org.apache.fop.fo.pagination.PageSequence pageSequence) {
        super(areaTreeHandler, pageSequence);
        this.pageProvider = new PageProvider(areaTreeHandler, pageSequence);
    }

    public PageProvider getPageProvider() {
        return this.pageProvider;
    }

    protected org.apache.fop.fo.pagination.PageSequence getPageSequence() {
        return (org.apache.fop.fo.pagination.PageSequence)this.pageSeq;
    }

    public PageSequenceLayoutManager getPSLM() {
        return this;
    }

    public void activateLayout() {
        Object object;
        this.initialize();
        if (this.areaTreeHandler.isComplexScriptFeaturesEnabled()) {
            BidiResolver.resolveInlineDirectionality(this.getPageSequence());
        }
        LineArea lineArea = null;
        if (this.getPageSequence().getTitleFO() != null) {
            try {
                object = this.getLayoutManagerMaker().makeContentLayoutManager(this, this.getPageSequence().getTitleFO());
                lineArea = (LineArea)((ContentLayoutManager)object).getParentArea(null);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        object = this.areaTreeHandler.getAreaTreeModel();
        PageSequence pageSequence = new PageSequence(lineArea);
        this.transferExtensions(pageSequence);
        pageSequence.setLanguage(this.getPageSequence().getLanguage());
        pageSequence.setCountry(this.getPageSequence().getCountry());
        ((AreaTreeModel)object).startPageSequence(pageSequence);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting layout");
        }
        this.curPage = this.makeNewPage(false);
        PageBreaker pageBreaker = new PageBreaker(this);
        int n = this.getCurrentPV().getBodyRegion().getRemainingBPD();
        pageBreaker.doLayout(n);
        this.finishPage();
    }

    public void finishPageSequence() {
        if (this.pageSeq.hasId()) {
            this.idTracker.signalIDProcessed(this.pageSeq.getId());
        }
        this.pageSeq.getRoot().notifyPageSequenceFinished(this.currentPageNum, this.currentPageNum - this.startPageNum + 1);
        this.areaTreeHandler.notifyPageSequenceFinished(this.pageSeq, this.currentPageNum - this.startPageNum + 1);
        this.getPageSequence().releasePageSequence();
        String string = this.getPageSequence().getMasterReference();
        PageSequenceMaster pageSequenceMaster = this.pageSeq.getRoot().getLayoutMasterSet().getPageSequenceMaster(string);
        if (pageSequenceMaster != null) {
            pageSequenceMaster.reset();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Ending layout");
        }
    }

    protected Page createPage(int n, boolean bl) {
        return this.pageProvider.getPage(bl, n, 0);
    }

    protected Page makeNewPage(boolean bl) {
        Page page = super.makeNewPage(bl);
        if (!bl) {
            while (!this.getPageSequence().getMainFlow().getFlowName().equals(page.getSimplePageMaster().getRegion(58).getRegionName())) {
                page = super.makeNewPage(bl);
            }
        }
        return page;
    }

    private void layoutSideRegion(int n) {
        SideRegion sideRegion = (SideRegion)this.curPage.getSimplePageMaster().getRegion(n);
        if (sideRegion == null) {
            return;
        }
        StaticContent staticContent = this.getPageSequence().getStaticContent(sideRegion.getRegionName());
        if (staticContent == null) {
            return;
        }
        StaticContentLayoutManager staticContentLayoutManager = this.getLayoutManagerMaker().makeStaticContentLayoutManager(this, staticContent, sideRegion);
        staticContentLayoutManager.doLayout();
    }

    protected void finishPage() {
        this.layoutSideRegion(57);
        this.layoutSideRegion(56);
        this.layoutSideRegion(61);
        this.layoutSideRegion(59);
        super.finishPage();
    }

    protected int getForcedLastPageNum(int n) {
        int n2 = n;
        if (n % 2 != 0 && (this.getPageSequence().getForcePageCount() == 43 || this.getPageSequence().getForcePageCount() == 40)) {
            ++n2;
        } else if (n % 2 == 0 && (this.getPageSequence().getForcePageCount() == 99 || this.getPageSequence().getForcePageCount() == 41)) {
            ++n2;
        }
        return n2;
    }
}

