/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.LinkedList;
import java.util.List;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.fo.flow.Character;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontSelector;
import org.apache.fop.layoutmgr.InlineKnuthSequence;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;
import org.apache.fop.layoutmgr.inline.LeafNodeLayoutManager;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;
import org.apache.fop.util.CharUtilities;

public class CharacterLayoutManager
extends LeafNodeLayoutManager {
    private MinOptMax letterSpaceIPD;
    private int hyphIPD;
    private Font font;
    private CommonBorderPaddingBackground borderProps = null;

    public CharacterLayoutManager(Character character) {
        super(character);
    }

    public void initialize() {
        Character character = (Character)this.fobj;
        this.font = FontSelector.selectFontForCharacter(character, this);
        SpaceVal spaceVal = SpaceVal.makeLetterSpacing(character.getLetterSpacing());
        this.letterSpaceIPD = spaceVal.getSpace();
        this.hyphIPD = character.getCommonHyphenation().getHyphIPD(this.font);
        this.borderProps = character.getCommonBorderPaddingBackground();
        this.setCommonBorderPaddingBackground(this.borderProps);
        TextArea textArea = this.getCharacterInlineArea(character);
        textArea.setBaselineOffset(this.font.getAscender());
        this.setCurrentArea(textArea);
    }

    private TextArea getCharacterInlineArea(Character character) {
        TextArea textArea = new TextArea();
        char c = character.getCharacter();
        int n = this.font.getCharWidth(c);
        int n2 = 0;
        int n3 = character.getBidiLevel();
        if (CharUtilities.isAnySpace(c)) {
            if (!CharUtilities.isZeroWidthSpace(c)) {
                textArea.addSpace(c, n, CharUtilities.isAdjustableSpace(c), n2, n3);
            }
        } else {
            int[] nArray;
            if (n3 >= 0) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = n3;
            } else {
                nArray = null;
            }
            int[] nArray3 = nArray;
            textArea.addWord(String.valueOf(c), n, null, nArray3, null, n2);
        }
        TraitSetter.setProducerID(textArea, character.getId());
        TraitSetter.addTextDecoration(textArea, character.getTextDecoration());
        TraitSetter.addStructureTreeElement(textArea, character.getStructureTreeElement());
        return textArea;
    }

    public List getNextKnuthElements(LayoutContext layoutContext, int n) {
        this.curArea = this.get(layoutContext);
        InlineKnuthSequence inlineKnuthSequence = new InlineKnuthSequence();
        if (this.curArea == null) {
            this.setFinished(true);
            return null;
        }
        Character character = (Character)this.fobj;
        MinOptMax minOptMax = MinOptMax.getInstance(this.curArea.getIPD());
        this.curArea.setBPD(this.font.getAscender() - this.font.getDescender());
        TraitSetter.addFontTraits(this.curArea, this.font);
        this.curArea.addTrait(Trait.COLOR, character.getColor());
        this.alignmentContext = new AlignmentContext(this.font, this.font.getFontSize(), character.getAlignmentAdjust(), character.getAlignmentBaseline(), character.getBaselineShift(), character.getDominantBaseline(), layoutContext.getAlignmentContext());
        this.addKnuthElementsForBorderPaddingStart(inlineKnuthSequence);
        this.areaInfo = new LeafNodeLayoutManager.AreaInfo(this, 0, minOptMax, false, this.alignmentContext);
        if (this.letterSpaceIPD.isStiff()) {
            inlineKnuthSequence.add(new KnuthInlineBox(this.areaInfo.ipdArea.getOpt(), this.areaInfo.alignmentContext, this.notifyPos(new LeafPosition(this, 0)), false));
        } else {
            inlineKnuthSequence.add(new KnuthInlineBox(this.areaInfo.ipdArea.getOpt(), this.areaInfo.alignmentContext, this.notifyPos(new LeafPosition(this, 0)), false));
            inlineKnuthSequence.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
            inlineKnuthSequence.add(new KnuthGlue(0, 0, 0, new LeafPosition(this, -1), true));
            inlineKnuthSequence.add(new KnuthInlineBox(0, null, this.notifyPos(new LeafPosition(this, -1)), true));
        }
        this.addKnuthElementsForBorderPaddingEnd(inlineKnuthSequence);
        LinkedList<InlineKnuthSequence> linkedList = new LinkedList<InlineKnuthSequence>();
        linkedList.add(inlineKnuthSequence);
        this.setFinished(true);
        return linkedList;
    }

    public String getWordChars(Position position) {
        return ((TextArea)this.curArea).getText();
    }

    public void hyphenate(Position position, HyphContext hyphContext) {
        if (hyphContext.getNextHyphPoint() == 1) {
            this.areaInfo.isHyphenated = true;
            this.somethingChanged = true;
        }
        hyphContext.updateOffset(1);
    }

    public boolean applyChanges(List list) {
        this.setFinished(false);
        return this.somethingChanged;
    }

    public List getChangedKnuthElements(List list, int n) {
        if (this.isFinished()) {
            return null;
        }
        LinkedList<KnuthElement> linkedList = new LinkedList<KnuthElement>();
        this.addKnuthElementsForBorderPaddingStart(linkedList);
        if (this.letterSpaceIPD.isStiff() || this.areaInfo.letterSpaces == 0) {
            linkedList.add(new KnuthInlineBox(this.areaInfo.ipdArea.getOpt(), this.areaInfo.alignmentContext, this.notifyPos(new LeafPosition(this, 0)), false));
            if (this.areaInfo.isHyphenated) {
                linkedList.add(new KnuthPenalty(this.hyphIPD, 50, true, new LeafPosition(this, -1), false));
            }
        } else {
            linkedList.add(new KnuthInlineBox(this.areaInfo.ipdArea.getOpt() - this.areaInfo.letterSpaces * this.letterSpaceIPD.getOpt(), this.areaInfo.alignmentContext, this.notifyPos(new LeafPosition(this, 0)), false));
            linkedList.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
            linkedList.add(new KnuthGlue(this.letterSpaceIPD.mult(this.areaInfo.letterSpaces), (Position)new LeafPosition(this, -1), true));
            linkedList.add(new KnuthInlineBox(0, null, this.notifyPos(new LeafPosition(this, -1)), true));
            if (this.areaInfo.isHyphenated) {
                linkedList.add(new KnuthPenalty(this.hyphIPD, 50, true, new LeafPosition(this, -1), false));
            }
        }
        this.addKnuthElementsForBorderPaddingEnd(linkedList);
        this.setFinished(true);
        return linkedList;
    }
}

