/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.list;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.fo.flow.ListItem;
import org.apache.fop.fo.flow.ListItemBody;
import org.apache.fop.fo.flow.ListItemLabel;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.ConditionalElementListener;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.Keep;
import org.apache.fop.layoutmgr.KnuthBlockBox;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.RelSide;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.list.ListItemContentLayoutManager;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListItemLayoutManager
extends BlockStackingLayoutManager
implements ConditionalElementListener {
    private static Log log = LogFactory.getLog(ListItemLayoutManager.class);
    private ListItemContentLayoutManager label;
    private ListItemContentLayoutManager body;
    private Block curBlockArea = null;
    private List<ListElement> labelList = null;
    private List<ListElement> bodyList = null;
    private boolean discardBorderBefore;
    private boolean discardBorderAfter;
    private boolean discardPaddingBefore;
    private boolean discardPaddingAfter;
    private MinOptMax effSpaceBefore;
    private MinOptMax effSpaceAfter;
    private Keep keepWithNextPendingOnLabel;
    private Keep keepWithNextPendingOnBody;

    public ListItemLayoutManager(ListItem listItem) {
        super(listItem);
        this.setLabel(listItem.getLabel());
        this.setBody(listItem.getBody());
    }

    protected ListItem getListItemFO() {
        return (ListItem)this.fobj;
    }

    public void setLabel(ListItemLabel listItemLabel) {
        this.label = new ListItemContentLayoutManager(listItemLabel);
        this.label.setParent(this);
    }

    public void setBody(ListItemBody listItemBody) {
        this.body = new ListItemContentLayoutManager(listItemBody);
        this.body.setParent(this);
    }

    @Override
    public void initialize() {
        this.foSpaceBefore = new SpaceVal(this.getListItemFO().getCommonMarginBlock().spaceBefore, this).getSpace();
        this.foSpaceAfter = new SpaceVal(this.getListItemFO().getCommonMarginBlock().spaceAfter, this).getSpace();
        this.startIndent = this.getListItemFO().getCommonMarginBlock().startIndent.getValue(this);
        this.endIndent = this.getListItemFO().getCommonMarginBlock().endIndent.getValue(this);
    }

    private void resetSpaces() {
        this.discardBorderBefore = false;
        this.discardBorderAfter = false;
        this.discardPaddingBefore = false;
        this.discardPaddingAfter = false;
        this.effSpaceBefore = null;
        this.effSpaceAfter = null;
    }

    @Override
    public List getNextKnuthElements(LayoutContext layoutContext, int n) {
        this.referenceIPD = layoutContext.getRefIPD();
        LinkedList<ListElement> linkedList = new LinkedList<ListElement>();
        if (!this.breakBeforeServed(layoutContext, linkedList)) {
            return linkedList;
        }
        this.addFirstVisibleMarks(linkedList, layoutContext, n);
        LayoutContext layoutContext2 = this.makeChildLayoutContext(layoutContext);
        this.label.initialize();
        this.labelList = this.label.getNextKnuthElements(layoutContext2, n);
        SpaceResolver.resolveElementList(this.labelList);
        ElementListObserver.observe(this.labelList, "list-item-label", this.label.getPartFO().getId());
        layoutContext.updateKeepWithPreviousPending(layoutContext2.getKeepWithPreviousPending());
        this.keepWithNextPendingOnLabel = layoutContext2.getKeepWithNextPending();
        layoutContext2 = this.makeChildLayoutContext(layoutContext);
        this.body.initialize();
        this.bodyList = this.body.getNextKnuthElements(layoutContext2, n);
        SpaceResolver.resolveElementList(this.bodyList);
        ElementListObserver.observe(this.bodyList, "list-item-body", this.body.getPartFO().getId());
        layoutContext.updateKeepWithPreviousPending(layoutContext2.getKeepWithPreviousPending());
        this.keepWithNextPendingOnBody = layoutContext2.getKeepWithNextPending();
        List list = this.getCombinedKnuthElementsForListItem(this.labelList, this.bodyList, layoutContext);
        this.wrapPositionElements(list, linkedList, true);
        this.addLastVisibleMarks(linkedList, layoutContext, n);
        this.addKnuthElementsForBreakAfter(linkedList, layoutContext);
        layoutContext.updateKeepWithNextPending(this.keepWithNextPendingOnLabel);
        layoutContext.updateKeepWithNextPending(this.keepWithNextPendingOnBody);
        layoutContext.updateKeepWithNextPending(this.getKeepWithNext());
        layoutContext.updateKeepWithPreviousPending(this.getKeepWithPrevious());
        this.setFinished(true);
        this.resetSpaces();
        return linkedList;
    }

    @Override
    protected void addFirstVisibleMarks(List<ListElement> list, LayoutContext layoutContext, int n) {
        this.addKnuthElementsForSpaceBefore(list, n);
        this.addKnuthElementsForBorderPaddingBefore(list, !this.firstVisibleMarkServed);
        this.firstVisibleMarkServed = true;
        this.addPendingMarks(layoutContext);
    }

    private List getCombinedKnuthElementsForListItem(List<ListElement> list, List<ListElement> list2, LayoutContext layoutContext) {
        int n;
        List[] listArray = new List[]{new ArrayList<ListElement>(list), new ArrayList<ListElement>(list2)};
        int[] nArray = new int[]{ElementListUtils.calcContentLength(listArray[0]), ElementListUtils.calcContentLength(listArray[1])};
        int[] nArray2 = new int[]{0, 0};
        int[] nArray3 = new int[]{-1, -1};
        int[] nArray4 = new int[]{-1, -1};
        int n2 = Math.max(nArray[0], nArray[1]);
        int n3 = 0;
        Keep keep = Keep.KEEP_AUTO;
        LinkedList<ListElement> linkedList = new LinkedList<ListElement>();
        while ((n = this.getNextStep(listArray, nArray3, nArray4, nArray2)) > 0) {
            if (nArray4[0] + 1 == listArray[0].size()) {
                keep = keep.compare(this.keepWithNextPendingOnLabel);
            }
            if (nArray4[1] + 1 == listArray[1].size()) {
                keep = keep.compare(this.keepWithNextPendingOnBody);
            }
            int n4 = n + this.getMaxRemainingHeight(nArray, nArray2) - n2;
            int n5 = 0;
            int n6 = 0;
            KnuthElement knuthElement = (KnuthElement)listArray[0].get(nArray4[0]);
            if (knuthElement instanceof KnuthPenalty) {
                n5 = knuthElement.getWidth();
                n6 = Math.max(n6, knuthElement.getPenalty());
            }
            if ((knuthElement = (KnuthElement)listArray[1].get(nArray4[1])) instanceof KnuthPenalty) {
                n5 = Math.max(n5, knuthElement.getWidth());
                n6 = Math.max(n6, knuthElement.getPenalty());
            }
            int n7 = n - n3 - n4;
            n4 += n5;
            LinkedList linkedList2 = null;
            for (int i = 0; i < listArray.length; ++i) {
                for (int j = nArray3[i]; j <= nArray4[i]; ++j) {
                    ListElement listElement = (ListElement)listArray[i].get(j);
                    if (!(listElement instanceof KnuthBlockBox) || !((KnuthBlockBox)listElement).hasAnchors()) continue;
                    if (linkedList2 == null) {
                        linkedList2 = new LinkedList();
                    }
                    linkedList2.addAll(((KnuthBlockBox)listElement).getFootnoteBodyLMs());
                }
            }
            n3 += n7;
            ListItemPosition listItemPosition = new ListItemPosition(this, nArray3[0], nArray4[0], nArray3[1], nArray4[1]);
            if (linkedList2 == null) {
                linkedList.add(new KnuthBox(n7, listItemPosition, false));
            } else {
                linkedList.add(new KnuthBlockBox(n7, linkedList2, listItemPosition, false));
            }
            if (n3 >= n2) continue;
            Keep keep2 = keep.compare(this.getKeepTogether());
            int n8 = n6;
            if (n8 > -1000) {
                n8 = Math.max(n8, keep2.getPenalty());
            }
            linkedList.add(new BreakElement(listItemPosition, n4, n8, keep2.getContext(), layoutContext));
        }
        return linkedList;
    }

    private int getNextStep(List[] listArray, int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        int[] nArray4 = new int[]{nArray3[0], nArray3[1]};
        nArray[0] = nArray2[0] + 1;
        nArray[1] = nArray2[1] + 1;
        int n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            while (nArray2[n] + 1 < listArray[n].size()) {
                int n3 = n;
                nArray2[n3] = nArray2[n3] + 1;
                KnuthElement knuthElement = (KnuthElement)listArray[n].get(nArray2[n]);
                if (knuthElement.isPenalty()) {
                    if (knuthElement.getPenalty() >= 1000) continue;
                    break;
                }
                if (knuthElement.isGlue()) {
                    KnuthElement knuthElement2;
                    if (nArray2[n] > 0 && (knuthElement2 = (KnuthElement)listArray[n].get(nArray2[n] - 1)).isBox()) break;
                    int n4 = n;
                    nArray3[n4] = nArray3[n4] + knuthElement.getWidth();
                    continue;
                }
                int n5 = n;
                nArray3[n5] = nArray3[n5] + knuthElement.getWidth();
            }
            if (nArray2[n] < nArray[n]) {
                nArray3[n] = nArray4[n];
                continue;
            }
            ++n2;
        }
        if (n2 == 0) {
            return 0;
        }
        n = nArray4[0] == 0 && nArray4[1] == 0 ? Math.max(nArray2[0] >= nArray[0] ? nArray3[0] : Integer.MIN_VALUE, nArray2[1] >= nArray[1] ? nArray3[1] : Integer.MIN_VALUE) : Math.min(nArray2[0] >= nArray[0] ? nArray3[0] : Integer.MAX_VALUE, nArray2[1] >= nArray[1] ? nArray3[1] : Integer.MAX_VALUE);
        for (int i = 0; i < nArray3.length; ++i) {
            if (nArray3[i] <= n) continue;
            nArray3[i] = nArray4[i];
            nArray2[i] = nArray[i] - 1;
        }
        return n;
    }

    private int getMaxRemainingHeight(int[] nArray, int[] nArray2) {
        return Math.max(nArray[0] - nArray2[0], nArray[1] - nArray2[1]);
    }

    @Override
    public List getChangedKnuthElements(List list, int n) {
        Object object;
        this.labelList = this.label.getChangedKnuthElements(this.labelList, n);
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            KnuthElement knuthElement = (KnuthElement)listIterator.next();
            object = knuthElement.getPosition().getPosition();
            if (object != null) {
                knuthElement.setPosition((Position)object);
                continue;
            }
            knuthElement.setPosition(new Position(this));
        }
        object = this.body.getChangedKnuthElements(list, n);
        List list2 = object;
        object = new LinkedList<KnuthElement>();
        ListIterator listIterator2 = list2.listIterator();
        while (listIterator2.hasNext()) {
            KnuthElement knuthElement = (KnuthElement)listIterator2.next();
            knuthElement.setPosition(new NonLeafPosition((LayoutManager)this, knuthElement.getPosition()));
            object.add(knuthElement);
        }
        return object;
    }

    @Override
    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        KnuthPossPosIter knuthPossPosIter;
        this.getParentArea(null);
        this.addId();
        LayoutContext layoutContext2 = new LayoutContext(0);
        Position position = null;
        Position position2 = null;
        LinkedList<Position> linkedList = new LinkedList<Position>();
        while (positionIterator.hasNext()) {
            Position position3 = positionIterator.next();
            if (position3.getIndex() >= 0) {
                if (position == null) {
                    position = position3;
                }
                position2 = position3;
            }
            if (!(position3 instanceof NonLeafPosition) || position3.getPosition() == null) continue;
            linkedList.add(position3.getPosition());
        }
        this.addMarkersToPage(true, this.isFirst(position), this.isLast(position2));
        int n = ((ListItemPosition)linkedList.getFirst()).getLabelFirstIndex();
        int n2 = ((ListItemPosition)linkedList.getLast()).getLabelLastIndex();
        int n3 = ((ListItemPosition)linkedList.getFirst()).getBodyFirstIndex();
        int n4 = ((ListItemPosition)linkedList.getLast()).getBodyLastIndex();
        int n5 = ElementListUtils.determinePreviousBreak(this.labelList, n);
        SpaceResolver.performConditionalsNotification(this.labelList, n, n2, n5);
        n5 = ElementListUtils.determinePreviousBreak(this.bodyList, n3);
        SpaceResolver.performConditionalsNotification(this.bodyList, n3, n4, n5);
        if (n <= n2) {
            knuthPossPosIter = new KnuthPossPosIter(this.labelList, n, n2 + 1);
            layoutContext2.setFlags(32, layoutContext.isFirstArea());
            layoutContext2.setFlags(128, layoutContext.isLastArea());
            layoutContext2.setSpaceAdjust(layoutContext.getSpaceAdjust());
            layoutContext2.setStackLimitBP(layoutContext.getStackLimitBP());
            this.label.addAreas(knuthPossPosIter, layoutContext2);
        }
        if (n3 <= n4) {
            knuthPossPosIter = new KnuthPossPosIter(this.bodyList, n3, n4 + 1);
            layoutContext2.setFlags(32, layoutContext.isFirstArea());
            layoutContext2.setFlags(128, layoutContext.isLastArea());
            layoutContext2.setSpaceAdjust(layoutContext.getSpaceAdjust());
            layoutContext2.setStackLimitBP(layoutContext.getStackLimitBP());
            this.body.addAreas(knuthPossPosIter, layoutContext2);
        }
        int n6 = this.curBlockArea.getChildAreas().size();
        assert (n6 >= 1 && n6 <= 2);
        int n7 = ((Block)this.curBlockArea.getChildAreas().get(0)).getAllocBPD();
        if (n6 == 2) {
            n7 = Math.max(n7, ((Block)this.curBlockArea.getChildAreas().get(1)).getAllocBPD());
        }
        this.curBlockArea.setBPD(n7);
        this.addMarkersToPage(false, this.isFirst(position), this.isLast(position2));
        TraitSetter.addBackground(this.curBlockArea, this.getListItemFO().getCommonBorderPaddingBackground(), this);
        TraitSetter.addSpaceBeforeAfter(this.curBlockArea, layoutContext.getSpaceAdjust(), this.effSpaceBefore, this.effSpaceAfter);
        this.flush();
        this.curBlockArea = null;
        this.resetSpaces();
        this.checkEndOfLayout(position2);
    }

    @Override
    public Area getParentArea(Area area) {
        if (this.curBlockArea == null) {
            this.curBlockArea = new Block();
            this.parentLayoutManager.getParentArea(this.curBlockArea);
            ListItem listItem = this.getListItemFO();
            TraitSetter.setProducerID(this.curBlockArea, listItem.getId());
            TraitSetter.addBorders(this.curBlockArea, listItem.getCommonBorderPaddingBackground(), this.discardBorderBefore, this.discardBorderAfter, false, false, this);
            TraitSetter.addPadding(this.curBlockArea, listItem.getCommonBorderPaddingBackground(), this.discardPaddingBefore, this.discardPaddingAfter, false, false, this);
            TraitSetter.addMargins(this.curBlockArea, listItem.getCommonBorderPaddingBackground(), listItem.getCommonMarginBlock(), this);
            TraitSetter.addBreaks(this.curBlockArea, listItem.getBreakBefore(), listItem.getBreakAfter());
            int n = this.referenceIPD - this.getIPIndents();
            this.curBlockArea.setIPD(n);
            this.setCurrentArea(this.curBlockArea);
        }
        return this.curBlockArea;
    }

    @Override
    public void addChildArea(Area area) {
        if (this.curBlockArea != null) {
            this.curBlockArea.addBlock((Block)area);
        }
    }

    @Override
    public KeepProperty getKeepTogetherProperty() {
        return this.getListItemFO().getKeepTogether();
    }

    @Override
    public KeepProperty getKeepWithPreviousProperty() {
        return this.getListItemFO().getKeepWithPrevious();
    }

    @Override
    public KeepProperty getKeepWithNextProperty() {
        return this.getListItemFO().getKeepWithNext();
    }

    @Override
    public void notifySpace(RelSide relSide, MinOptMax minOptMax) {
        if (RelSide.BEFORE == relSide) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + ": Space " + relSide + ", " + this.effSpaceBefore + "-> " + minOptMax));
            }
            this.effSpaceBefore = minOptMax;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + ": Space " + relSide + ", " + this.effSpaceAfter + "-> " + minOptMax));
            }
            this.effSpaceAfter = minOptMax;
        }
    }

    @Override
    public void notifyBorder(RelSide relSide, MinOptMax minOptMax) {
        if (minOptMax == null) {
            if (RelSide.BEFORE == relSide) {
                this.discardBorderBefore = true;
            } else {
                this.discardBorderAfter = true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": Border " + relSide + " -> " + minOptMax));
        }
    }

    @Override
    public void notifyPadding(RelSide relSide, MinOptMax minOptMax) {
        if (minOptMax == null) {
            if (RelSide.BEFORE == relSide) {
                this.discardPaddingBefore = true;
            } else {
                this.discardPaddingAfter = true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": Padding " + relSide + " -> " + minOptMax));
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.label.reset();
        this.body.reset();
    }

    private class ListItemPosition
    extends Position {
        private int labelFirstIndex;
        private int labelLastIndex;
        private int bodyFirstIndex;
        private int bodyLastIndex;

        public ListItemPosition(LayoutManager layoutManager, int n, int n2, int n3, int n4) {
            super(layoutManager);
            this.labelFirstIndex = n;
            this.labelLastIndex = n2;
            this.bodyFirstIndex = n3;
            this.bodyLastIndex = n4;
        }

        public int getLabelFirstIndex() {
            return this.labelFirstIndex;
        }

        public int getLabelLastIndex() {
            return this.labelLastIndex;
        }

        public int getBodyFirstIndex() {
            return this.bodyFirstIndex;
        }

        public int getBodyLastIndex() {
            return this.bodyLastIndex;
        }

        public boolean generatesAreas() {
            return true;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("ListItemPosition:");
            stringBuffer.append(this.getIndex()).append("(");
            stringBuffer.append("label:").append(this.labelFirstIndex).append("-").append(this.labelLastIndex);
            stringBuffer.append(" body:").append(this.bodyFirstIndex).append("-").append(this.bodyLastIndex);
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }
}

