/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFilterList;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.StreamCache;
import org.apache.fop.pdf.StreamCacheFactory;
import org.apache.fop.util.CloseBlockerOutputStream;

public abstract class AbstractPDFStream
extends PDFObject {
    private final PDFDictionary dictionary;
    private PDFFilterList filters;
    private final boolean encodeOnTheFly;

    protected AbstractPDFStream() {
        this(true);
    }

    protected AbstractPDFStream(PDFDictionary pDFDictionary) {
        this(pDFDictionary, true);
    }

    protected AbstractPDFStream(boolean bl) {
        this(new PDFDictionary(), bl);
    }

    protected AbstractPDFStream(PDFDictionary pDFDictionary, boolean bl) {
        this.dictionary = pDFDictionary;
        this.encodeOnTheFly = bl;
    }

    protected final PDFDictionary getDictionary() {
        return this.dictionary;
    }

    protected Object get(String string) {
        return this.dictionary.get(string);
    }

    public void put(String string, Object object) {
        this.dictionary.put(string, object);
    }

    protected void setupFilterList() {
        if (this.multipleFiltersAllowed() && !this.getFilterList().isInitialized()) {
            this.getFilterList().addDefaultFilters(this.getDocumentSafely().getFilterMap(), this.getDefaultFilterName());
        }
        this.prepareImplicitFilters();
        this.getDocument().applyEncryption(this);
    }

    protected String getDefaultFilterName() {
        return "default";
    }

    public PDFFilterList getFilterList() {
        if (this.filters == null) {
            boolean bl;
            this.filters = this.getDocument() == null ? new PDFFilterList() : new PDFFilterList(this.getDocument().isEncryptionActive());
            boolean bl2 = bl = this.get("Filter") != null;
            if (bl) {
                this.filters.setDisableAllFilters(true);
            }
        }
        return this.filters;
    }

    protected abstract int getSizeHint() throws IOException;

    protected abstract void outputRawStreamData(OutputStream var1) throws IOException;

    protected int outputStreamData(StreamCache streamCache, OutputStream outputStream) throws IOException {
        int n = 0;
        byte[] byArray = AbstractPDFStream.encode("stream\n");
        outputStream.write(byArray);
        n += byArray.length;
        streamCache.outputContents(outputStream);
        n += streamCache.getSize();
        byArray = AbstractPDFStream.encode("\nendstream");
        outputStream.write(byArray);
        return n += byArray.length;
    }

    protected StreamCache encodeStream() throws IOException {
        StreamCache streamCache = StreamCacheFactory.getInstance().createStreamCache(this.getSizeHint());
        OutputStream outputStream = this.getFilterList().applyFilters(streamCache.getOutputStream());
        this.outputRawStreamData(outputStream);
        outputStream.flush();
        outputStream.close();
        return streamCache;
    }

    protected int encodeAndWriteStream(OutputStream outputStream, PDFNumber pDFNumber) throws IOException {
        int n = 0;
        byte[] byArray = AbstractPDFStream.encode("stream\n");
        outputStream.write(byArray);
        n += byArray.length;
        CloseBlockerOutputStream closeBlockerOutputStream = new CloseBlockerOutputStream(outputStream);
        CountingOutputStream countingOutputStream = new CountingOutputStream((OutputStream)((Object)closeBlockerOutputStream));
        OutputStream outputStream2 = this.getFilterList().applyFilters((OutputStream)countingOutputStream);
        this.outputRawStreamData(outputStream2);
        outputStream2.close();
        pDFNumber.setNumber(countingOutputStream.getCount());
        n += countingOutputStream.getCount();
        byArray = AbstractPDFStream.encode("\nendstream");
        outputStream.write(byArray);
        return n += byArray.length;
    }

    public int output(OutputStream outputStream) throws IOException {
        Object object;
        this.setupFilterList();
        CountingOutputStream countingOutputStream = new CountingOutputStream(outputStream);
        StringBuilder stringBuilder = new StringBuilder(64);
        StreamCache streamCache = null;
        PDFNumber pDFNumber = null;
        if (this.encodeOnTheFly) {
            pDFNumber = new PDFNumber();
            this.getDocumentSafely().registerObject(pDFNumber);
            object = pDFNumber;
        } else {
            streamCache = this.encodeStream();
            object = streamCache.getSize() + 1;
        }
        this.populateStreamDict(object);
        this.dictionary.writeDictionary((OutputStream)countingOutputStream, stringBuilder);
        PDFDocument.flushTextBuffer(stringBuilder, (OutputStream)countingOutputStream);
        if (streamCache == null) {
            this.encodeAndWriteStream((OutputStream)countingOutputStream, pDFNumber);
        } else {
            this.outputStreamData(streamCache, (OutputStream)countingOutputStream);
            streamCache.clear();
        }
        PDFDocument.flushTextBuffer(stringBuilder, (OutputStream)countingOutputStream);
        return countingOutputStream.getCount();
    }

    public void setDocument(PDFDocument pDFDocument) {
        this.dictionary.setDocument(pDFDocument);
        super.setDocument(pDFDocument);
    }

    protected void populateStreamDict(Object object) {
        this.put("Length", object);
        if (!this.getFilterList().isDisableAllFilters()) {
            this.getFilterList().putFilterDictEntries(this.dictionary);
        }
    }

    protected void prepareImplicitFilters() {
    }

    protected boolean multipleFiltersAllowed() {
        return true;
    }
}

