/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFImage;
import org.apache.fop.pdf.PDFReference;
import org.apache.xmlgraphics.image.GraphicsUtil;

public class AlphaRasterImage
implements PDFImage {
    private int bitsPerComponent;
    private PDFDeviceColorSpace colorSpace;
    private Raster alpha;
    private String key;

    public AlphaRasterImage(String string, Raster raster) {
        this.key = string;
        this.bitsPerComponent = 8;
        this.colorSpace = new PDFDeviceColorSpace(1);
        if (raster == null) {
            throw new NullPointerException("Parameter alpha must not be null");
        }
        this.alpha = raster;
    }

    public AlphaRasterImage(String string, RenderedImage renderedImage) {
        this(string, GraphicsUtil.getAlphaRaster((RenderedImage)renderedImage));
    }

    public void setup(PDFDocument pDFDocument) {
    }

    public String getKey() {
        return this.key;
    }

    public int getWidth() {
        return this.alpha.getWidth();
    }

    public int getHeight() {
        return this.alpha.getHeight();
    }

    public PDFDeviceColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public int getBitsPerComponent() {
        return this.bitsPerComponent;
    }

    public boolean isTransparent() {
        return false;
    }

    public PDFColor getTransparentColor() {
        return null;
    }

    public String getMask() {
        return null;
    }

    public String getSoftMask() {
        return null;
    }

    public PDFReference getSoftMaskReference() {
        return null;
    }

    public boolean isInverted() {
        return false;
    }

    public void outputContents(OutputStream outputStream) throws IOException {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.alpha.getNumBands();
        if (n3 != 1) {
            throw new UnsupportedOperationException("Expected only one band/component for the alpha channel");
        }
        int n4 = this.alpha.getDataBuffer().getDataType();
        if (n4 == 0) {
            byte[] byArray = new byte[n3 * n];
            for (int i = 0; i < n2; ++i) {
                this.alpha.getDataElements(0, i, n, 1, byArray);
                outputStream.write(byArray);
            }
        } else if (n4 == 1) {
            short[] sArray = new short[n3 * n];
            byte[] byArray = new byte[n3 * n];
            for (int i = 0; i < n2; ++i) {
                this.alpha.getDataElements(0, i, n, 1, sArray);
                for (int j = 0; j < n; ++j) {
                    byArray[j] = (byte)(sArray[j] >> 8);
                }
                outputStream.write(byArray);
            }
        } else if (n4 == 3) {
            Object object;
            int n5 = 24;
            SampleModel sampleModel = this.alpha.getSampleModel();
            if (sampleModel instanceof SinglePixelPackedSampleModel) {
                object = (SinglePixelPackedSampleModel)sampleModel;
                n5 = ((SinglePixelPackedSampleModel)object).getBitOffsets()[0];
            }
            object = new int[n3 * n];
            byte[] byArray = new byte[n3 * n];
            for (int i = 0; i < n2; ++i) {
                this.alpha.getDataElements(0, i, n, 1, object);
                for (int j = 0; j < n; ++j) {
                    byArray[j] = (byte)(object[j] >> n5);
                }
                outputStream.write(byArray);
            }
        } else {
            throw new UnsupportedOperationException("Unsupported DataBuffer type: " + this.alpha.getDataBuffer().getClass().getName());
        }
    }

    public void populateXObjectDictionary(PDFDictionary pDFDictionary) {
    }

    public PDFICCStream getICCStream() {
        return null;
    }

    public boolean isPS() {
        return false;
    }

    public String getFilterHint() {
        return "image";
    }

    public PDFFilter getPDFFilter() {
        return null;
    }

    public boolean multipleFiltersAllowed() {
        return true;
    }
}

