/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.pdf.PDFAction;
import org.apache.fop.pdf.PDFFileSpec;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFReference;

public class PDFGoToRemote
extends PDFAction {
    private PDFReference pdfFileSpec;
    private int pageReference = 0;
    private String destination = null;
    private boolean newWindow = false;

    public PDFGoToRemote(PDFFileSpec pDFFileSpec, boolean bl) {
        this.pdfFileSpec = pDFFileSpec.makeReference();
        this.newWindow = bl;
    }

    public PDFGoToRemote(PDFFileSpec pDFFileSpec, int n, boolean bl) {
        this(pDFFileSpec.makeReference(), n, bl);
    }

    public PDFGoToRemote(PDFReference pDFReference, int n, boolean bl) {
        this.pdfFileSpec = pDFReference;
        this.pageReference = n;
        this.newWindow = bl;
    }

    public PDFGoToRemote(PDFFileSpec pDFFileSpec, String string, boolean bl) {
        this.pdfFileSpec = pDFFileSpec.makeReference();
        this.destination = string;
        this.newWindow = bl;
    }

    public String getAction() {
        return this.referencePDF();
    }

    public String toPDFString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("<<\n/S /GoToR\n/F ");
        stringBuffer.append(this.pdfFileSpec.toString());
        stringBuffer.append("\n");
        if (this.destination != null) {
            stringBuffer.append("/D (").append(this.destination).append(")");
        } else {
            stringBuffer.append("/D [ ").append(this.pageReference).append(" /XYZ null null null ]");
        }
        if (this.newWindow) {
            stringBuffer.append("/NewWindow true");
        }
        stringBuffer.append("\n>>");
        return stringBuffer.toString();
    }

    protected boolean contentEquals(PDFObject pDFObject) {
        if (this == pDFObject) {
            return true;
        }
        if (pDFObject == null || !(pDFObject instanceof PDFGoToRemote)) {
            return false;
        }
        PDFGoToRemote pDFGoToRemote = (PDFGoToRemote)pDFObject;
        if (!pDFGoToRemote.pdfFileSpec.toString().equals(this.pdfFileSpec.toString())) {
            return false;
        }
        if (this.destination != null ? !this.destination.equals(pDFGoToRemote.destination) : this.pageReference != pDFGoToRemote.pageReference) {
            return false;
        }
        return this.newWindow == pDFGoToRemote.newWindow;
    }
}

