/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.fop.pdf.PDFColorSpace;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFObject;
import org.apache.xmlgraphics.java2d.color.profile.ColorProfileUtil;

public class PDFICCBasedColorSpace
extends PDFObject
implements PDFColorSpace {
    private PDFICCStream iccStream;
    private String explicitName;
    private int numComponents;

    public PDFICCBasedColorSpace(String string, PDFICCStream pDFICCStream) {
        this.explicitName = string;
        this.iccStream = pDFICCStream;
        this.numComponents = pDFICCStream.getICCProfile().getNumComponents();
    }

    public PDFICCBasedColorSpace(PDFICCStream pDFICCStream) {
        this(null, pDFICCStream);
    }

    public PDFICCStream getICCStream() {
        return this.iccStream;
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public String getName() {
        if (this.explicitName != null) {
            return this.explicitName;
        }
        return "ICC" + this.iccStream.getObjectNumber();
    }

    public boolean isDeviceColorSpace() {
        return false;
    }

    public boolean isRGBColorSpace() {
        return this.getNumComponents() == 3;
    }

    public boolean isCMYKColorSpace() {
        return this.getNumComponents() == 4;
    }

    public boolean isGrayColorSpace() {
        return this.getNumComponents() == 1;
    }

    protected String toPDFString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("[/ICCBased ").append(this.getICCStream().referencePDF()).append("]");
        return stringBuffer.toString();
    }

    public static PDFICCBasedColorSpace setupsRGBAsDefaultRGBColorSpace(PDFDocument pDFDocument) {
        PDFICCStream pDFICCStream = PDFICCBasedColorSpace.setupsRGBColorProfile(pDFDocument);
        return pDFDocument.getFactory().makeICCBasedColorSpace(null, "DefaultRGB", pDFICCStream);
    }

    public static PDFICCBasedColorSpace setupsRGBColorSpace(PDFDocument pDFDocument) {
        PDFICCStream pDFICCStream = PDFICCBasedColorSpace.setupsRGBColorProfile(pDFDocument);
        return pDFDocument.getFactory().makeICCBasedColorSpace(null, null, pDFICCStream);
    }

    public static PDFICCStream setupsRGBColorProfile(PDFDocument pDFDocument) {
        ICC_Profile iCC_Profile;
        PDFICCStream pDFICCStream = pDFDocument.getFactory().makePDFICCStream();
        InputStream inputStream = PDFDocument.class.getResourceAsStream("sRGB Color Space Profile.icm");
        if (inputStream != null) {
            try {
                iCC_Profile = ColorProfileUtil.getICC_Profile((InputStream)inputStream);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Unexpected IOException loading the sRGB profile: " + iOException.getMessage());
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        } else {
            iCC_Profile = ColorProfileUtil.getICC_Profile((int)1000);
        }
        pDFICCStream.setColorSpace(iCC_Profile, null);
        return pDFICCStream;
    }
}

